/*
 * Java-Gnome Bindings Library
 *
 * * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gtkhtml.event;

import org.gnu.glib.EventType;
import org.gnu.gtk.event.GtkEvent;
import org.gnu.gtkhtml.HTMLStream;

/**
 * An event representing an action generated by an {@link 
 * org.gnu.gtkhtml.HTMLDocument} widget.
 */
public class HTMLDocumentEvent extends GtkEvent {
	
    private String url = null;
    private String method = null;
    private String encoding = null;
    private HTMLStream stream = null;

    /**
     * Type of HTMLDocumentEvent.
     */
    public static class Type extends EventType {
        private Type(int id, String name) {
            super(id, name);
        }

        public static final Type REQUEST_URL = new Type(1, "REQUEST_URL");
        public static final Type LINK_CLICKED = new Type(2, "LINK_CLICKED");
        public static final Type SET_BASE = new Type( 3, "SET_BASE");
        public static final Type TITLE_CHANGED = new Type( 4, "TITLE_CHANGED");
        public static final Type SUBMIT = new Type(5, "SUBMIT");
    }

    /**
     * Creates a new Button HTMLDocumentEvent. 
     * This is used internally by java-gnome. Users
     * only have to deal with listeners.
     */
    public HTMLDocumentEvent(Object source, HTMLDocumentEvent.Type type) {
        super(source, type);
    }

    /**
     * @return True if the type of this event is the same as that stated.
     */
    public boolean isOfType(HTMLDocumentEvent.Type aType) {
        return (type.getID() == aType.getID());
    }

    /**
     * This field is used for every event.  For SET_BASE events, it will
     * be the base URL.  For TITLE_CHANGED events, it will be the page
     * title.  For the other events, it will be the requested URL.
     */
    public String getURL() {
        return url;
    }

    /**
     * This field is used for every event.
     */
    public void setURL(String u) {
        url = u;
    }

    /**
     * This field is used only during a SUBMIT event.
     */
    public String getEncoding() {
        return encoding;
    }
	
    /**
     * This field is used only during a SUBMIT event.
     */
    public void setEncoding(String e) {
        encoding = e;
    }
	
    /**
     * This field is used only during a SUBMIT event.
     */
    public String getMethod() {
        return method;
    }
	
    /**
     * This field is used only during a SUBMIT event.
     */
    public void setMethod(String m) {
        method = m;
    }

    /**
     * This field is used only during a REQUEST_URL event.
     */
    public HTMLStream getHtmlStream() {
        return stream;
    }

    /**
     * This field is used only during a REQUEST_URL event.
     */
    public void setHtmlStream( HTMLStream s ) {
        stream = s;
    }
}
