using System;
using System.Runtime.InteropServices;

namespace Evolution {
	public class GLibUtil {
		public static DateTime local_epoch = new DateTime (1970, 1, 1);

		public static int DateTimeToUnixtime_t (DateTime time)
		{
			return ((int)time.Subtract (local_epoch).TotalSeconds);
		}
	
		[DllImport("glib-2.0")]
		public static extern int g_slist_length (IntPtr slist);
		
                [DllImport("glibsharpglue")]
                public static extern IntPtr gtksharp_slist_get_data (IntPtr slist);

		[DllImport("glibsharpglue")]
		public static extern  IntPtr gtksharp_slist_get_next (IntPtr slist);
 
		[DllImport("glib-2.0")]
		public static extern void g_slist_free (IntPtr slist);

		public static string[] GLibSListToStringArray (IntPtr slist, bool free_list_mem)
		{
			string[] ret;
			int i = 0;
			IntPtr iter = IntPtr.Zero;
			
			ret = new string [g_slist_length (slist)];
	
			//
			// The unmanaged-pointers are freed by the caller
			//
			for (i = 0, iter=slist; iter != IntPtr.Zero; iter = gtksharp_slist_get_next (iter), i++) {
				if (!free_list_mem)
					ret[i] = Marshal.PtrToStringAnsi (gtksharp_slist_get_data (iter));
				else
					ret[i] = GLib.Marshaller.PtrToStringGFree (gtksharp_slist_get_data (iter));
			}
			if (free_list_mem)
				g_slist_free (slist);
			return ret;
		}		
	}
}
