/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.pango;
import org.gnu.glib.Enum;


/**
 * An enumeration specifying the width of the font relative to other designs
 * within a family.
 */
public class Stretch extends Enum 
{
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    static final private int _ULTRA_CONDENSED = 0;
    static final public org.gnu.pango.Stretch ULTRA_CONDENSED = new org.gnu.pango.Stretch (
        _ULTRA_CONDENSED);
    static final private int _EXTRA_CONDENSED = 1;
    static final public org.gnu.pango.Stretch EXTRA_CONDENSED = new org.gnu.pango.Stretch (
        _EXTRA_CONDENSED);
    static final private int _CONDENSED = 2;
    static final public org.gnu.pango.Stretch CONDENSED = new org.gnu.pango.Stretch (_CONDENSED);
    static final private int _SEMI_CONDENSED = 3;
    static final public org.gnu.pango.Stretch SEMI_CONDENSED = new org.gnu.pango.Stretch (
        _SEMI_CONDENSED);
    static final private int _NORMAL = 4;
    static final public org.gnu.pango.Stretch NORMAL = new org.gnu.pango.Stretch (_NORMAL);
    static final private int _SEMI_EXPANDED = 5;
    static final public org.gnu.pango.Stretch SEMI_EXPANDED = new org.gnu.pango.Stretch (
        _SEMI_EXPANDED);
    static final private int _EXPANDED = 6;
    static final public org.gnu.pango.Stretch EXPANDED = new org.gnu.pango.Stretch (_EXPANDED);
    static final private int _EXTRA_EXPANDED = 7;
    static final public org.gnu.pango.Stretch EXTRA_EXPANDED = new org.gnu.pango.Stretch (
        _EXTRA_EXPANDED);
    static final private int _ULTRA_EXPANDED = 8;
    static final public org.gnu.pango.Stretch ULTRA_EXPANDED = new org.gnu.pango.Stretch (
        _ULTRA_EXPANDED);
    static final private org.gnu.pango.Stretch[] theInterned = new org.gnu.pango.Stretch[] 
    {
        ULTRA_CONDENSED, EXTRA_CONDENSED, CONDENSED, SEMI_CONDENSED, NORMAL, SEMI_EXPANDED, 
        EXPANDED, EXTRA_EXPANDED, ULTRA_EXPANDED 
    }

;
    static private java.util.Hashtable theInternedExtras;
    static final private org.gnu.pango.Stretch theSacrificialOne = new org.gnu.pango.Stretch (0);
    static public org.gnu.pango.Stretch intern (int value) 
    {
        if (value < theInterned.length) 
        {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) 
        {
            theInternedExtras = new java.util.Hashtable();
        }
        org.gnu.pango.Stretch already = (org.gnu.pango.Stretch) theInternedExtras.get (
            theSacrificialOne);
        if (already == null) 
        {
            already = new org.gnu.pango.Stretch(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private Stretch (int value) 
    {
        value_ = value;
    }

    public org.gnu.pango.Stretch or (org.gnu.pango.Stretch other) 
    {
        return intern(value_ | other.value_);
    }

    public org.gnu.pango.Stretch and (org.gnu.pango.Stretch other) 
    {
        return intern(value_ & other.value_);
    }

    public org.gnu.pango.Stretch xor (org.gnu.pango.Stretch other) 
    {
        return intern(value_ ^ other.value_);
    }

    public boolean test (org.gnu.pango.Stretch other) 
    {
        return (value_ & other.value_) == other.value_;
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

