/*
 * Java-Gnome Bindings Library
 *
 * Copyright 2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.GObject;

public class TreeModelFilter extends GObject {
    public TreeModelFilter(int handle) {
        super(handle);
    }

    public TreeModel getModel() {
        return (TreeModel)retrieveGObject(getModel(getHandle()));
    }

    private static native int getModel(int handle);
    native private static void gtk_tree_model_filter_get_model( int filter );
    native private static void gtk_tree_model_filter_new( int model, int treepath_root );
    native private static void gtk_tree_model_filter_convert_iter_to_child_iter( int filter, int filter_iter, int child_iter );
    native private static void gtk_tree_model_filter_convert_path_to_child_path( int filter, int filter_path );
    native private static void gtk_tree_model_filter_convert_child_path_to_path( int filter, int child_path );
    native private static void gtk_tree_model_filter_refilter( int filter );
    native private static void gtk_tree_model_filter_clear_cache( int filter );
    native private static void gtk_tree_model_filter_set_visible_column( int filter, int column );
    native private static void gtk_tree_model_filter_convert_child_iter_to_iter( int filter, int filter_iter, int child_iter );

    //native private static gtk_tree_model_filter_get_type();
    //native private static gtk_tree_model_filter_set_visible_func
    //native private static gtk_tree_model_filter_set_modify_func
}
