/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#ifdef __cplusplus
extern "C" 
{
#endif
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_get_type
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1get_1type (JNIEnv *env, jclass 
        cls) 
    {
        {
            return (jint)gtk_notebook_get_type ();
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_new
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1new (JNIEnv *env, jclass cls) 
    {
        {
            return (jint)gtk_notebook_new ();
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_append_page
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1append_1page (JNIEnv *env, 
        jclass cls, jint notebook, jint child, jint tabLabel) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        GtkWidget *child_g = (GtkWidget *)child;
        GtkWidget *tabLabel_g = (GtkWidget *)tabLabel;
        {
            gtk_notebook_append_page (notebook_g, child_g, tabLabel_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_append_page_menu
     * Signature: (IIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1append_1page_1menu (JNIEnv 
        *env, jclass cls, jint notebook, jint child, jint tabLabel, jint menuLabel) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        GtkWidget *child_g = (GtkWidget *)child;
        GtkWidget *tabLabel_g = (GtkWidget *)tabLabel;
        GtkWidget *menuLabel_g = (GtkWidget *)menuLabel;
        {
            gtk_notebook_append_page_menu (notebook_g, child_g, tabLabel_g, menuLabel_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_prepend_page
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1prepend_1page (JNIEnv *env, 
        jclass cls, jint notebook, jint child, jint tabLabel) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        GtkWidget *child_g = (GtkWidget *)child;
        GtkWidget *tabLabel_g = (GtkWidget *)tabLabel;
        {
            gtk_notebook_prepend_page (notebook_g, child_g, tabLabel_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_prepend_page_menu
     * Signature: (IIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1prepend_1page_1menu (JNIEnv 
        *env, jclass cls, jint notebook, jint child, jint tabLabel, jint menuLabel) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        GtkWidget *child_g = (GtkWidget *)child;
        GtkWidget *tabLabel_g = (GtkWidget *)tabLabel;
        GtkWidget *menuLabel_g = (GtkWidget *)menuLabel;
        {
            gtk_notebook_prepend_page_menu (notebook_g, child_g, tabLabel_g, menuLabel_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_insert_page
     * Signature: (IIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1insert_1page (JNIEnv *env, 
        jclass cls, jint notebook, jint child, jint tabLabel, jint position) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        GtkWidget *child_g = (GtkWidget *)child;
        GtkWidget *tabLabel_g = (GtkWidget *)tabLabel;
        gint32 position_g = (gint32) position;
        {
            gtk_notebook_insert_page (notebook_g, child_g, tabLabel_g, position_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_insert_page_menu
     * Signature: (IIIII)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1insert_1page_1menu (JNIEnv 
        *env, jclass cls, jint notebook, jint child, jint tabLabel, jint menuLabel, jint position) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        GtkWidget *child_g = (GtkWidget *)child;
        GtkWidget *tabLabel_g = (GtkWidget *)tabLabel;
        GtkWidget *menuLabel_g = (GtkWidget *)menuLabel;
        gint32 position_g = (gint32) position;
        {
            gtk_notebook_insert_page_menu (notebook_g, child_g, tabLabel_g, menuLabel_g, position_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_remove_page
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1remove_1page (JNIEnv *env, 
        jclass cls, jint notebook, jint pageNum) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        gint32 pageNum_g = (gint32) pageNum;
        {
            gtk_notebook_remove_page (notebook_g, pageNum_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_get_current_page
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1get_1current_1page (JNIEnv 
        *env, jclass cls, jint notebook) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        {
            jint result_j = (jint) (gtk_notebook_get_current_page (notebook_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_get_nth_page
     * Signature: (II)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1get_1nth_1page (JNIEnv *env, 
        jclass cls, jint notebook, jint pageNum) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        gint32 pageNum_g = (gint32) pageNum;
        {
            return (jint)gtk_notebook_get_nth_page (notebook_g, pageNum_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_page_num
     * Signature: (II)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1page_1num (JNIEnv *env, jclass 
        cls, jint notebook, jint child) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        GtkWidget *child_g = (GtkWidget *)child;
        {
            jint result_j = (jint) (gtk_notebook_page_num (notebook_g, child_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_set_current_page
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1set_1current_1page (JNIEnv 
        *env, jclass cls, jint notebook, jint pageNum) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        gint32 pageNum_g = (gint32) pageNum;
        {
            gtk_notebook_set_current_page (notebook_g, pageNum_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_next_page
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1next_1page (JNIEnv *env, jclass 
        cls, jint notebook) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        {
            gtk_notebook_next_page (notebook_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_prev_page
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1prev_1page (JNIEnv *env, jclass 
        cls, jint notebook) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        {
            gtk_notebook_prev_page (notebook_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_set_show_border
     * Signature: (IZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1set_1show_1border (JNIEnv *env, 
        jclass cls, jint notebook, jboolean showBorder) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        gboolean showBorder_g = (gboolean) showBorder;
        {
            gtk_notebook_set_show_border (notebook_g, showBorder_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_get_show_border
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1get_1show_1border (JNIEnv 
        *env, jclass cls, jint notebook) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        {
            jboolean result_j = (jboolean) (gtk_notebook_get_show_border (notebook_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_set_show_tabs
     * Signature: (IZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1set_1show_1tabs (JNIEnv *env, 
        jclass cls, jint notebook, jboolean showTabs) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        gboolean showTabs_g = (gboolean) showTabs;
        {
            gtk_notebook_set_show_tabs (notebook_g, showTabs_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_get_show_tabs
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1get_1show_1tabs (JNIEnv 
        *env, jclass cls, jint notebook) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        {
            jboolean result_j = (jboolean) (gtk_notebook_get_show_tabs (notebook_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_set_tab_pos
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1set_1tab_1pos (JNIEnv *env, 
        jclass cls, jint notebook, jint pos) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        GtkPositionType pos_g = (GtkPositionType) pos;
        {
            gtk_notebook_set_tab_pos (notebook_g, pos_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_get_tab_pos
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1get_1tab_1pos (JNIEnv *env, 
        jclass cls, jint notebook) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        {
            jint result_j = (jint) (gtk_notebook_get_tab_pos (notebook_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_set_scrollable
     * Signature: (IZ)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1set_1scrollable (JNIEnv *env, 
        jclass cls, jint notebook, jboolean scrollable) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        gboolean scrollable_g = (gboolean) scrollable;
        {
            gtk_notebook_set_scrollable (notebook_g, scrollable_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_get_scrollable
     * Signature: (I)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1get_1scrollable (JNIEnv 
        *env, jclass cls, jint notebook) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        {
            jboolean result_j = (jboolean) (gtk_notebook_get_scrollable (notebook_g));
            return result_j;
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_popup_enable
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1popup_1enable (JNIEnv *env, 
        jclass cls, jint notebook) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        {
            gtk_notebook_popup_enable (notebook_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_popup_disable
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1popup_1disable (JNIEnv *env, 
        jclass cls, jint notebook) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        {
            gtk_notebook_popup_disable (notebook_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_get_tab_label
     * Signature: (II)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1get_1tab_1label (JNIEnv *env, 
        jclass cls, jint notebook, jint child) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        GtkWidget *child_g = (GtkWidget *)child;
        {
            return (jint)gtk_notebook_get_tab_label (notebook_g, child_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_set_tab_label
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1set_1tab_1label (JNIEnv *env, 
        jclass cls, jint notebook, jint child, jint tabLabel) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        GtkWidget *child_g = (GtkWidget *)child;
        GtkWidget *tabLabel_g = (GtkWidget *)tabLabel;
        {
            gtk_notebook_set_tab_label (notebook_g, child_g, tabLabel_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_set_tab_label_text
     * Signature: (IIjava.lang.String;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1set_1tab_1label_1text (JNIEnv 
        *env, jclass cls, jint notebook, jint child, jstring tabText) 
    {
        gchar* tabText_g = (gchar*)(*env)->GetStringUTFChars(env, tabText, 0);
        gtk_notebook_set_tab_label_text ((GtkNotebook*)notebook, (GtkWidget*)child, tabText_g);
        (*env)->ReleaseStringUTFChars(env, tabText, tabText_g);
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_get_tab_label_text
     * Signature: (II)java.lang.String;
     */
    JNIEXPORT jstring JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1get_1tab_1label_1text (
        JNIEnv *env, jclass cls, jint notebook, jint child) 
    {
        gchar *result_g = (gchar*)gtk_notebook_get_tab_label_text ((GtkNotebook*)notebook, (GtkWidget*)child);
        return (*env)->NewStringUTF(env, result_g);
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_get_menu_label
     * Signature: (II)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1get_1menu_1label (JNIEnv *env, 
        jclass cls, jint notebook, jint child) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        GtkWidget *child_g = (GtkWidget *)child;
        {
            return (jint)gtk_notebook_get_menu_label (notebook_g, child_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_set_menu_label
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1set_1menu_1label (JNIEnv *env, 
        jclass cls, jint notebook, jint child, jint menuLabel) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        GtkWidget *child_g = (GtkWidget *)child;
        GtkWidget *menuLabel_g = (GtkWidget *)menuLabel;
        {
            gtk_notebook_set_menu_label (notebook_g, child_g, menuLabel_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_set_menu_label_text
     * Signature: (IIjava.lang.String;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1set_1menu_1label_1text (JNIEnv 
        *env, jclass cls, jint notebook, jint child, jstring menuText) 
    {
        gchar* menuText_g = (gchar*)(*env)->GetStringUTFChars(env, menuText, 0);
        gtk_notebook_set_menu_label_text ((GtkNotebook*)notebook, (GtkWidget*)child, menuText_g);
        (*env)->ReleaseStringUTFChars(env, menuText, menuText_g);
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_get_menu_label_text
     * Signature: (II)java.lang.String;
     */
    JNIEXPORT jstring JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1get_1menu_1label_1text (
        JNIEnv *env, jclass cls, jint notebook, jint child) 
    {
        gchar *result_g = (gchar*)gtk_notebook_get_menu_label_text ((GtkNotebook*)notebook, (GtkWidget*)child);
        return (*env)->NewStringUTF(env, result_g);
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_query_tab_label_packing
     * Signature: (II[Z[Z[Lint ;)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1query_1tab_1label_1packing (
        JNIEnv *env, jclass cls, jint notebook, jint child, jbooleanArray expand, jbooleanArray 
        fill, jintArray packType) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        GtkWidget *child_g = (GtkWidget *)child;
        gboolean *expand_g = (gboolean *) (*env)->GetBooleanArrayElements(env, expand, NULL);
        gboolean *fill_g = (gboolean *) (*env)->GetBooleanArrayElements(env, fill, NULL);
        gint *packType_g_g = (gint *) (*env)->GetIntArrayElements (env, packType, NULL);
        GtkPackType *packType_g = (GtkPackType *)packType_g_g;
        {
            gtk_notebook_query_tab_label_packing (notebook_g, child_g, expand_g, fill_g, packType_g);
            (*env)->ReleaseBooleanArrayElements(env, expand, (jboolean *)expand_g, 0);
            (*env)->ReleaseBooleanArrayElements(env, fill, (jboolean *)fill_g, 0);
            (*env)->ReleaseIntArrayElements (env, packType, (jint*)packType_g_g, 0);
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_set_tab_label_packing
     * Signature: (IIZZI)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1set_1tab_1label_1packing (
        JNIEnv *env, jclass cls, jint notebook, jint child, jboolean expand, jboolean fill, jint 
        packType) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        GtkWidget *child_g = (GtkWidget *)child;
        gboolean expand_g = (gboolean) expand;
        gboolean fill_g = (gboolean) fill;
        GtkPackType packType_g = (GtkPackType) packType;
        {
            gtk_notebook_set_tab_label_packing (notebook_g, child_g, expand_g, fill_g, packType_g);
        }
    }

    /*
     * Class:     org.gnu.gtk.Notebook
     * Method:    gtk_notebook_reorder_child
     * Signature: (III)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1reorder_1child (JNIEnv *env, 
        jclass cls, jint notebook, jint child, jint position) 
    {
        GtkNotebook *notebook_g = (GtkNotebook *)notebook;
        GtkWidget *child_g = (GtkWidget *)child;
        gint32 position_g = (gint32) position;
        {
            gtk_notebook_reorder_child (notebook_g, child_g, position_g);
        }
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
 
 /*
 * Class:     org_gnu_gtk_Notebook
 * Method:    gtk_notebook_get_n_pages
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_Notebook_gtk_1notebook_1get_1n_1pages
  (JNIEnv *env, jclass cls, jint notebook)
{
	return (jint)gtk_notebook_get_n_pages((GtkNotebook*)notebook);
}
                                                                                
     
 
#ifdef __cplusplus
}

#endif
