/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;
import org.gnu.gdk.Rectangle;
import org.gnu.gdk.Window;
import org.gnu.glib.GObject;
import org.gnu.glib.Type;
/**
 *
 */
public class Style extends GObject {
	/**
	 * Construct a new Style object.
	 */
	public Style() {
		super(Style.gtk_style_new());
	}

	/**
	 * Construct a new Style object from a handle to a native resource.
	 */
	public Style(int handle) {
		super(handle);
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_style_get_type());
	}
	
	public Style attach(Window window) {
		return new Style(gtk_style_attach(getHandle(), window.getHandle()));
	}
	
	public void detach(Style style) {
		gtk_style_detach(style.getHandle());
	}
	
	public void setBackground(Window window, StateType stateType) {
		gtk_style_set_background(getHandle(), window.getHandle(), stateType.getValue());
	}
	
	public void applyDefaultBackground(Window window, boolean setBG, StateType stateType, 
				Rectangle rect, int x, int y, int width, int height) {
		gtk_style_apply_default_background(getHandle(), window.getHandle(), setBG, stateType.getValue(),
						rect.getHandle(), x, y, width, height);
	}
	
	public IconSet lookupIconSet(String stockID) {
		return new IconSet(gtk_style_lookup_icon_set(getHandle(), stockID));
	}
	
	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gtk_style_get_type();
	native static final protected int gtk_style_new();
	native static final protected int gtk_style_copy(int style);
	native static final protected int gtk_style_attach(int style, int window);
	native static final protected void gtk_style_detach(int style);
	native static final protected void gtk_style_set_background(int style, int window, int stateType);
	native static final protected void gtk_style_apply_default_background(int style, int window, boolean setBG, int stateType, int area, int x, int y, int width, int height);
	native static final protected int gtk_style_lookup_icon_set(int style, String stockId);
	native static final protected int gtk_style_render_icon(int style, int source, int direction, int state, int size, int[] widget, String detail);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
