/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * The HPaned widget is a container widget with two children arranged
 * horizontally.  The division between the two panes is adjustable by
 * the user by dragging a handle.
 * 
 * @see Paned
 */
public class HPaned extends Paned {
	/**
	 * Construct a new HPaned object.
	 */
	public HPaned() {
		super(HPaned.gtk_hpaned_new());
	}
	
	/**
	 * Construct a new HPaned from a handle to a native resource.
	 */
	public HPaned(int handle) {
	    super(handle);
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_hpaned_get_type());
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int gtk_hpaned_get_type();
	native static final protected int gtk_hpaned_new();
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
