/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif

GdkEventType GdkEventWindowState_get_type (GdkEventWindowState * cptr) 
{
    return cptr->type;
}

/*
 * Class:     org.gnu.gdk.EventWindowState
 * Method:    getType
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventWindowState_getType (JNIEnv *env, jclass cls, jobject 
    obj) 
{
    GdkEventWindowState *obj_g = (GdkEventWindowState *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventWindowState_get_type (obj_g));
}

GdkWindow * GdkEventWindowState_get_window (GdkEventWindowState * cptr) 
{
    return cptr->window;
}

/*
 * Class:     org.gnu.gdk.EventWindowState
 * Method:    getWindow
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_EventWindowState_getWindow (JNIEnv *env, jclass cls, 
    jobject obj) 
{
    GdkEventWindowState *obj_g = (GdkEventWindowState *)getPointerFromHandle(env, obj);
    return getHandleFromPointer(env, GdkEventWindowState_get_window (obj_g));
}

gboolean GdkEventWindowState_get_send_event (GdkEventWindowState * cptr) 
{
    return cptr->send_event;
}

/*
 * Class:     org.gnu.gdk.EventWindowState
 * Method:    getSendEvent
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_EventWindowState_getSendEvent (JNIEnv *env, jclass 
    cls, jobject obj) 
{
    GdkEventWindowState *obj_g = (GdkEventWindowState *)getPointerFromHandle(env, obj);
    return (jboolean) (GdkEventWindowState_get_send_event (obj_g));
}

GdkWindowState GdkEventWindowState_get_changed_mask (GdkEventWindowState * cptr) 
{
    return cptr->changed_mask;
}

/*
 * Class:     org.gnu.gdk.EventWindowState
 * Method:    getChangedMask
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventWindowState_getChangedMask (JNIEnv *env, jclass 
    cls, jobject obj) 
{
    GdkEventWindowState *obj_g = (GdkEventWindowState *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventWindowState_get_changed_mask (obj_g));
}

GdkWindowState GdkEventWindowState_get_new_window_state (GdkEventWindowState * cptr) 
{
    return cptr->new_window_state;
}

/*
 * Class:     org.gnu.gdk.EventWindowState
 * Method:    getNewWindowState
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_EventWindowState_getNewWindowState (JNIEnv *env, jclass 
    cls, jobject obj) 
{
    GdkEventWindowState *obj_g = (GdkEventWindowState *)getPointerFromHandle(env, obj);
    return (jint) (GdkEventWindowState_get_new_window_state (obj_g));
}


#ifdef __cplusplus
}

#endif
