/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Handle;
import org.gnu.glib.Type;

/**
 * The MenuBar is a subclass of MenuShell which contains one to many
 * MenuItem.  The result is a standard menu bar which can hold many
 * menu items.  MenuBar allows for a shadow type to be set for aesthetic
 * purposes.
 */
public class MenuBar extends MenuShell {

	/**
	 * Creates a new menubar from a handle to internal resources. This should
	 * only be used internally by Java-Gnome.
	 */
	public MenuBar(Handle handle){
	    super(handle);
	}

	/**
	 * Create a new MenuBar.
	 */
	public MenuBar() {
		super(gtk_menu_bar_new());
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_menu_bar_get_type());
	}


	native static final protected int gtk_menu_bar_get_type();
	native static final protected Handle gtk_menu_bar_new();

}
