include(../config.pri)

TARGET = $$GEGLQT_LIBNAME
target.path = $$GEGLQT_INSTALL_LIBS
TEMPLATE = lib
CONFIG += qt no_keywords

VERSION = $$GEGLQT_VERSION

QT += core gui
contains(HAVE_QT_DECLARATIVE, yes) {
    QT += declarative
}

CONFIG += link_pkgconfig
PKGCONFIG += gegl

OBJECTS_DIR = .obj
MOC_DIR = .moc

PUBLIC_SOURCES += \
    nodeviewwidget.cpp \
    nodeviewgraphicswidget.cpp \
    nodeviewoptions.cpp \

TOP_HEADERS += gegl-qt.h GeglQt

PUBLIC_HEADERS = \
    nodeviewwidget.h \
    nodeviewgraphicswidget.h \
    nodeviewoptions.h \

# Code that depends on Qt Declarative (optional)
contains(HAVE_QT_DECLARATIVE, yes) {
    PUBLIC_HEADERS += nodeviewdeclarativeitem.h
    PUBLIC_SOURCES += nodeviewdeclarativeitem.cpp
    TOP_HEADERS += gegl-qt-declarative.h GeglQtDeclarative
}

PRIVATE_HEADERS = \
    internal/nodeviewimplementation.h \
    internal/nodeviewchilditem.h \

PRIVATE_SOURCES = \
    internal/nodeviewimplementation.cpp \
    internal/nodeviewchilditem.cpp \

SOURCES += $$PUBLIC_SOURCES $$PRIVATE_SOURCES

HEADERS += $$PUBLIC_HEADERS $$PRIVATE_HEADERS

INCLUDEPATH += .. # Public includes have gegl-qt/ prefix

headers.path = $$GEGLQT_INSTALL_HEADERS/$$GEGLQT_LIBNAME/$$GEGLQT_PROJECTNAME
headers.files = $$PUBLIC_HEADERS

private_headers.files = $$PRIVATE_HEADERS
private_headers.path = $$GEGLQT_INSTALL_HEADERS/$$GEGLQT_LIBNAME/$$GEGLQT_PROJECTNAME/internal

top_headers.path = $$GEGLQT_INSTALL_HEADERS/$$GEGLQT_LIBNAME
top_headers.files = $$TOP_HEADERS

outputFiles(gegl-qt4-0.1.pc)

pkgconfig.path = $$GEGLQT_INSTALL_LIBS/pkgconfig
pkgconfig.files = gegl-qt4-0.1.pc

INSTALLS += target headers top_headers pkgconfig
!isEmpty(GEGLQT_INSTALL_PRIVATE_HEADERS) {
    INSTALLS += private_headers
}

OTHER_FILES = \
    gegl-qt4-0.1.pc.in \

