/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.dataflow.operator;

import groovy.lang.Closure;
import groovyx.gpars.actor.StaticDispatchActor;
import groovyx.gpars.actor.impl.MessageStream;
import groovyx.gpars.dataflow.DataflowChannelListener;
import groovyx.gpars.dataflow.DataflowReadChannel;
import groovyx.gpars.dataflow.operator.ControlMessage;
import groovyx.gpars.dataflow.operator.DataflowProcessor;
import groovyx.gpars.dataflow.operator.PoisonPill;
import groovyx.gpars.group.PGroup;
import java.util.List;

abstract class DataflowProcessorActor
extends StaticDispatchActor<Object> {
    protected static final String CANNOT_OBTAIN_THE_SEMAPHORE_TO_FORK_OPERATOR_S_BODY = "Cannot obtain the semaphore to fork operator's body.";
    protected final List inputs;
    protected final List outputs;
    protected final Closure code;
    protected final DataflowProcessor owningProcessor;
    protected boolean stoppingGently = false;

    DataflowProcessorActor(DataflowProcessor owningProcessor, PGroup group, List outputs, List inputs, Closure code) {
        this.setParallelGroup(group);
        this.owningProcessor = owningProcessor;
        this.outputs = outputs;
        this.inputs = inputs;
        this.code = code;
    }

    void afterStart() {
        this.owningProcessor.fireAfterStart();
    }

    void afterStop() {
        this.owningProcessor.fireAfterStop();
    }

    final void registerChannelListenersToAllInputs(DataflowChannelListener<Object> handler) {
        for (Object input : this.inputs) {
            ((DataflowReadChannel)input).getEventManager().addDataflowChannelListener(handler);
        }
    }

    final void onException(Throwable e) {
        this.reportException(e);
        this.terminate();
    }

    @Override
    public MessageStream send(Object message) {
        block2: {
            try {
                super.send(message);
            }
            catch (IllegalStateException e) {
                if (this.hasBeenStopped()) break block2;
                throw e;
            }
        }
        return this;
    }

    @Override
    public void onMessage(Object message) {
        throw new IllegalStateException("The dataflow actor doesn't recognize the message $message");
    }

    static boolean isControlMessage(Object message) {
        return message instanceof ControlMessage;
    }

    final void checkPoison(Object data) {
        if (data instanceof PoisonPill) {
            this.forwardPoisonPill(data);
            this.owningProcessor.terminate();
            ((PoisonPill)data).countDown();
        }
    }

    protected void forwardPoisonPill(Object data) {
        this.owningProcessor.bindAllOutputsAtomically(data);
    }

    final void reportException(Throwable e) {
        this.owningProcessor.reportError(e);
    }

    protected Object fireMessageArrived(Object result, int index, boolean controlMessage) {
        if (controlMessage) {
            return this.owningProcessor.fireControlMessageArrived((DataflowReadChannel)this.inputs.get(index), index, result);
        }
        return this.owningProcessor.fireMessageArrived((DataflowReadChannel)this.inputs.get(index), index, result);
    }
}

