"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = create;
const volar_service_css_1 = require("volar-service-css");
function create() {
    const base = (0, volar_service_css_1.create)({ scssDocumentSelector: ['scss', 'postcss'] });
    return {
        ...base,
        create(context) {
            const baseInstance = base.create(context);
            return {
                ...baseInstance,
                async provideDiagnostics(document, token) {
                    let diagnostics = await baseInstance.provideDiagnostics?.(document, token) ?? [];
                    if (document.languageId === 'postcss') {
                        diagnostics = diagnostics.filter(diag => diag.code !== 'css-semicolonexpected');
                        diagnostics = diagnostics.filter(diag => diag.code !== 'css-ruleorselectorexpected');
                        diagnostics = diagnostics.filter(diag => diag.code !== 'unknownAtRules');
                    }
                    return diagnostics;
                },
            };
        },
    };
}
//# sourceMappingURL=css.js.map