"use strict";
const decorateLanguageService_1 = require("@volar/typescript/lib/node/decorateLanguageService");
const decorateLanguageServiceHost_1 = require("@volar/typescript/lib/node/decorateLanguageServiceHost");
const vue = require("@vue/language-core");
const language_core_1 = require("@vue/language-core");
const common_1 = require("./lib/common");
const server_1 = require("./lib/server");
const windowsPathReg = /\\/g;
const externalFiles = new WeakMap();
const projectExternalFileExtensions = new WeakMap();
const decoratedLanguageServices = new WeakSet();
const decoratedLanguageServiceHosts = new WeakSet();
function createLanguageServicePlugin() {
    return modules => {
        const { typescript: ts } = modules;
        const pluginModule = {
            create(info) {
                if (!decoratedLanguageServices.has(info.languageService)
                    && !decoratedLanguageServiceHosts.has(info.languageServiceHost)) {
                    decoratedLanguageServices.add(info.languageService);
                    decoratedLanguageServiceHosts.add(info.languageServiceHost);
                    const vueOptions = getVueCompilerOptions();
                    const languagePlugin = vue.createVueLanguagePlugin(ts, id => id, info.languageServiceHost.useCaseSensitiveFileNames?.() ?? false, () => info.languageServiceHost.getProjectVersion?.() ?? '', () => externalFiles.get(info.project) ?? [], info.languageServiceHost.getCompilationSettings(), vueOptions);
                    const extensions = languagePlugin.typescript?.extraFileExtensions.map(ext => '.' + ext.extension) ?? [];
                    const getScriptSnapshot = info.languageServiceHost.getScriptSnapshot.bind(info.languageServiceHost);
                    const getScriptVersion = info.languageServiceHost.getScriptVersion.bind(info.languageServiceHost);
                    const syncedScriptVersions = new vue.FileMap(ts.sys.useCaseSensitiveFileNames);
                    const language = (0, language_core_1.createLanguage)([languagePlugin], ts.sys.useCaseSensitiveFileNames, fileName => {
                        const version = getScriptVersion(fileName);
                        if (syncedScriptVersions.get(fileName) === version) {
                            return;
                        }
                        syncedScriptVersions.set(fileName, version);
                        const snapshot = getScriptSnapshot(fileName);
                        if (snapshot) {
                            language.scripts.set(fileName, snapshot);
                        }
                        else {
                            language.scripts.delete(fileName);
                        }
                    });
                    projectExternalFileExtensions.set(info.project, extensions);
                    server_1.projects.set(info.project, { info, language, vueOptions });
                    (0, decorateLanguageService_1.decorateLanguageService)(language, info.languageService);
                    (0, common_1.decorateLanguageServiceForVue)(language, info.languageService, vueOptions, ts, true, fileName => fileName);
                    (0, decorateLanguageServiceHost_1.decorateLanguageServiceHost)(ts, language, info.languageServiceHost);
                    (0, server_1.startNamedPipeServer)(ts, info.project.projectKind, info.project.getCurrentDirectory());
                    // #3963
                    const timer = setInterval(() => {
                        if (info.project['program']) {
                            clearInterval(timer);
                            info.project['program'].__vue__ = { language };
                        }
                    }, 50);
                }
                return info.languageService;
                function getVueCompilerOptions() {
                    if (info.project.projectKind === ts.server.ProjectKind.Configured) {
                        const tsconfig = info.project.getProjectName();
                        return vue.createParsedCommandLine(ts, ts.sys, tsconfig.replace(windowsPathReg, '/')).vueOptions;
                    }
                    else {
                        return vue.createParsedCommandLineByJson(ts, ts.sys, info.languageServiceHost.getCurrentDirectory(), {}).vueOptions;
                    }
                }
            },
            getExternalFiles(project, updateLevel = 0) {
                if (updateLevel >= (1)
                    || !externalFiles.has(project)) {
                    const oldFiles = externalFiles.get(project);
                    const newFiles = new Set((0, decorateLanguageServiceHost_1.searchExternalFiles)(ts, project, projectExternalFileExtensions.get(project)));
                    externalFiles.set(project, newFiles);
                    if (oldFiles && !twoSetsEqual(oldFiles, newFiles)) {
                        for (const oldFile of oldFiles) {
                            if (!newFiles.has(oldFile)) {
                                server_1.projects.get(project)?.language.scripts.delete(oldFile);
                            }
                        }
                        project.refreshDiagnostics();
                    }
                }
                return [...externalFiles.get(project)];
            },
        };
        return pluginModule;
    };
}
function twoSetsEqual(a, b) {
    if (a.size !== b.size) {
        return false;
    }
    for (const file of a) {
        if (!b.has(file)) {
            return false;
        }
    }
    return true;
}
module.exports = createLanguageServicePlugin();
//# sourceMappingURL=index.js.map