"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createSimpleServerProject = void 0;
const language_service_1 = require("@volar/language-service");
async function createSimpleServerProject(server, serviceEnv, languagePlugins) {
    let languageService;
    return {
        getLanguageService,
        getLanguageServiceDontCreate: () => languageService,
        dispose() {
            languageService?.dispose();
        },
    };
    function getLanguageService() {
        if (!languageService) {
            const language = (0, language_service_1.createLanguage)(languagePlugins, false, uri => {
                const document = server.documents.get(uri);
                if (document) {
                    language.scripts.set(uri, document.getSnapshot(), document.languageId);
                }
                else {
                    language.scripts.delete(uri);
                }
            });
            languageService = (0, language_service_1.createLanguageService)(language, server.languageServicePlugins, serviceEnv);
        }
        return languageService;
    }
}
exports.createSimpleServerProject = createSimpleServerProject;
//# sourceMappingURL=simpleProject.js.map