"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = void 0;
const vue_autoinsert_dotvalue_1 = require("./vue-autoinsert-dotvalue");
function create(ts) {
    return {
        name: 'vue-autoinsert-parentheses',
        create(context) {
            return {
                async provideAutoInsertionEdit(document, selection, change) {
                    // selection must at end of change
                    if (document.offsetAt(selection) !== change.rangeOffset + change.text.length) {
                        return;
                    }
                    const enabled = await context.env.getConfiguration?.('vue.autoInsert.parentheses') ?? false;
                    if (!enabled) {
                        return;
                    }
                    if (!(0, vue_autoinsert_dotvalue_1.isCharacterTyping)(document, change)) {
                        return;
                    }
                    const decoded = context.decodeEmbeddedDocumentUri(document.uri);
                    const sourceScript = decoded && context.language.scripts.get(decoded[0]);
                    const virtualCode = decoded && sourceScript?.generated?.embeddedCodes.get(decoded[1]);
                    if (!virtualCode?.id.startsWith('template_inline_ts_')) {
                        return;
                    }
                    const offset = document.offsetAt(selection);
                    for (const mappedRange of virtualCode.mappings) {
                        const generatedCodeEnd = mappedRange.generatedOffsets[mappedRange.generatedOffsets.length - 1]
                            + mappedRange.lengths[mappedRange.lengths.length - 1];
                        if (generatedCodeEnd === offset) {
                            const text = document.getText().substring(mappedRange.generatedOffsets[0], generatedCodeEnd);
                            const ast = ts.createSourceFile('', text, ts.ScriptTarget.Latest);
                            if (ast.statements.length === 1) {
                                const statement = ast.statements[0];
                                if (ts.isExpressionStatement(statement)
                                    && ((ts.isAsExpression(statement.expression)
                                        && ts.isTypeReferenceNode(statement.expression.type)
                                        && ts.isIdentifier(statement.expression.type.typeName)
                                        && statement.expression.type.typeName.text)
                                        || (ts.isBinaryExpression(statement.expression)
                                            && statement.expression.right.getText(ast)
                                            && statement.expression.operatorToken.kind === ts.SyntaxKind.InstanceOfKeyword)
                                        || (ts.isTypeOfExpression(statement.expression)
                                            && statement.expression.expression.getText(ast)))) {
                                    // https://code.visualstudio.com/docs/editor/userdefinedsnippets#_grammar
                                    const escapedText = text
                                        .replaceAll('\\', '\\\\')
                                        .replaceAll('$', '\\$')
                                        .replaceAll('}', '\\}');
                                    return {
                                        range: {
                                            start: document.positionAt(mappedRange.generatedOffsets[0]),
                                            end: document.positionAt(generatedCodeEnd),
                                        },
                                        newText: '(' + escapedText + '$0' + ')',
                                    };
                                }
                            }
                        }
                    }
                },
            };
        },
    };
}
exports.create = create;
//# sourceMappingURL=vue-autoinsert-parentheses.js.map