/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.refactoring.AbstractJpaRenameJavaElementParticipant;
import org.eclipse.jpt.jpa.core.internal.refactoring.JpaCoreRefactoringMessages;
import org.eclipse.text.edits.ReplaceEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaRenameTypeParticipant
extends AbstractJpaRenameJavaElementParticipant {
    protected final Collection<IType> nestedTypes = new ArrayList<IType>();

    public String getName() {
        return JpaCoreRefactoringMessages.JPA_RENAME_TYPE_REFACTORING_PARTICIPANT_NAME;
    }

    protected IType getOriginalType() {
        return (IType)super.getOriginalJavaElement();
    }

    @Override
    protected boolean initialize(Object element) {
        boolean initialize = super.initialize(element);
        if (initialize) {
            this.addNestedTypes(this.getOriginalType());
            return true;
        }
        return false;
    }

    protected void addNestedType(IType renamedType) {
        this.nestedTypes.add(renamedType);
        this.addNestedTypes(renamedType);
    }

    private void addNestedTypes(IType renamedType) {
        IType[] nestedTypes;
        try {
            nestedTypes = renamedType.getTypes();
        }
        catch (JavaModelException ex) {
            JptJpaCorePlugin.log(ex);
            return;
        }
        IType[] iTypeArray = nestedTypes;
        int n = nestedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType nestedType = iTypeArray[n2];
            this.addNestedType(nestedType);
            ++n2;
        }
    }

    @Override
    protected Iterable<ReplaceEdit> createPersistenceXmlReplaceEdits(PersistenceUnit persistenceUnit) {
        return new CompositeIterable(new Iterable[]{this.createPersistenceXmlReplaceOriginalTypeEdits(persistenceUnit), this.createPersistenceXmlReplaceNestedTypeEdits(persistenceUnit)});
    }

    private Iterable<ReplaceEdit> createPersistenceXmlReplaceOriginalTypeEdits(PersistenceUnit persistenceUnit) {
        return persistenceUnit.createRenameTypeEdits(this.getOriginalType(), this.getNewName());
    }

    private Iterable<ReplaceEdit> createPersistenceXmlReplaceNestedTypeEdits(final PersistenceUnit persistenceUnit) {
        return new CompositeIterable((Iterable)new TransformationIterable<IType, Iterable<ReplaceEdit>>(this.nestedTypes){

            protected Iterable<ReplaceEdit> transform(IType nestedType) {
                String newName = JpaRenameTypeParticipant.this.getNewNameForNestedType(nestedType);
                return persistenceUnit.createRenameTypeEdits(nestedType, newName);
            }
        });
    }

    @Override
    protected Iterable<ReplaceEdit> createMappingFileReplaceEdits(MappingFileRef mappingFileRef) {
        return new CompositeIterable(new Iterable[]{this.createMappingFileReplaceOriginalTypeEdits(mappingFileRef), this.createMappingFileReplaceNestedTypeEdits(mappingFileRef)});
    }

    private Iterable<ReplaceEdit> createMappingFileReplaceOriginalTypeEdits(MappingFileRef mappingFileRef) {
        return mappingFileRef.createRenameTypeEdits(this.getOriginalType(), this.getNewName());
    }

    private Iterable<ReplaceEdit> createMappingFileReplaceNestedTypeEdits(final MappingFileRef mappingFileRef) {
        return new CompositeIterable((Iterable)new TransformationIterable<IType, Iterable<ReplaceEdit>>(this.nestedTypes){

            protected Iterable<ReplaceEdit> transform(IType nestedType) {
                String newName = JpaRenameTypeParticipant.this.getNewNameForNestedType(nestedType);
                return mappingFileRef.createRenameTypeEdits(nestedType, newName);
            }
        });
    }

    protected String getNewName() {
        String newName = this.getArguments().getNewName();
        try {
            if (this.getOriginalType().isMember()) {
                newName = String.valueOf(this.getOriginalType().getTypeQualifiedName().substring(0, this.getOriginalType().getTypeQualifiedName().lastIndexOf(36))) + '$' + newName;
            }
        }
        catch (JavaModelException e) {
            JptJpaCorePlugin.log(e);
        }
        return newName;
    }

    protected String getNewNameForNestedType(IType nestedType) {
        return nestedType.getTypeQualifiedName('$').replaceFirst(this.getOriginalType().getElementName(), this.getArguments().getNewName());
    }

    @Override
    protected String getCheckConditionsSubTaskName() {
        return JpaCoreRefactoringMessages.JPA_RENAME_TYPE_REFACTORING_SUB_TASK_NAME;
    }

    @Override
    protected String getCreateChangeSubTaskName() {
        return JpaCoreRefactoringMessages.JPA_RENAME_TYPE_REFACTORING_SUB_TASK_NAME;
    }

    @Override
    protected String getCompositeChangeName() {
        return JpaCoreRefactoringMessages.JPA_RENAME_TYPE_REFACTORING_CHANGE_NAME;
    }

    @Override
    protected String getPersistenceXmlChangeName() {
        return JpaCoreRefactoringMessages.JPA_RENAME_TYPE_REFACTORING_CHANGE_PERSISTENCE_XML_NAME;
    }

    @Override
    protected String getMappingFileChangeName() {
        return JpaCoreRefactoringMessages.JPA_RENAME_TYPE_REFACTORING_CHANGE_MAPPING_FILE_NAME;
    }
}

