/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmJoinColumnJoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmJoinTable;
import org.eclipse.jpt.core.context.orm.OrmJoinTableEnabledRelationshipReference;
import org.eclipse.jpt.core.context.orm.OrmJoinTableJoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmMappedByJoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmOneToManyMapping;
import org.eclipse.jpt.core.context.orm.OrmOwnableRelationshipReference;
import org.eclipse.jpt.core.context.orm.OrmRelationshipReference;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmRelationshipReference;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmJoinTableJoiningStrategy;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmMappedByJoiningStrategy;
import org.eclipse.jpt.core.jpa2.context.orm.OrmOneToManyRelationshipReference2_0;
import org.eclipse.jpt.core.resource.orm.XmlOneToMany;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmOneToManyRelationshipReference
extends AbstractOrmRelationshipReference
implements OrmOneToManyRelationshipReference2_0 {
    protected OrmMappedByJoiningStrategy mappedByJoiningStrategy;
    protected OrmJoinTableJoiningStrategy joinTableJoiningStrategy;
    protected OrmJoinColumnJoiningStrategy joinColumnJoiningStrategy;

    protected AbstractOrmOneToManyRelationshipReference(OrmOneToManyMapping parent, XmlOneToMany resource) {
        super(parent, resource);
    }

    @Override
    protected void initializeJoiningStrategies() {
        this.mappedByJoiningStrategy = this.buildMappedByJoiningStrategy();
        this.joinColumnJoiningStrategy = this.buildJoinColumnJoiningStrategy();
        this.joinTableJoiningStrategy = this.buildJoinTableJoiningStrategy();
    }

    protected OrmMappedByJoiningStrategy buildMappedByJoiningStrategy() {
        return new GenericOrmMappedByJoiningStrategy(this, this.getResourceMapping());
    }

    protected OrmJoinTableJoiningStrategy buildJoinTableJoiningStrategy() {
        return new GenericOrmJoinTableJoiningStrategy(this, this.getResourceMapping());
    }

    protected abstract OrmJoinColumnJoiningStrategy buildJoinColumnJoiningStrategy();

    @Override
    public void initializeOn(OrmRelationshipReference newRelationshipReference) {
        newRelationshipReference.initializeFromOwnableRelationshipReference(this);
        newRelationshipReference.initializeFromJoinTableEnabledRelationshipReference(this);
    }

    @Override
    public void initializeFromOwnableRelationshipReference(OrmOwnableRelationshipReference oldRelationshipReference) {
        super.initializeFromOwnableRelationshipReference(oldRelationshipReference);
        this.mappedByJoiningStrategy.setMappedByAttribute(oldRelationshipReference.getMappedByJoiningStrategy().getMappedByAttribute());
    }

    @Override
    public void initializeFromJoinTableEnabledRelationshipReference(OrmJoinTableEnabledRelationshipReference oldRelationshipReference) {
        super.initializeFromJoinTableEnabledRelationshipReference(oldRelationshipReference);
        OrmJoinTable oldTable = oldRelationshipReference.getJoinTableJoiningStrategy().getJoinTable();
        if (oldTable != null) {
            this.joinTableJoiningStrategy.addJoinTable().initializeFrom(oldTable);
        }
    }

    @Override
    public OrmOneToManyMapping getRelationshipMapping() {
        return (OrmOneToManyMapping)this.getParent();
    }

    @Override
    public XmlOneToMany getResourceMapping() {
        return this.getRelationshipMapping().getResourceAttributeMapping();
    }

    @Override
    public boolean isRelationshipOwner() {
        return this.getMappedByJoiningStrategy().getMappedByAttribute() == null;
    }

    @Override
    public boolean isOwnedBy(RelationshipMapping mapping) {
        return this.mappedByJoiningStrategy.relationshipIsOwnedBy(mapping);
    }

    @Override
    public boolean isTargetForeignKeyRelationship() {
        return this.getJoinColumnJoiningStrategy().isTargetForeignKeyRelationship();
    }

    @Override
    public OrmMappedByJoiningStrategy getMappedByJoiningStrategy() {
        return this.mappedByJoiningStrategy;
    }

    @Override
    public final void setMappedByJoiningStrategy() {
        this.setMappedByJoiningStrategy_();
        this.setPredominantJoiningStrategy();
    }

    protected void setMappedByJoiningStrategy_() {
        this.mappedByJoiningStrategy.addStrategy();
        this.joinTableJoiningStrategy.removeStrategy();
        this.joinColumnJoiningStrategy.removeStrategy();
    }

    @Override
    public final void unsetMappedByJoiningStrategy() {
        this.unsetMappedByJoiningStrategy_();
        this.setPredominantJoiningStrategy();
    }

    protected void unsetMappedByJoiningStrategy_() {
        this.mappedByJoiningStrategy.removeStrategy();
    }

    @Override
    public boolean usesMappedByJoiningStrategy() {
        return this.getPredominantJoiningStrategy() == this.mappedByJoiningStrategy;
    }

    @Override
    public boolean mayBeMappedBy(AttributeMapping mappedByMapping) {
        return mappedByMapping.getKey() == "manyToOne";
    }

    @Override
    public OrmJoinTableJoiningStrategy getJoinTableJoiningStrategy() {
        return this.joinTableJoiningStrategy;
    }

    @Override
    public boolean usesJoinTableJoiningStrategy() {
        return this.getPredominantJoiningStrategy() == this.joinTableJoiningStrategy;
    }

    @Override
    public final void setJoinTableJoiningStrategy() {
        this.setJoinTableJoiningStrategy_();
        this.setPredominantJoiningStrategy();
    }

    protected void setJoinTableJoiningStrategy_() {
        this.mappedByJoiningStrategy.removeStrategy();
        this.joinColumnJoiningStrategy.removeStrategy();
    }

    @Override
    public final void unsetJoinTableJoiningStrategy() {
        this.unsetJoinTableJoiningStrategy_();
        this.setPredominantJoiningStrategy();
    }

    protected void unsetJoinTableJoiningStrategy_() {
        this.joinTableJoiningStrategy.removeStrategy();
    }

    @Override
    public boolean mayHaveDefaultJoinTable() {
        return this.mappedByJoiningStrategy.getMappedByAttribute() == null && !this.joinColumnJoiningStrategy.hasSpecifiedJoinColumns();
    }

    @Override
    public OrmJoinColumnJoiningStrategy getJoinColumnJoiningStrategy() {
        return this.joinColumnJoiningStrategy;
    }

    @Override
    public boolean usesJoinColumnJoiningStrategy() {
        return this.getPredominantJoiningStrategy() == this.joinColumnJoiningStrategy;
    }

    @Override
    public void setJoinColumnJoiningStrategy() {
        this.joinColumnJoiningStrategy.addStrategy();
        this.mappedByJoiningStrategy.removeStrategy();
        this.joinTableJoiningStrategy.removeStrategy();
        this.setPredominantJoiningStrategy();
    }

    @Override
    public void unsetJoinColumnJoiningStrategy() {
        this.joinColumnJoiningStrategy.removeStrategy();
        this.setPredominantJoiningStrategy();
    }

    @Override
    public boolean mayHaveDefaultJoinColumn() {
        return false;
    }

    @Override
    protected void updateJoiningStrategies() {
        this.mappedByJoiningStrategy.update();
        this.joinColumnJoiningStrategy.update();
        this.joinTableJoiningStrategy.update();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.mappedByJoiningStrategy.validate(messages, reporter);
        this.joinTableJoiningStrategy.validate(messages, reporter);
        this.joinColumnJoiningStrategy.validate(messages, reporter);
    }
}

