/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMContent;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMGroup;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNodeList;
import org.eclipse.wst.xml.core.internal.contentmodel.internal.util.CMValidator;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQueryAction;
import org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl.ModelQueryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModelQueryActionHelper {
    protected ModelQueryImpl modelQuery;

    public ModelQueryActionHelper(ModelQueryImpl modelQuery) {
        this.modelQuery = modelQuery;
    }

    public void getAllActions(Element parent, CMElementDeclaration ed, int validityChecking, List actionList) {
    }

    public void getInsertActions(Element parent, CMElementDeclaration ed, int index, int includeOptions, int validityChecking, List actionList) {
        if ((includeOptions & 1) != 0) {
            this.getInsertAttributeActions(parent, ed, validityChecking, actionList);
        }
        if (((includeOptions &= 0xFFFFFFFE) & 2) != 0) {
            if (index != -1) {
                this.getInsertChildNodeActionsAtIndex(parent, ed, index, includeOptions, validityChecking, actionList);
            } else {
                this.getInsertChildNodeActions(parent, ed, includeOptions, validityChecking, actionList);
            }
        }
    }

    protected void getInsertAttributeActions(Element parent, CMElementDeclaration ed, int validityChecking, List actionList) {
        List availableAttributeList = this.modelQuery.getAvailableContent(parent, ed, 1);
        Iterator i = availableAttributeList.iterator();
        while (i.hasNext()) {
            CMAttributeDeclaration ad = (CMAttributeDeclaration)i.next();
            if (!this.modelQuery.canInsert(parent, ed, ad, 0, validityChecking)) continue;
            Action action = new Action(1, parent, ad);
            actionList.add(action);
        }
    }

    protected void getInsertChildNodeActionsAtIndex(Element parent, CMElementDeclaration ed, int index, int includeOptions, int validityChecking, List actionList) {
        int size = parent.getChildNodes().getLength();
        if (index <= size) {
            List contentSpecificationList = this.modelQuery.getValidator().createContentSpecificationList(parent, ed);
            List availableChildNodeList = this.modelQuery.getAvailableContent(parent, ed, includeOptions);
            boolean isSimpleChoice = this.isSimpleChoiceGroupContentModel(ed);
            Iterator i = availableChildNodeList.iterator();
            while (i.hasNext()) {
                CMNode cmNode = (CMNode)i.next();
                if (!isSimpleChoice && !this.modelQuery.canInsert(parent, ed, cmNode, index, validityChecking, contentSpecificationList)) continue;
                Action action = new Action(1, parent, cmNode, index, index);
                actionList.add(action);
            }
        }
    }

    protected boolean isSimpleChoiceGroupContentModel(CMElementDeclaration ed) {
        CMGroup cmGroup;
        boolean result = false;
        CMContent cmNode = ed.getContent();
        if (cmNode != null && cmNode.getNodeType() == 7 && (cmGroup = (CMGroup)cmNode).getOperator() == 2 && cmGroup.getMaxOccur() == -1) {
            result = true;
            CMNodeList list = cmGroup.getChildNodes();
            int i = list.getLength() - 1;
            while (i >= 0) {
                if (list.item(i).getNodeType() != 5) {
                    result = false;
                    break;
                }
                --i;
            }
        }
        return result;
    }

    protected void getInsertChildNodeActions(Element parent, CMElementDeclaration ed, int includeOptions, int validityChecking, List actionList) {
        int size = parent.getChildNodes().getLength();
        List contentSpecificationList = this.modelQuery.getValidator().createContentSpecificationList(parent, ed);
        List availableChildNodeList = this.modelQuery.getAvailableContent(parent, ed, includeOptions);
        boolean isSimpleChoice = this.isSimpleChoiceGroupContentModel(ed);
        Iterator iterator = availableChildNodeList.iterator();
        block0: while (iterator.hasNext()) {
            CMNode cmNode = (CMNode)iterator.next();
            int i = size;
            while (i >= 0) {
                if (isSimpleChoice || this.modelQuery.canInsert(parent, ed, cmNode, i, validityChecking, contentSpecificationList)) {
                    Action action = new Action(1, parent, cmNode, i, i);
                    actionList.add(action);
                    continue block0;
                }
                --i;
            }
        }
    }

    public void getInsertActions(Document parent, CMDocument cmDocument, int index, int includeOptions, int validityChecking, List actionList) {
        int doctypeIndex = -1;
        DocumentType doctype = null;
        Element rootElement = null;
        NodeList nodeList = parent.getChildNodes();
        int nodeListLength = nodeList.getLength();
        int i = 0;
        while (i < nodeListLength) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() == 1) {
                rootElement = (Element)childNode;
                break;
            }
            if (childNode.getNodeType() == 10) {
                doctype = (DocumentType)childNode;
                doctypeIndex = i;
            }
            ++i;
        }
        if (rootElement == null && index > doctypeIndex) {
            CMNamedNodeMap map = cmDocument.getElements();
            int mapLength = map.getLength();
            int i2 = 0;
            while (i2 < mapLength) {
                CMNode cmNode = map.item(i2);
                boolean canAdd = true;
                if (validityChecking == 2) {
                    boolean bl = canAdd = doctype == null || doctype.getName().equals(cmNode.getNodeName());
                }
                if (canAdd) {
                    Action action = new Action(1, parent, cmNode, index, index);
                    actionList.add(action);
                }
                ++i2;
            }
        }
    }

    public void getInsertChildNodeActionTable(Element parent, CMElementDeclaration ed, int validityChecking, Hashtable actionTable) {
    }

    public void getReplaceActions(Element parent, CMElementDeclaration ed, int includeOptions, int validityChecking, List actionList) {
        CMValidator.MatchModelNode matchModelNode = this.modelQuery.getValidator().getMatchModel(ed, parent);
        if (matchModelNode != null) {
            MatchModelVisitor visitor = new MatchModelVisitor(parent, actionList);
            visitor.visitMatchModelNode(matchModelNode);
        }
    }

    public void getReplaceActions(Element parent, CMElementDeclaration ed, List selectedChildren, int includeOptions, int validityChecking, List actionList) {
        Element childElement;
        CMElementDeclaration childEd;
        Node node;
        int[] range = this.getRange(parent, selectedChildren);
        if (range != null && this.isContiguous(parent, range, selectedChildren)) {
            Vector tempList = new Vector();
            this.getReplaceActions(parent, ed, includeOptions, validityChecking, tempList);
            if ((includeOptions & 0x10) != 0) {
                this.removeActionsNotContainingRange(tempList, range[0], range[1]);
            } else {
                this.removeActionsNotMatchingRange(tempList, range[0], range[1]);
            }
            actionList.addAll(tempList);
        }
        if (selectedChildren.size() == 1 && (node = (Node)selectedChildren.get(0)).getNodeType() == 1 && (childEd = this.modelQuery.getCMElementDeclaration(childElement = (Element)node)) != null) {
            CMNodeList cmNodeList;
            CMNode childOrigin = this.modelQuery.getOrigin(childElement);
            CMNodeList cMNodeList = cmNodeList = childOrigin != null ? (CMNodeList)childOrigin.getProperty("SubstitutionGroup") : (CMNodeList)childEd.getProperty("SubstitutionGroup");
            if (cmNodeList != null && cmNodeList.getLength() > 1) {
                int replaceIndex = this.getIndex(parent, childElement);
                String childEdName = childEd.getNodeName();
                int i = 0;
                while (i < cmNodeList.getLength()) {
                    CMNode substitution = cmNodeList.item(i);
                    if (!substitution.getNodeName().equals(childEdName) && !Boolean.TRUE.equals(substitution.getProperty("Abstract"))) {
                        Action action = new Action(4, parent, cmNodeList.item(i), replaceIndex, replaceIndex);
                        actionList.add(action);
                    }
                    ++i;
                }
            }
        }
    }

    protected boolean isContiguous(Element parent, int[] range, List selectedNodeList) {
        boolean result = true;
        NodeList nodeList = parent.getChildNodes();
        nodeList.getLength();
        int i = range[0];
        while (i < range[1]) {
            Node node = nodeList.item(i);
            if (!this.isWhitespaceNode(node) && !selectedNodeList.contains(node)) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    protected int[] getRange(Element parent, List list) {
        int[] result = null;
        int first = -1;
        int last = -1;
        NodeList nodeList = parent.getChildNodes();
        int nodeListLength = nodeList.getLength();
        int i = 0;
        while (i < nodeListLength) {
            Node node = nodeList.item(i);
            if (list.contains(node)) {
                first = first == -1 ? i : Math.min(first, i);
                last = Math.max(last, i);
            }
            ++i;
        }
        if (first != -1 && last != -1) {
            result = new int[]{first, last};
        }
        return result;
    }

    protected boolean isWhitespaceNode(Node node) {
        return node.getNodeType() == 3 && node.getNodeValue().trim().length() == 0;
    }

    protected int getIndex(Node parentNode, Node child) {
        NodeList nodeList = parentNode.getChildNodes();
        int index = -1;
        int size = nodeList.getLength();
        int i = 0;
        while (i < size) {
            if (nodeList.item(i) == child) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    protected boolean isActionContainingRange(ModelQueryAction action, int startIndex, int endIndex) {
        int actionStartIndex = action.getStartIndex();
        int actionEndIndex = action.getEndIndex();
        return actionStartIndex <= startIndex && actionEndIndex >= endIndex;
    }

    protected boolean isActionMatchingRange(ModelQueryAction action, int startIndex, int endIndex) {
        int actionStartIndex = action.getStartIndex();
        int actionEndIndex = action.getEndIndex();
        return actionStartIndex == startIndex && actionEndIndex == endIndex;
    }

    protected void removeActionsNotContainingRange(List actionList, int startIndex, int endIndex) {
        int i = actionList.size() - 1;
        while (i >= 0) {
            ModelQueryAction action = (ModelQueryAction)actionList.get(i);
            if (!this.isActionContainingRange(action, startIndex, endIndex)) {
                actionList.remove(i);
            }
            --i;
        }
    }

    protected void removeActionsNotMatchingRange(List actionList, int startIndex, int endIndex) {
        int i = actionList.size() - 1;
        while (i >= 0) {
            ModelQueryAction action = (ModelQueryAction)actionList.get(i);
            if (!this.isActionMatchingRange(action, startIndex, endIndex)) {
                actionList.remove(i);
            }
            --i;
        }
    }

    protected static class Action
    implements ModelQueryAction {
        public int kind;
        public int startIndex;
        public int endIndex;
        public Node parent;
        public CMNode cmNode;
        public Object userData;

        public Action(int kind, Node parent, CMNode cmNode) {
            this.kind = kind;
            this.parent = parent;
            this.cmNode = cmNode;
        }

        public Action(int kind, Node parent, CMNode cmNode, int startIndex, int endIndex) {
            this.kind = kind;
            this.parent = parent;
            this.cmNode = cmNode;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        public int getKind() {
            return this.kind;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public Node getParent() {
            return this.parent;
        }

        public CMNode getCMNode() {
            return this.cmNode;
        }

        public Object getUserData() {
            return this.userData;
        }

        public void setUserData(Object object) {
            this.userData = object;
        }

        public void performAction() {
        }
    }

    public static class MatchModelVisitor {
        int indent;
        int elementIndex;
        Node parent;
        List actionList;

        public MatchModelVisitor(Node parent, List actionList) {
            this.parent = parent;
            this.actionList = actionList;
        }

        public int indexOfNextElement(int start) {
            int length;
            NodeList nodeList = this.parent.getChildNodes();
            int result = length = nodeList.getLength();
            int i = start;
            while (i < length) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 1) {
                    result = i;
                    break;
                }
                ++i;
            }
            return result;
        }

        public void visitMatchModelNode(CMValidator.MatchModelNode matchModelNode) {
            int startIndex = this.indexOfNextElement(this.elementIndex);
            this.indent += 2;
            Iterator iterator = matchModelNode.children.iterator();
            while (iterator.hasNext()) {
                CMValidator.MatchModelNode child = (CMValidator.MatchModelNode)iterator.next();
                this.visitMatchModelNode(child);
            }
            this.indent -= 2;
            if (matchModelNode.cmNode != null) {
                int nodeType = matchModelNode.cmNode.getNodeType();
                if (nodeType == 7) {
                    CMGroup group = (CMGroup)matchModelNode.cmNode;
                    if (group.getOperator() == 2) {
                        this.addReplaceActions(matchModelNode, group, startIndex, this.elementIndex - 1);
                    }
                } else if (nodeType == 5) {
                    this.elementIndex = startIndex + 1;
                }
            }
        }

        public void addReplaceActions(CMValidator.MatchModelNode matchModelNode, CMGroup group, int startIndex, int endIndex) {
            CMNode excludeCMNode = null;
            if (matchModelNode.children.size() > 0) {
                CMValidator.MatchModelNode child = (CMValidator.MatchModelNode)matchModelNode.children.get(0);
                excludeCMNode = child.cmNode;
            }
            CMNodeList nodeList = group.getChildNodes();
            int size = nodeList.getLength();
            int i = 0;
            while (i < size) {
                CMNode alternative = nodeList.item(i);
                if (alternative != excludeCMNode) {
                    Action action = new Action(4, this.parent, alternative, startIndex, endIndex);
                    this.actionList.add(action);
                }
                ++i;
            }
        }
    }
}

