/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.context.resolver.structureddocument.internal.impl;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

class WorkspaceContextResolver
implements IWorkspaceContextResolver {
    private final IStructuredDocumentContext _context;

    WorkspaceContextResolver(IStructuredDocumentContext context) {
        this._context = context;
    }

    public IProject getProject() {
        String path = this.getPath();
        if (path == null) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path iPath = new Path(path);
        if (iPath.isAbsolute()) {
            String projectName = iPath.segment(0);
            IProject[] projects = root.getProjects();
            int i = 0;
            while (i < projects.length) {
                IProject project = projects[i];
                if (project.isOpen() && projectName.equals(project.getFullPath().segment(0))) {
                    return project;
                }
                ++i;
            }
        }
        return null;
    }

    public IResource getResource() {
        Path iPath;
        String path;
        IProject project = this.getProject();
        if (project != null && (path = this.getPath()) != null && (iPath = new Path(path)).isAbsolute()) {
            return project.getFile(iPath.removeFirstSegments(1));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getPath() {
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().getExistingModelForRead(this._context.getStructuredDocument());
            if (model == null) {
                return null;
            }
            String path = model.getBaseLocation();
            if (path == null || path.length() == 0) {
                String id = model.getId();
                if (id == null) {
                    return null;
                }
                path = id.toString();
            }
            String string = path;
            return string;
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public boolean canResolveContext(IModelContext modelContext) {
        return modelContext.getAdapter(IStructuredDocumentContext.class) != null;
    }
}

