/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.core.internal;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.virgo.nano.core.Signal;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;

public final class BlockingSignal
implements Signal {
    private Object monitor = new Object();
    private final CountDownLatch latch = new CountDownLatch(1);
    private boolean complete = false;
    private Throwable cause = null;
    private final boolean block;

    public BlockingSignal(boolean block) {
        this.block = block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalFailure(Throwable cause) {
        Object object = this.monitor;
        synchronized (object) {
            this.complete = true;
            this.cause = cause;
            this.latch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalSuccessfulCompletion() {
        Object object = this.monitor;
        synchronized (object) {
            this.complete = true;
            this.latch.countDown();
        }
    }

    public boolean awaitCompletion(long timeInSeconds) throws DeploymentException {
        if (this.block) {
            try {
                this.latch.await(timeInSeconds, TimeUnit.SECONDS);
            }
            catch (InterruptedException i) {
                throw new DeploymentException("latch await interrupted", (Throwable)i);
            }
        }
        Object object = this.monitor;
        synchronized (object) {
            block12: {
                block11: {
                    if (this.complete) break block11;
                    return false;
                }
                if (this.cause != null) break block12;
                return true;
            }
            try {
                throw this.cause;
            }
            catch (DeploymentException de) {
                throw de;
            }
            catch (Throwable t) {
                throw new DeploymentException(t.getMessage(), t.getCause());
            }
        }
    }

    public boolean checkComplete() throws DeploymentException {
        if (this.block) {
            try {
                this.latch.await();
            }
            catch (InterruptedException i) {
                throw new DeploymentException("latch await interrupted", (Throwable)i);
            }
        }
        Object object = this.monitor;
        synchronized (object) {
            block12: {
                block11: {
                    if (this.complete) break block11;
                    return false;
                }
                if (this.cause != null) break block12;
                return true;
            }
            try {
                throw this.cause;
            }
            catch (DeploymentException de) {
                throw de;
            }
            catch (Throwable t) {
                throw new DeploymentException(t.getMessage(), t.getCause());
            }
        }
    }
}

