/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;

import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction0;
import org.eclipse.collections.api.block.function.primitive.CharToCharFunction;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.predicate.primitive.CharCharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharCharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.iterator.MutableCharIterator;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.map.primitive.ImmutableCharCharMap;
import org.eclipse.collections.api.map.primitive.CharCharMap;
import org.eclipse.collections.api.map.primitive.MutableCharCharMap;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.tuple.primitive.CharCharPair;
import org.eclipse.collections.impl.factory.primitive.CharCharMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableCharIterator;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableCharSet;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;

/**
 * This file was automatically generated from template file unmodifiablePrimitivePrimitiveMap.stg.
 *
 * @since 3.1.
 */
public final class UnmodifiableCharCharMap
        implements MutableCharCharMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableCharCharMap map;

    UnmodifiableCharCharMap(MutableCharCharMap map)
    {
        this.map = map;
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(char key, char value)
    {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(CharCharMap map)
    {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(char key)
    {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(char key)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public char removeKeyIfAbsent(char key, char value)
    {
        if (this.map.containsKey(key))
        {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public char getIfAbsentPut(char key, char value)
    {
        return this.map.getIfAbsentPut(key, new CharFunction0()
        {
            public char value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public char getIfAbsentPut(char key, CharFunction0 function)
    {
        return this.map.getIfAbsentPut(key, new CharFunction0()
        {
            public char value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public char getIfAbsentPutWithKey(char key, CharToCharFunction function)
    {
        return this.map.getIfAbsentPut(key, new CharFunction0()
        {
            public char value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public <P> char getIfAbsentPutWith(char key, CharFunction<? super P> function, P parameter)
    {
        return this.map.getIfAbsentPut(key, new CharFunction0()
        {
            public char value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public char updateValue(char key, char initialValueIfAbsent, CharToCharFunction function)
    {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public char get(char key)
    {
        return this.map.get(key);
    }

    public char getIfAbsent(char key, char ifAbsent)
    {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public char getOrThrow(char key)
    {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(char key)
    {
        return this.map.containsKey(key);
    }

    public boolean containsValue(char value)
    {
        return this.map.containsValue(value);
    }

    public void forEachValue(CharProcedure procedure)
    {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(CharProcedure procedure)
    {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(CharCharProcedure procedure)
    {
        this.map.forEachKeyValue(procedure);
    }

    public LazyCharIterable keysView()
    {
        return this.map.keysView();
    }

    public RichIterable<CharCharPair> keyValuesView()
    {
        return this.map.keyValuesView();
    }

    public MutableCharCharMap select(CharCharPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableCharCharMap reject(CharCharPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public MutableCharIterator charIterator()
    {
        return new UnmodifiableCharIterator(this.map.charIterator());
    }

    public void forEach(CharProcedure procedure)
    {
        this.each(procedure);
    }

    /**
     * @since 7.0.
     */
    public void each(CharProcedure procedure)
    {
        this.map.forEach(procedure);
    }

    public int count(CharPredicate predicate)
    {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(CharPredicate predicate)
    {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(CharPredicate predicate)
    {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(CharPredicate predicate)
    {
        return this.map.noneSatisfy(predicate);
    }

    public MutableCharCollection select(CharPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableCharCollection reject(CharPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public char detectIfNone(CharPredicate predicate, char ifNone)
    {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V> MutableCollection<V> collect(CharToObjectFunction<? extends V> function)
    {
        return this.map.collect(function);
    }

    public long sum()
    {
        return this.map.sum();
    }

    public char max()
    {
        return this.map.max();
    }

    public char maxIfEmpty(char defaultValue)
    {
        return this.map.maxIfEmpty(defaultValue);
    }

    public char min()
    {
        return this.map.min();
    }

    public char minIfEmpty(char defaultValue)
    {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.map.average();
    }

    public double median()
    {
        return this.map.median();
    }

    public char addToValue(char key, char toBeAdded)
    {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public char[] toSortedArray()
    {
        return this.map.toSortedArray();
    }

    public MutableCharList toSortedList()
    {
        return this.map.toSortedList();
    }

    public char[] toArray()
    {
        return this.map.toArray();
    }

    public boolean contains(char value)
    {
        return this.map.contains(value);
    }

    public boolean containsAll(char... source)
    {
        return this.map.containsAll(source);
    }

    public boolean containsAll(CharIterable source)
    {
        return this.map.containsAll(source);
    }

    public MutableCharList toList()
    {
        return this.map.toList();
    }

    public MutableCharSet toSet()
    {
        return this.map.toSet();
    }

    public MutableCharBag toBag()
    {
        return this.map.toBag();
    }

    public LazyCharIterable asLazy()
    {
        return this.map.asLazy();
    }

    public MutableCharCharMap withKeyValue(char key, char value)
    {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableCharCharMap withoutKey(char key)
    {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableCharCharMap withoutAllKeys(CharIterable keys)
    {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableCharCharMap asUnmodifiable()
    {
        return this;
    }

    public MutableCharCharMap asSynchronized()
    {
        return new SynchronizedCharCharMap(this);
    }

    public ImmutableCharCharMap toImmutable()
    {
        return CharCharMaps.immutable.withAll(this);
    }

    public int size()
    {
        return this.map.size();
    }

    public boolean isEmpty()
    {
        return this.map.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.map.notEmpty();
    }

    public MutableCharSet keySet()
    {
        return UnmodifiableCharSet.of(this.map.keySet());
    }

    public MutableCharCollection values()
    {
        return UnmodifiableCharCollection.of(this.map.values());
    }

    @Override
    public boolean equals(Object otherMap)
    {
        return this.map.equals(otherMap);
    }

    @Override
    public int hashCode()
    {
        return this.map.hashCode();
    }

    @Override
    public String toString()
    {
        return this.map.toString();
    }

    public String makeString()
    {
        return this.map.makeString();
    }

    public String makeString(String separator)
    {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function)
    {
        return this.map.injectInto(injectedValue, function);
    }
}
