/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Locale;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.Pool;
import org.eclipse.emf.common.util.SegmentSequence;
import org.eclipse.emf.common.util.WeakInterningHashSet;

public final class CommonUtil {
    static final ReferenceQueue<Object> REFERENCE_CLEARING_QUEUE;
    private static volatile int[] POWERS_OF_31;
    static final StringPool STRING_POOL;

    static {
        ReferenceQueue<Object> referenceClearingQueue = null;
        try {
            boolean hasSecurityManager;
            try {
                hasSecurityManager = System.class.getMethod("getSecurityManager", new Class[0]).invoke(null, new Object[0]) != null;
            }
            catch (Exception ex) {
                hasSecurityManager = false;
            }
            String hasReferenceClearingQueue = System.getProperty("org.eclipse.emf.common.util.ReferenceClearingQueue");
            if (!hasSecurityManager ? !"false".equalsIgnoreCase(hasReferenceClearingQueue) : "true".equalsIgnoreCase(hasReferenceClearingQueue)) {
                class ReferenceClearingQueuePollingThread
                extends Thread {
                    protected final ReferenceQueue<Object> queue = new ReferenceQueue();

                    ReferenceClearingQueuePollingThread() {
                    }

                    @Override
                    public void run() {
                        try {
                            while (true) {
                                Reference<Object> reference = this.queue.remove();
                                reference.clear();
                            }
                        }
                        catch (InterruptedException exception) {
                            CommonPlugin.INSTANCE.log(exception);
                            return;
                        }
                    }
                }
                ReferenceClearingQueuePollingThread referenceClearingQueuePollingThread = new ReferenceClearingQueuePollingThread();
                referenceClearingQueuePollingThread.setDaemon(true);
                referenceClearingQueuePollingThread.setName("EMF Reference Cleaner");
                referenceClearingQueuePollingThread.start();
                referenceClearingQueue = referenceClearingQueuePollingThread.queue;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        REFERENCE_CLEARING_QUEUE = referenceClearingQueue;
        POWERS_OF_31 = new int[0];
        STRING_POOL = new StringPool(REFERENCE_CLEARING_QUEUE);
    }

    private CommonUtil() {
    }

    static int powerOf31(int n) {
        return POWERS_OF_31.length <= n ? CommonUtil.synchronizedPowerOf31(n) : POWERS_OF_31[n];
    }

    private static synchronized int synchronizedPowerOf31(int n) {
        if (POWERS_OF_31.length <= n) {
            int[] result = new int[Math.max(n + 100, 200)];
            int powerOf31 = 1;
            int i = 0;
            while (i < result.length) {
                result[i] = powerOf31;
                powerOf31 *= 31;
                ++i;
            }
            POWERS_OF_31 = result;
        }
        return POWERS_OF_31[n];
    }

    public static String intern(String value) {
        return value == null ? null : STRING_POOL.intern(value);
    }

    public static String internToLowerCase(String value) {
        return value == null ? null : STRING_POOL.intern(true, value);
    }

    public static String internToUpperCase(String value) {
        return value == null ? null : STRING_POOL.intern(false, value);
    }

    public static String javaIntern(String value) {
        return value == null ? null : STRING_POOL.javaIntern(value);
    }

    public static String intern(char[] characters, int offset, int count) {
        return STRING_POOL.intern(characters, offset, count);
    }

    public static String intern(String string, int offset, int count) {
        return STRING_POOL.intern(string, offset, count);
    }

    public static String intern(CharSequence value) {
        return value == null ? null : STRING_POOL.intern(value);
    }

    static final class StringPool
    extends Pool<String> {
        private static final long serialVersionUID = 1L;
        protected static final String EMPTY_STRING = "";
        private static final Locale DEFAULT_LOCALE = Locale.getDefault();
        protected final StringAccessUnit.Queue stringAccessUnits;
        protected final CharactersAccessUnit.Queue charactersAccessUnits = new CharactersAccessUnit.Queue();
        protected final SubstringAccessUnit.Queue substringAccessUnits = new SubstringAccessUnit.Queue();
        protected final CharSequenceAccessUnit.Queue charSequenceAccessUnits = new CharSequenceAccessUnit.Queue();
        protected final JavaInterningAccessUnit.Queue javaInterningAccessUnits = new JavaInterningAccessUnit.Queue();
        protected final StringsAccessUnit.Queue stringsAccessUnits = new StringsAccessUnit.Queue();

        protected StringPool() {
            this(null);
        }

        protected StringPool(ReferenceQueue<Object> queue) {
            super(1031, null, queue);
            this.containsNull = true;
            this.size = 1;
            this.javaIntern(EMPTY_STRING);
            this.stringAccessUnits = (StringAccessUnit.Queue)this.primaryAccessUnits;
        }

        @Override
        protected Pool.AccessUnit.Queue<String> newDefaultAccessUnits() {
            return new StringAccessUnit.Queue(this);
        }

        @Override
        protected WeakInterningHashSet.Entry<String> newInternalEntry(String object, int hashCode) {
            return new StringPoolEntry(object, hashCode, this.internalQueue);
        }

        @Override
        protected WeakInterningHashSet.Entry<String> newExternalEntry(String object, int hashCode) {
            return new SelfCleaningStringPoolEntry(this, object, hashCode, this.externalQueue);
        }

        @Override
        public final String intern(String string) {
            if (string == null) {
                return null;
            }
            int hashCode = string.hashCode();
            WeakInterningHashSet.Entry entry = this.getEntry(hashCode);
            while (entry != null) {
                String value = (String)entry.get();
                if (value == string || string.equals(value)) {
                    return value;
                }
                entry = entry.getNextEntry();
            }
            this.writeLock.lock();
            try {
                StringAccessUnit accessUnit = this.stringAccessUnits.pop(true);
                accessUnit.setValue(string, hashCode);
                String result = this.addEntry(true, accessUnit.getInternalizedValue(), accessUnit);
                accessUnit.reset(true);
                String string2 = result;
                return string2;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        protected final String intern(boolean toLowerCase, String string) {
            StringAccessUnit accessUnit = this.stringAccessUnits.pop(false);
            accessUnit.setValue(toLowerCase, string);
            return this.doIntern(false, accessUnit);
        }

        StringsAccessUnit getStringBuilder() {
            return this.stringsAccessUnits.pop(false);
        }

        @Override
        String intern(StringsAccessUnit stringBuilder) {
            return this.doIntern(false, stringBuilder);
        }

        protected final String intern(char[] characters, int offset, int count, int hashCode) {
            if (count == 0) {
                return EMPTY_STRING;
            }
            CharactersAccessUnit accessUnit = this.charactersAccessUnits.pop(false);
            accessUnit.setValue(characters, offset, count, hashCode);
            return this.doIntern(false, accessUnit);
        }

        protected final String intern(char[] characters, int offset, int count) {
            if (count == 0) {
                return EMPTY_STRING;
            }
            CharactersAccessUnit accessUnit = this.charactersAccessUnits.pop(false);
            accessUnit.setValue(characters, offset, count);
            return this.doIntern(false, accessUnit);
        }

        protected final String intern(String string, int offset, int count) {
            if (count == 0) {
                return EMPTY_STRING;
            }
            SubstringAccessUnit accessUnit = this.substringAccessUnits.pop(false);
            accessUnit.setValue(string, offset, count);
            return this.doIntern(false, accessUnit);
        }

        protected final String intern(String string, int offset, int count, int hashCode) {
            if (count == 0) {
                return EMPTY_STRING;
            }
            SubstringAccessUnit accessUnit = this.substringAccessUnits.pop(false);
            accessUnit.setValue(string, offset, count, hashCode);
            return this.doIntern(false, accessUnit);
        }

        @Override
        protected final String intern(CharSequence charSequence) {
            int charSequenceLength = charSequence.length();
            if (charSequenceLength == 0) {
                return EMPTY_STRING;
            }
            CharSequenceAccessUnit accessUnit = this.charSequenceAccessUnits.pop(false);
            accessUnit.setValue(charSequence, charSequenceLength);
            return this.doIntern(false, accessUnit);
        }

        protected final String javaIntern(String string) {
            JavaInterningAccessUnit accessUnit = this.javaInterningAccessUnits.pop(false);
            ((Pool.AccessUnit)accessUnit).setValue(string);
            return this.doIntern(false, accessUnit);
        }

        public static class AccessUnitBase
        extends Pool.AccessUnit<String> {
            protected char[] buffer = new char[100];

            protected AccessUnitBase(Pool.AccessUnit.Queue<String> queue) {
                super(queue);
            }

            @Override
            protected String getValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            protected void setValue(String value) {
                throw new UnsupportedOperationException();
            }

            @Override
            protected boolean setArbitraryValue(Object value) {
                throw new UnsupportedOperationException();
            }

            protected final char[] ensureCapacity(int length) {
                if (this.buffer.length < length) {
                    this.buffer = new char[length];
                }
                return this.buffer;
            }
        }

        public static class CharSequenceAccessUnit
        extends AccessUnitBase {
            protected CharSequence charSequence;
            protected int count;

            protected CharSequenceAccessUnit(Queue queue) {
                super(queue);
            }

            public void setValue(CharSequence charSequence, int count) {
                this.charSequence = charSequence;
                this.count = count;
                Class<?> valueClass = charSequence.getClass();
                char[] buffer = this.ensureCapacity(count);
                if (valueClass == StringBuilder.class) {
                    ((StringBuilder)charSequence).getChars(0, count, buffer, 0);
                } else if (valueClass == StringBuffer.class) {
                    ((StringBuffer)charSequence).getChars(0, count, buffer, 0);
                } else {
                    int hashCode = buffer[0] = charSequence.charAt(0);
                    int i = 1;
                    while (i < count) {
                        buffer[i] = charSequence.charAt(i);
                        hashCode = 31 * hashCode + buffer[i];
                        ++i;
                    }
                    this.hashCode = hashCode;
                    return;
                }
                int hashCode = buffer[0];
                int i = 1;
                while (i < count) {
                    hashCode = 31 * hashCode + buffer[i];
                    ++i;
                }
                this.hashCode = hashCode;
            }

            @Override
            protected boolean matches(String value) {
                return value.contentEquals(this.charSequence);
            }

            @Override
            public String getInternalizedValue() {
                return new String(this.buffer, 0, this.count);
            }

            @Override
            public void reset(boolean isExclusive) {
                this.charSequence = null;
                super.reset(isExclusive);
            }

            protected static class Queue
            extends Pool.AccessUnit.Queue<String> {
                private static final long serialVersionUID = 1L;

                protected Queue() {
                }

                public CharSequenceAccessUnit pop(boolean isExclusive) {
                    return (CharSequenceAccessUnit)super.pop(isExclusive);
                }

                @Override
                protected Pool.AccessUnit<String> newAccessUnit() {
                    return new CharSequenceAccessUnit(this);
                }
            }
        }

        public static class CharactersAccessUnit
        extends AccessUnitBase {
            protected char[] characters;
            protected int offset;
            protected int count;

            protected CharactersAccessUnit(Queue queue) {
                super(queue);
            }

            public void setValue(char[] characters, int offset, int count, int hashCode) {
                this.hashCode = hashCode;
                this.characters = characters;
                this.offset = offset;
                this.count = count;
            }

            public void setValue(char[] characters, int offset, int count) {
                this.characters = characters;
                this.offset = offset;
                this.count = count;
                int hashCode = 0;
                int i = offset;
                int limit = offset + count;
                while (i < limit) {
                    hashCode = 31 * hashCode + characters[i];
                    ++i;
                }
                this.hashCode = hashCode;
            }

            @Override
            protected boolean matches(String value) {
                int length = value.length();
                if (length != this.count) {
                    return false;
                }
                char[] characters = this.characters;
                int i = 0;
                int j = this.offset;
                while (i < length) {
                    if (characters[j] != value.charAt(i)) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
                return true;
            }

            @Override
            public String getInternalizedValue() {
                return new String(this.characters, this.offset, this.count);
            }

            @Override
            public void reset(boolean isExclusive) {
                this.characters = null;
                super.reset(isExclusive);
            }

            protected static class Queue
            extends Pool.AccessUnit.Queue<String> {
                private static final long serialVersionUID = 1L;

                protected Queue() {
                }

                public CharactersAccessUnit pop(boolean isExclusive) {
                    return (CharactersAccessUnit)super.pop(isExclusive);
                }

                @Override
                protected Pool.AccessUnit<String> newAccessUnit() {
                    return new CharactersAccessUnit(this);
                }
            }
        }

        public static class JavaInterningAccessUnit
        extends Pool.ObjectAccessUnit<String> {
            protected JavaInterningAccessUnit(Queue queue) {
                super(queue);
            }

            @Override
            public String getInternalizedValue() {
                return ((String)this.value).intern();
            }

            protected static class Queue
            extends Pool.AccessUnit.Queue<String> {
                private static final long serialVersionUID = 1L;

                protected Queue() {
                }

                public JavaInterningAccessUnit pop(boolean isExclusive) {
                    return (JavaInterningAccessUnit)super.pop(isExclusive);
                }

                @Override
                protected Pool.AccessUnit<String> newAccessUnit() {
                    return new JavaInterningAccessUnit(this);
                }
            }
        }

        protected static class SelfCleaningStringPoolEntry
        extends StringPoolEntry {
            protected final StringPool pool;

            public SelfCleaningStringPoolEntry(StringPool pool, String value, int hashCode, ReferenceQueue<Object> queue) {
                super(value, hashCode, queue);
                this.pool = pool;
            }

            @Override
            public void clear() {
                StringPool pool = this.pool;
                pool.writeLock.lock();
                try {
                    this.clear(pool);
                }
                finally {
                    pool.writeLock.unlock();
                }
            }
        }

        public static class StringAccessUnit
        extends AccessUnitBase {
            protected final StringPool pool;
            protected String value;
            protected Boolean toLowerCase;
            protected final Pool.ObjectAccessUnit<String> helperAccessUnit = new Pool.ObjectAccessUnit(null);

            protected StringAccessUnit(StringPool pool, Queue queue) {
                super(queue);
                this.pool = pool;
            }

            @Override
            protected void setValue(String value) {
                this.value = value;
                this.hashCode = value.hashCode();
            }

            protected void setValue(String value, int hashCode) {
                this.value = value;
                this.hashCode = hashCode;
            }

            @Override
            protected boolean setArbitraryValue(Object value) {
                if (value instanceof String) {
                    this.setValue((String)value);
                    return true;
                }
                return false;
            }

            protected void setValue(boolean toLowerCase, String value) {
                this.value = value;
                this.toLowerCase = toLowerCase ? Boolean.TRUE : Boolean.FALSE;
                this.hashCode = value.hashCode();
            }

            @Override
            protected boolean matches(String value) {
                return this.value == value || this.value.equals(value);
            }

            @Override
            public String match() {
                String result = (String)super.match();
                if (this.toLowerCase != null) {
                    StringPoolEntry entry;
                    if (result == null) {
                        Pool.ObjectAccessUnit<String> helperAccessUnit = this.helperAccessUnit;
                        result = this.getInternalizedValue();
                        helperAccessUnit.setValue(result, this.hashCode);
                        result = this.pool.addEntry(false, result, helperAccessUnit);
                        entry = (StringPoolEntry)helperAccessUnit.getEntry();
                        helperAccessUnit.reset(false);
                    } else {
                        entry = (StringPoolEntry)this.getEntry();
                    }
                    if (this.toLowerCase == Boolean.TRUE) {
                        String lowerCaseString;
                        StringPoolEntry lowerCaseEntry = entry.lowerCaseEntry;
                        if (lowerCaseEntry != null && (lowerCaseString = (String)lowerCaseEntry.get()) != null) {
                            return lowerCaseString;
                        }
                        lowerCaseString = result.toLowerCase(DEFAULT_LOCALE);
                        if (lowerCaseString == result) {
                            entry.lowerCaseEntry = entry;
                        } else {
                            Pool.ObjectAccessUnit<String> helperAccessUnit = this.helperAccessUnit;
                            ((Pool.AccessUnit)helperAccessUnit).setValue(lowerCaseString);
                            result = this.pool.addEntry(false, lowerCaseString, helperAccessUnit);
                            lowerCaseEntry.lowerCaseEntry = lowerCaseEntry = (StringPoolEntry)helperAccessUnit.getEntry();
                            entry.lowerCaseEntry = lowerCaseEntry;
                            ((Pool.AccessUnit)helperAccessUnit).reset(false);
                        }
                    } else {
                        String upperCaseString;
                        StringPoolEntry upperCaseEntry = entry.upperCaseEntry;
                        if (upperCaseEntry != null && (upperCaseString = (String)upperCaseEntry.get()) != null) {
                            return upperCaseString;
                        }
                        upperCaseString = result.toUpperCase(DEFAULT_LOCALE);
                        if (upperCaseString == result) {
                            entry.upperCaseEntry = entry;
                        } else {
                            Pool.ObjectAccessUnit<String> helperAccessUnit = this.helperAccessUnit;
                            ((Pool.AccessUnit)helperAccessUnit).setValue(upperCaseString);
                            result = this.pool.addEntry(false, upperCaseString, helperAccessUnit);
                            upperCaseEntry.upperCaseEntry = upperCaseEntry = (StringPoolEntry)helperAccessUnit.getEntry();
                            entry.upperCaseEntry = upperCaseEntry;
                            ((Pool.AccessUnit)helperAccessUnit).reset(false);
                        }
                    }
                }
                return result;
            }

            @Override
            public String getInternalizedValue() {
                return new String(this.value);
            }

            @Override
            public void reset(boolean isExclusive) {
                this.value = null;
                this.toLowerCase = null;
                super.reset(isExclusive);
            }

            protected static class Queue
            extends Pool.AccessUnit.Queue<String> {
                private static final long serialVersionUID = 1L;
                protected final StringPool pool;

                public Queue(StringPool pool) {
                    this.pool = pool;
                }

                public StringAccessUnit pop(boolean isExclusive) {
                    return (StringAccessUnit)super.pop(isExclusive);
                }

                @Override
                protected Pool.AccessUnit<String> newAccessUnit() {
                    return new StringAccessUnit(this.pool, this);
                }
            }
        }

        protected static class StringPoolEntry
        extends WeakInterningHashSet.Entry<String> {
            protected StringPoolEntry lowerCaseEntry;
            protected StringPoolEntry upperCaseEntry;

            public StringPoolEntry(String value, int hashCode, ReferenceQueue<? super String> queue) {
                super(value, hashCode, queue);
            }

            @Override
            public void doClear() {
                this.lowerCaseEntry = null;
                this.upperCaseEntry = null;
                super.doClear();
            }
        }

        static class StringsAccessUnit
        extends Pool.ObjectAccessUnit<String> {
            protected static final int CHAR_STRINGS_COUNT = 256;
            protected static final String[] CHAR_STRINGS = new String[256];
            protected String[] strings = new String[20];
            protected char[] characters = new char[100];
            protected int length;
            protected int stringLength;

            static {
                int i = 0;
                while (i < 256) {
                    StringsAccessUnit.CHAR_STRINGS[i] = CommonUtil.javaIntern(String.valueOf((char)i));
                    ++i;
                }
            }

            protected StringsAccessUnit(Queue queue) {
                super(queue);
            }

            protected void ensureCapacity(int length) {
                if (this.strings.length <= length) {
                    String[] newStrings = new String[length * 2];
                    System.arraycopy(this.strings, 0, newStrings, 0, this.length);
                    this.strings = newStrings;
                }
            }

            protected void doAppend(String string) {
                this.ensureCapacity(this.length);
                this.basicAppend(string);
            }

            protected void basicAppend(String string) {
                int stringLength = string.length();
                if (stringLength != 0) {
                    this.strings[this.length++] = string;
                    this.hashCode = this.hashCode * CommonUtil.powerOf31(stringLength) + string.hashCode();
                    this.stringLength += stringLength;
                }
            }

            public void append(char c) {
                if (c < '\u0100') {
                    this.doAppend(CHAR_STRINGS[c]);
                } else {
                    this.doAppend(String.valueOf(c));
                }
            }

            public void append(String string) {
                this.doAppend(string == null ? StringPool.EMPTY_STRING : string);
            }

            public void append(CharSequence charSequence) {
                if (charSequence == null) {
                    this.doAppend("null");
                } else {
                    Class<?> charSequenceClass = charSequence.getClass();
                    if (charSequenceClass == SegmentSequence.class) {
                        SegmentSequence segmentSequence = (SegmentSequence)charSequence;
                        String delimiter = segmentSequence.delimiter;
                        String[] segments = segmentSequence.segments;
                        int segmentsLength = segments.length;
                        if (segmentsLength > 0) {
                            if (delimiter == StringPool.EMPTY_STRING) {
                                this.ensureCapacity(this.length + segmentsLength);
                                int i = 0;
                                while (i < segmentsLength) {
                                    this.basicAppend(segments[i]);
                                    ++i;
                                }
                            } else {
                                this.ensureCapacity(this.length + 2 * segmentsLength - 1);
                                this.basicAppend(segments[0]);
                                int i = 1;
                                while (i < segmentsLength) {
                                    this.basicAppend(delimiter);
                                    this.basicAppend(segments[i]);
                                    ++i;
                                }
                            }
                        }
                    } else {
                        this.doAppend(charSequence.toString());
                    }
                }
            }

            @Override
            protected boolean matches(String value) {
                if (value.length() != this.stringLength) {
                    return false;
                }
                String[] strings = this.strings;
                int i = 0;
                int index = 0;
                int length = this.length;
                while (i < length) {
                    String string = strings[i];
                    if (!value.startsWith(string, index)) {
                        return false;
                    }
                    index += string.length();
                    ++i;
                }
                return true;
            }

            @Override
            public String getInternalizedValue() {
                if (this.characters.length < this.stringLength) {
                    this.characters = new char[Math.max(this.stringLength, this.characters.length * 2)];
                }
                String[] strings = this.strings;
                int i = 0;
                int index = 0;
                int length = this.length;
                while (i < length) {
                    String string = strings[i];
                    int stringLength = string.length();
                    string.getChars(0, stringLength, this.characters, index);
                    index += string.length();
                    ++i;
                }
                return new String(this.characters, 0, this.stringLength);
            }

            @Override
            public void reset(boolean isExclusive) {
                String[] strings = this.strings;
                int i = 0;
                int length = this.length;
                while (i < length) {
                    strings[i] = null;
                    ++i;
                }
                this.hashCode = 0;
                this.length = 0;
                this.stringLength = 0;
                super.reset(isExclusive);
            }

            protected static class Queue
            extends Pool.AccessUnit.Queue<String> {
                private static final long serialVersionUID = 1L;

                protected Queue() {
                }

                public StringsAccessUnit pop(boolean isExclusive) {
                    return (StringsAccessUnit)super.pop(isExclusive);
                }

                @Override
                protected Pool.AccessUnit<String> newAccessUnit() {
                    return new StringsAccessUnit(this);
                }
            }
        }

        public static class SubstringAccessUnit
        extends AccessUnitBase {
            private String string;
            private int offset;
            private int count;

            protected SubstringAccessUnit(Queue queue) {
                super(queue);
            }

            public void setValue(String string, int offset, int count, int hashCode) {
                this.hashCode = hashCode;
                this.string = string;
                this.offset = offset;
                this.count = count;
            }

            public void setValue(String string, int offset, int count) {
                this.string = string;
                this.offset = offset;
                this.count = count;
                int hashCode = 0;
                int i = offset;
                int limit = offset + count;
                while (i < limit) {
                    hashCode = 31 * hashCode + string.charAt(i);
                    ++i;
                }
                this.hashCode = hashCode;
            }

            @Override
            protected boolean matches(String value) {
                return value.length() == this.count && value.regionMatches(0, this.string, this.offset, this.count);
            }

            @Override
            public String getInternalizedValue() {
                return new String(this.string.substring(this.offset, this.offset + this.count));
            }

            @Override
            public void reset(boolean isExclusive) {
                this.string = null;
                super.reset(isExclusive);
            }

            protected static class Queue
            extends Pool.AccessUnit.Queue<String> {
                private static final long serialVersionUID = 1L;

                protected Queue() {
                }

                public SubstringAccessUnit pop(boolean isExclusive) {
                    return (SubstringAccessUnit)super.pop(isExclusive);
                }

                @Override
                protected Pool.AccessUnit<String> newAccessUnit() {
                    return new SubstringAccessUnit(this);
                }
            }
        }
    }
}

