/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.ecore;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDAttributeUseCategory;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDConstraint;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDFractionDigitsFacet;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDLengthFacet;
import org.eclipse.xsd.XSDMaxExclusiveFacet;
import org.eclipse.xsd.XSDMaxInclusiveFacet;
import org.eclipse.xsd.XSDMaxLengthFacet;
import org.eclipse.xsd.XSDMinExclusiveFacet;
import org.eclipse.xsd.XSDMinInclusiveFacet;
import org.eclipse.xsd.XSDMinLengthFacet;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDPatternFacet;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTotalDigitsFacet;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWhiteSpace;
import org.eclipse.xsd.XSDWhiteSpaceFacet;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.ecore.MapBuilder;
import org.eclipse.xsd.util.XSDConstants;
import org.eclipse.xsd.util.XSDParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EcoreSchemaBuilder
extends MapBuilder {
    protected String defaultXMLSchemaNamespace = "http://www.w3.org/2001/XMLSchema";
    protected String defaultXMLSchemaNamespacePrefix = "xsd";
    protected ExtendedMetaData extendedMetaData;
    protected Map<EModelElement, XSDComponent> eModelElementToXSDComponentMap = new HashMap<EModelElement, XSDComponent>();
    protected static final String GEN_MODEL_PACKAGE_NS_URI = "http://www.eclipse.org/emf/2002/GenModel";

    public EcoreSchemaBuilder(ExtendedMetaData extendedMetaData) {
        this.extendedMetaData = extendedMetaData;
    }

    @Override
    protected void map(XSDComponent xsdComponent, EModelElement eModelElement) {
        super.map(xsdComponent, eModelElement);
        this.eModelElementToXSDComponentMap.put(eModelElement, xsdComponent);
    }

    public XSDSchema getSchema(EPackage ePackage) {
        XSDSchema xsdSchema = (XSDSchema)this.eModelElementToXSDComponentMap.get(ePackage);
        if (xsdSchema == null) {
            xsdSchema = this.buildSchema(ePackage);
        }
        return xsdSchema;
    }

    protected String getQualifiedPackageName(EPackage ePackage) {
        return ePackage.getName();
    }

    protected XSDSchema buildSchema(EPackage ePackage) {
        XSDSchema xsdSchema = XSDFactory.eINSTANCE.createXSDSchema();
        this.addInput((EObject)ePackage);
        this.addOutput(xsdSchema);
        this.map(xsdSchema, (EModelElement)ePackage);
        String targetNamespace = this.extendedMetaData.getNamespace(ePackage);
        xsdSchema.setTargetNamespace(targetNamespace);
        Map<String, String> namespaces = xsdSchema.getQNamePrefixToNamespaceMap();
        xsdSchema.setSchemaForSchemaQNamePrefix(this.defaultXMLSchemaNamespacePrefix);
        namespaces.put(this.defaultXMLSchemaNamespacePrefix, this.defaultXMLSchemaNamespace);
        this.handlePrefix(namespaces, ePackage.getNsPrefix(), targetNamespace);
        xsdSchema.updateElement();
        this.buildAnnotations(xsdSchema, (EModelElement)ePackage);
        this.createEcoreAnnotation(xsdSchema, "package", this.getQualifiedPackageName(ePackage));
        this.createEcoreAnnotation(xsdSchema, "nsPrefix", ePackage.getNsPrefix());
        EClass documentRootEClass = this.extendedMetaData.getDocumentRoot(ePackage);
        if (documentRootEClass == null) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                EClass eClass;
                if (!(eClassifier instanceof EClass) || this.extendedMetaData.getContentKind(eClass = (EClass)eClassifier) != 0) continue;
                this.buildGlobalElement(xsdSchema, eClass);
            }
        } else {
            if (!"DocumentRoot".equals(documentRootEClass.getName())) {
                this.createEcoreAnnotation(xsdSchema, "documentRoot", documentRootEClass.getName());
            }
            int i = 0;
            int size = documentRootEClass.getFeatureCount();
            while (i < size) {
                EStructuralFeature eStructuralFeature = documentRootEClass.getEStructuralFeature(i);
                if (this.extendedMetaData.getName(eStructuralFeature).indexOf(58) == -1) {
                    this.buildGlobalFeature(xsdSchema, eStructuralFeature);
                }
                ++i;
            }
        }
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            if (eClassifier == documentRootEClass) continue;
            this.buildTypeDefinition(xsdSchema, eClassifier);
        }
        return xsdSchema;
    }

    protected XSDElementDeclaration buildGlobalElement(XSDSchema xsdSchema, EClass eClass) {
        XSDElementDeclaration xsdElementDeclaration = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElementDeclaration.setName(this.extendedMetaData.getName((EClassifier)eClass));
        XSDTypeDefinition xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(this.getURI((EClassifier)eClass));
        this.handleImport(xsdSchema, xsdTypeDefinition);
        xsdElementDeclaration.setTypeDefinition(xsdTypeDefinition);
        xsdSchema.getContents().add((Object)xsdElementDeclaration);
        this.map(xsdElementDeclaration, (EModelElement)eClass);
        this.createEcoreAnnotation(xsdElementDeclaration, "ignore", "true");
        return xsdElementDeclaration;
    }

    protected XSDFeature buildGlobalFeature(XSDSchema xsdSchema, EStructuralFeature eStructuralFeature) {
        switch (this.extendedMetaData.getFeatureKind(eStructuralFeature)) {
            case 4: {
                XSDElementDeclaration xsdElementDeclaration = this.buildGlobalElement(xsdSchema, eStructuralFeature);
                return xsdElementDeclaration;
            }
            case 2: {
                XSDAttributeDeclaration xsdAttributeDeclaration = this.buildGlobalAttribute(xsdSchema, eStructuralFeature);
                return xsdAttributeDeclaration;
            }
        }
        return null;
    }

    protected String transformDefaultValue(XSDSimpleTypeDefinition xsdSimpleTypeDefinition, String defaultValue) {
        XSDSimpleTypeDefinition primitiveTypeDefinition = xsdSimpleTypeDefinition.getPrimitiveTypeDefinition();
        if (primitiveTypeDefinition != null && (primitiveTypeDefinition.hasNameAndTargetNamespace("float", this.defaultXMLSchemaNamespace) || primitiveTypeDefinition.hasNameAndTargetNamespace("double", this.defaultXMLSchemaNamespace))) {
            if ("Infinity".equals(defaultValue)) {
                return "INF";
            }
            if ("-Infinity".equals(defaultValue)) {
                return "-INF";
            }
        }
        return defaultValue;
    }

    protected XSDElementDeclaration buildGlobalElement(XSDSchema xsdSchema, EStructuralFeature eStructuralFeature) {
        String defaultValue;
        EStructuralFeature affiliation;
        XSDElementDeclaration xsdElementDeclaration = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElementDeclaration.setName(this.extendedMetaData.getName(eStructuralFeature));
        if (!eStructuralFeature.isChangeable()) {
            xsdElementDeclaration.setAbstract(true);
        }
        if ((affiliation = this.extendedMetaData.getAffiliation(eStructuralFeature)) != null) {
            XSDElementDeclaration xsdAffiliation = xsdSchema.resolveElementDeclarationURI(this.getURI(affiliation));
            this.handleImport(xsdSchema, xsdAffiliation);
            xsdElementDeclaration.setSubstitutionGroupAffiliation(xsdAffiliation);
        }
        EClassifier eType = eStructuralFeature.getEType();
        XSDTypeDefinition xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(this.getURI(eType));
        this.handleImport(xsdSchema, xsdTypeDefinition);
        xsdElementDeclaration.setTypeDefinition(xsdTypeDefinition);
        if (this.isWrapperType(eType)) {
            xsdElementDeclaration.setNillable(true);
        }
        if ((defaultValue = eStructuralFeature.getDefaultValueLiteral()) != null) {
            xsdElementDeclaration.setConstraint(XSDConstraint.DEFAULT_LITERAL);
            xsdElementDeclaration.setLexicalValue(this.transformDefaultValue((XSDSimpleTypeDefinition)xsdElementDeclaration.getTypeDefinition(), defaultValue));
        }
        xsdSchema.getContents().add((Object)xsdElementDeclaration);
        this.map(xsdElementDeclaration, (EModelElement)eStructuralFeature);
        if (eStructuralFeature.eIsSet((EStructuralFeature)EcorePackage.Literals.ETYPED_ELEMENT__EGENERIC_TYPE)) {
            this.createEcoreAnnotation(xsdElementDeclaration, "type", this.getGenericType(xsdSchema, eStructuralFeature.getEGenericType()));
        }
        this.buildAnnotations(xsdElementDeclaration, (EModelElement)eStructuralFeature);
        return xsdElementDeclaration;
    }

    protected XSDAttributeDeclaration buildGlobalAttribute(XSDSchema xsdSchema, EStructuralFeature eStructuralFeature) {
        XSDAttributeDeclaration xsdAttributeDeclaration = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
        xsdAttributeDeclaration.setName(this.extendedMetaData.getName(eStructuralFeature));
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = xsdSchema.resolveSimpleTypeDefinitionURI(this.getURI(eStructuralFeature.getEType()));
        this.handleImport(xsdSchema, xsdSimpleTypeDefinition);
        xsdAttributeDeclaration.setTypeDefinition(xsdSimpleTypeDefinition);
        String defaultValue = eStructuralFeature.getDefaultValueLiteral();
        if (defaultValue != null) {
            xsdAttributeDeclaration.setConstraint(XSDConstraint.DEFAULT_LITERAL);
            xsdAttributeDeclaration.setLexicalValue(this.transformDefaultValue(xsdAttributeDeclaration.getTypeDefinition(), defaultValue));
        }
        xsdSchema.getContents().add((Object)xsdAttributeDeclaration);
        this.map(xsdAttributeDeclaration, (EModelElement)eStructuralFeature);
        if (eStructuralFeature.eIsSet((EStructuralFeature)EcorePackage.Literals.ETYPED_ELEMENT__EGENERIC_TYPE)) {
            this.createEcoreAnnotation(xsdAttributeDeclaration, "type", this.getGenericType(xsdSchema, eStructuralFeature.getEGenericType()));
        }
        this.buildAnnotations(xsdAttributeDeclaration, (EModelElement)eStructuralFeature);
        return xsdAttributeDeclaration;
    }

    protected XSDTypeDefinition buildTypeDefinition(XSDSchema xsdSchema, EClassifier eClassifier) {
        if (eClassifier instanceof EClass) {
            return this.buildComplexTypeDefinition(xsdSchema, (EClass)eClassifier);
        }
        return this.buildSimpleTypeDefinition(xsdSchema, (EDataType)eClassifier);
    }

    protected XSDSimpleTypeDefinition buildSimpleTypeDefinition(XSDSchema xsdSchema, EDataType eDataType) {
        String name = this.extendedMetaData.getName((EClassifier)eDataType);
        boolean isAnonymousWrapperType = name.endsWith(":Object");
        if (isAnonymousWrapperType && "http://www.eclipse.org/emf/2002/Ecore".equals(xsdSchema.getTargetNamespace())) {
            name = eDataType.getName();
            isAnonymousWrapperType = false;
        }
        if (!isAnonymousWrapperType) {
            String constraints;
            int whiteSpace;
            int fractionDigits;
            int totalDigits;
            int minLength;
            int maxLength;
            int length;
            String maxExclusive;
            String minExclusive;
            String maxInclusive;
            String minInclusive;
            XSDSimpleTypeDefinition xsdSimpleTypeDefinition = XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
            xsdSimpleTypeDefinition.setName(name);
            String instanceClass = null;
            EDataType baseType = this.extendedMetaData.getBaseType(eDataType);
            if (baseType != null) {
                XSDSimpleTypeDefinition baseTypeDefinition = xsdSchema.resolveSimpleTypeDefinitionURI(this.getURI((EClassifier)baseType));
                this.handleImport(xsdSchema, baseTypeDefinition);
                xsdSimpleTypeDefinition.setBaseTypeDefinition(baseTypeDefinition);
                instanceClass = eDataType.getInstanceTypeName();
                if (instanceClass != null && instanceClass.equals(baseType.getInstanceTypeName())) {
                    instanceClass = null;
                }
            } else {
                EDataType itemType = this.extendedMetaData.getItemType(eDataType);
                if (itemType != null) {
                    XSDSimpleTypeDefinition itemTypeDefinition = xsdSchema.resolveSimpleTypeDefinitionURI(this.getURI((EClassifier)itemType));
                    this.handleImport(xsdSchema, itemTypeDefinition);
                    xsdSimpleTypeDefinition.setItemTypeDefinition(itemTypeDefinition);
                } else {
                    List memberTypes = this.extendedMetaData.getMemberTypes(eDataType);
                    if (!memberTypes.isEmpty()) {
                        for (EDataType memberType : memberTypes) {
                            XSDSimpleTypeDefinition memberTypeDefinition = xsdSchema.resolveSimpleTypeDefinitionURI(this.getURI((EClassifier)memberType));
                            this.handleImport(xsdSchema, memberTypeDefinition);
                            xsdSimpleTypeDefinition.getMemberTypeDefinitions().add((Object)memberTypeDefinition);
                        }
                    } else {
                        xsdSimpleTypeDefinition.setBaseTypeDefinition(xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("string"));
                        if (!(eDataType instanceof EEnum)) {
                            instanceClass = eDataType.getInstanceTypeName();
                        }
                    }
                }
            }
            xsdSchema.getContents().add((Object)xsdSimpleTypeDefinition);
            this.map(xsdSimpleTypeDefinition, (EModelElement)eDataType);
            this.buildTypeParameters(xsdSimpleTypeDefinition, (List<ETypeParameter>)eDataType.getETypeParameters());
            if (instanceClass != null) {
                this.createEcoreAnnotation(xsdSimpleTypeDefinition, "instanceClass", instanceClass.replace('<', '{').replace('>', '}'));
            }
            if ((minInclusive = this.extendedMetaData.getMinInclusiveFacet(eDataType)) != null) {
                XSDMinInclusiveFacet xsdMinInclusiveFacet = XSDFactory.eINSTANCE.createXSDMinInclusiveFacet();
                xsdMinInclusiveFacet.setLexicalValue(minInclusive);
                xsdSimpleTypeDefinition.getFacetContents().add((Object)xsdMinInclusiveFacet);
            }
            if ((maxInclusive = this.extendedMetaData.getMaxInclusiveFacet(eDataType)) != null) {
                XSDMaxInclusiveFacet xsdMaxInclusiveFacet = XSDFactory.eINSTANCE.createXSDMaxInclusiveFacet();
                xsdMaxInclusiveFacet.setLexicalValue(maxInclusive);
                xsdSimpleTypeDefinition.getFacetContents().add((Object)xsdMaxInclusiveFacet);
            }
            if ((minExclusive = this.extendedMetaData.getMinExclusiveFacet(eDataType)) != null) {
                XSDMinExclusiveFacet xsdMinExclusiveFacet = XSDFactory.eINSTANCE.createXSDMinExclusiveFacet();
                xsdMinExclusiveFacet.setLexicalValue(minExclusive);
                xsdSimpleTypeDefinition.getFacetContents().add((Object)xsdMinExclusiveFacet);
            }
            if ((maxExclusive = this.extendedMetaData.getMaxExclusiveFacet(eDataType)) != null) {
                XSDMaxExclusiveFacet xsdMaxExclusiveFacet = XSDFactory.eINSTANCE.createXSDMaxExclusiveFacet();
                xsdMaxExclusiveFacet.setLexicalValue(maxExclusive);
                xsdSimpleTypeDefinition.getFacetContents().add((Object)xsdMaxExclusiveFacet);
            }
            if ((length = this.extendedMetaData.getLengthFacet(eDataType)) != -1) {
                XSDLengthFacet xsdLengthFacet = XSDFactory.eINSTANCE.createXSDLengthFacet();
                xsdLengthFacet.setLexicalValue(Integer.toString(length));
                xsdSimpleTypeDefinition.getFacetContents().add((Object)xsdLengthFacet);
            }
            if ((maxLength = this.extendedMetaData.getMaxLengthFacet(eDataType)) != -1) {
                XSDMaxLengthFacet xsdMaxLengthFacet = XSDFactory.eINSTANCE.createXSDMaxLengthFacet();
                xsdMaxLengthFacet.setLexicalValue(Integer.toString(maxLength));
                xsdSimpleTypeDefinition.getFacetContents().add((Object)xsdMaxLengthFacet);
            }
            if ((minLength = this.extendedMetaData.getMinLengthFacet(eDataType)) != -1) {
                XSDMinLengthFacet xsdMinLengthFacet = XSDFactory.eINSTANCE.createXSDMinLengthFacet();
                xsdMinLengthFacet.setLexicalValue(Integer.toString(minLength));
                xsdSimpleTypeDefinition.getFacetContents().add((Object)xsdMinLengthFacet);
            }
            if ((totalDigits = this.extendedMetaData.getTotalDigitsFacet(eDataType)) != -1) {
                XSDTotalDigitsFacet xsdTotalDigitsFacet = XSDFactory.eINSTANCE.createXSDTotalDigitsFacet();
                xsdTotalDigitsFacet.setLexicalValue(Integer.toString(totalDigits));
                xsdSimpleTypeDefinition.getFacetContents().add((Object)xsdTotalDigitsFacet);
            }
            if ((fractionDigits = this.extendedMetaData.getFractionDigitsFacet(eDataType)) != -1) {
                XSDFractionDigitsFacet xsdFractionDigitsFacet = XSDFactory.eINSTANCE.createXSDFractionDigitsFacet();
                xsdFractionDigitsFacet.setLexicalValue(Integer.toString(fractionDigits));
                xsdSimpleTypeDefinition.getFacetContents().add((Object)xsdFractionDigitsFacet);
            }
            if ((whiteSpace = this.extendedMetaData.getWhiteSpaceFacet(eDataType)) != 0) {
                XSDWhiteSpaceFacet xsdWhiteSpaceFacet = XSDFactory.eINSTANCE.createXSDWhiteSpaceFacet();
                xsdWhiteSpaceFacet.setLexicalValue(XSDWhiteSpace.get(whiteSpace - 1).toString());
                xsdSimpleTypeDefinition.getFacetContents().add((Object)xsdWhiteSpaceFacet);
            }
            for (String pattern : this.extendedMetaData.getPatternFacet(eDataType)) {
                XSDPatternFacet xsdPatternFacet = XSDFactory.eINSTANCE.createXSDPatternFacet();
                xsdPatternFacet.setLexicalValue(pattern);
                xsdSimpleTypeDefinition.getFacetContents().add((Object)xsdPatternFacet);
            }
            for (String enumeration : this.extendedMetaData.getEnumerationFacet(eDataType)) {
                XSDEnumerationFacet xsdEnumerationFacet = XSDFactory.eINSTANCE.createXSDEnumerationFacet();
                xsdEnumerationFacet.setLexicalValue(enumeration);
                xsdSimpleTypeDefinition.getFacetContents().add((Object)xsdEnumerationFacet);
            }
            String ecoreName = eDataType.getName();
            if (!name.equals(ecoreName) || Character.isLowerCase(ecoreName.charAt(0)) || ecoreName.indexOf(95) != -1) {
                this.createEcoreAnnotation(xsdSimpleTypeDefinition, "name", ecoreName);
            }
            if ((constraints = EcoreUtil.getAnnotation((EModelElement)eDataType, (String)"http://www.eclipse.org/emf/2002/Ecore", (String)"constraints")) != null) {
                this.createEcoreAnnotation(xsdSimpleTypeDefinition, "constraints", constraints);
            }
            if (!eDataType.isSerializable()) {
                this.createEcoreAnnotation(xsdSimpleTypeDefinition, "serializable", "false");
            }
            if (eDataType instanceof EEnum) {
                EEnum eEnum = (EEnum)eDataType;
                ListIterator literals = eEnum.getELiterals().listIterator();
                while (literals.hasNext()) {
                    EEnumLiteral literal = (EEnumLiteral)literals.next();
                    XSDEnumerationFacet facet = XSDFactory.eINSTANCE.createXSDEnumerationFacet();
                    facet.setLexicalValue(literal.getLiteral());
                    xsdSimpleTypeDefinition.getFacetContents().add((Object)facet);
                    this.map(facet, (EModelElement)literal);
                    if (!literal.getLiteral().equals(literal.getName())) {
                        this.createEcoreAnnotation(facet, "name", literal.getName());
                    }
                    if (literal.getValue() != literals.previousIndex()) {
                        this.createEcoreAnnotation(facet, "value", Integer.toString(literal.getValue()));
                    }
                    this.buildAnnotations(facet, (EModelElement)literal);
                }
            }
            this.buildAnnotations(xsdSimpleTypeDefinition, (EModelElement)eDataType);
            return xsdSimpleTypeDefinition;
        }
        return null;
    }

    protected XSDComplexTypeDefinition buildComplexTypeDefinition(XSDSchema xsdSchema, EClass eClass) {
        String constraints;
        String ecoreName;
        EList genericTypeTypes;
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        String name = this.extendedMetaData.getName((EClassifier)eClass);
        xsdComplexTypeDefinition.setName(name);
        if (eClass.isAbstract()) {
            xsdComplexTypeDefinition.setAbstract(true);
        }
        if (!(genericTypeTypes = eClass.getEGenericSuperTypes()).isEmpty()) {
            Iterator i = genericTypeTypes.iterator();
            EGenericType genericSuperType = (EGenericType)i.next();
            XSDTypeDefinition baseType = xsdSchema.resolveTypeDefinitionURI(this.getURI(genericSuperType.getERawType()));
            if (!XSDConstants.isURType(baseType)) {
                this.handleImport(xsdSchema, baseType);
                xsdComplexTypeDefinition.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
                xsdComplexTypeDefinition.setBaseTypeDefinition(baseType);
            }
            xsdSchema.getContents().add((Object)xsdComplexTypeDefinition);
            if (!genericSuperType.getETypeArguments().isEmpty()) {
                this.createEcoreAnnotation(xsdComplexTypeDefinition, "extends", this.getGenericType(xsdSchema, genericSuperType));
            }
            if (i.hasNext()) {
                StringBuilder additionalSuperTypes = new StringBuilder();
                do {
                    additionalSuperTypes.append(this.getGenericType(xsdSchema, (EGenericType)i.next()));
                    additionalSuperTypes.append(' ');
                } while (i.hasNext());
                this.createEcoreAnnotation(xsdComplexTypeDefinition, "implements", additionalSuperTypes.toString().trim());
            }
        } else {
            xsdSchema.getContents().add((Object)xsdComplexTypeDefinition);
        }
        this.buildTypeParameters(xsdComplexTypeDefinition, (List<ETypeParameter>)eClass.getETypeParameters());
        this.map(xsdComplexTypeDefinition, (EModelElement)eClass);
        String instanceClass = eClass.getInstanceTypeName();
        if (instanceClass != null) {
            this.createEcoreAnnotation(xsdComplexTypeDefinition, "instanceClass", instanceClass.replace('<', '{').replace('>', '}'));
        }
        if (!name.equals(ecoreName = eClass.getName()) || Character.isLowerCase(ecoreName.charAt(0)) || ecoreName.indexOf(95) != -1) {
            this.createEcoreAnnotation(xsdComplexTypeDefinition, "name", ecoreName);
        }
        if (eClass.isInterface()) {
            this.createEcoreAnnotation(xsdComplexTypeDefinition, "interface", "true");
        }
        if ((constraints = EcoreUtil.getAnnotation((EModelElement)eClass, (String)"http://www.eclipse.org/emf/2002/Ecore", (String)"constraints")) != null) {
            this.createEcoreAnnotation(xsdComplexTypeDefinition, "constraints", constraints);
        }
        for (EStructuralFeature eStructuralFeature : eClass.getEStructuralFeatures()) {
            this.buildContentFeature(xsdComplexTypeDefinition, eStructuralFeature);
        }
        EList eOperations = eClass.getEOperations();
        if (!eOperations.isEmpty()) {
            XSDAnnotation xsdAnnotation = xsdComplexTypeDefinition.getAnnotation();
            if (xsdAnnotation == null) {
                xsdAnnotation = XSDFactory.eINSTANCE.createXSDAnnotation();
                xsdComplexTypeDefinition.setAnnotation(xsdAnnotation);
            }
            Element applicationInformation = xsdAnnotation.createApplicationInformation("http://www.eclipse.org/emf/2002/Ecore");
            xsdAnnotation.getElement().appendChild(applicationInformation);
            this.createEcoreAnnotation(xsdSchema.getQNamePrefixToNamespaceMap(), applicationInformation, "key", "operations");
            Document document = xsdSchema.getDocument();
            for (EOperation eOperation : eOperations) {
                String body;
                Iterator eGenericType2;
                EList exceptions;
                Element operation = document.createElementNS(null, "operation");
                operation.setAttributeNS(null, "name", eOperation.getName());
                applicationInformation.appendChild(operation);
                this.buildAnnotation((EModelElement)eOperation, operation);
                this.buildTypeParameters(xsdAnnotation, (List<ETypeParameter>)eOperation.getETypeParameters());
                EGenericType returnEGenericType = eOperation.getEGenericType();
                if (returnEGenericType != null) {
                    operation.setAttributeNS(null, "type", this.getGenericType(xsdSchema, returnEGenericType));
                }
                if (!(exceptions = eOperation.getEExceptions()).isEmpty()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Iterator eGenericType2 : eOperation.getEGenericExceptions()) {
                        stringBuilder.append(this.getGenericType(xsdSchema, (EGenericType)eGenericType2));
                        stringBuilder.append(' ');
                    }
                    operation.setAttributeNS(null, "exceptions", stringBuilder.substring(0, stringBuilder.length() - 1));
                }
                eGenericType2 = eOperation.getEParameters().iterator();
                while (eGenericType2.hasNext()) {
                    EParameter eParameter = (EParameter)eGenericType2.next();
                    Element parameter = document.createElementNS(null, "parameter");
                    parameter.setAttributeNS(null, "name", eParameter.getName());
                    operation.appendChild(parameter);
                    this.buildAnnotation((EModelElement)eParameter, parameter);
                    parameter.setAttributeNS(null, "type", this.getGenericType(xsdSchema, eParameter.getEGenericType()));
                    if (eParameter.getLowerBound() != 0) {
                        parameter.setAttributeNS(null, "lowerBound", Integer.toString(eParameter.getLowerBound()));
                    }
                    if (eParameter.getUpperBound() != 1) {
                        parameter.setAttributeNS(null, "upperBound", Integer.toString(eParameter.getUpperBound()));
                    }
                    if (!eParameter.isOrdered()) {
                        parameter.setAttributeNS(null, "ordered", "false");
                    }
                    if (eParameter.isUnique()) continue;
                    parameter.setAttributeNS(null, "unique", "false");
                }
                if (eOperation.getLowerBound() != 0) {
                    operation.setAttributeNS(null, "lowerBound", Integer.toString(eOperation.getLowerBound()));
                }
                if (eOperation.getUpperBound() != 1) {
                    operation.setAttributeNS(null, "upperBound", Integer.toString(eOperation.getUpperBound()));
                }
                if (!eOperation.isOrdered()) {
                    operation.setAttributeNS(null, "ordered", "false");
                }
                if (!eOperation.isUnique()) {
                    operation.setAttributeNS(null, "unique", "false");
                }
                if ((body = EcoreUtil.getAnnotation((EModelElement)eOperation, (String)GEN_MODEL_PACKAGE_NS_URI, (String)"body")) == null) continue;
                Element bodyElement = document.createElementNS(null, "body");
                bodyElement.appendChild(document.createTextNode(body));
                operation.appendChild(bodyElement);
            }
        }
        this.buildAnnotations(xsdComplexTypeDefinition, (EModelElement)eClass);
        return xsdComplexTypeDefinition;
    }

    protected void buildTypeParameters(XSDComponent xsdComponent, List<ETypeParameter> eTypeParameters) {
        if (!eTypeParameters.isEmpty()) {
            Element applicationInformation;
            XSDAnnotation xsdAnnotation;
            XSDSchema xsdSchema = xsdComponent.getSchema();
            if (xsdComponent instanceof XSDTypeDefinition) {
                xsdAnnotation = XSDFactory.eINSTANCE.createXSDAnnotation();
                ((XSDTypeDefinition)xsdComponent).setAnnotation(xsdAnnotation);
                applicationInformation = xsdAnnotation.createApplicationInformation("http://www.eclipse.org/emf/2002/Ecore");
                xsdAnnotation.getElement().appendChild(applicationInformation);
                this.createEcoreAnnotation(xsdSchema.getQNamePrefixToNamespaceMap(), applicationInformation, "key", "typeParameters");
            } else {
                xsdAnnotation = (XSDAnnotation)xsdComponent;
                applicationInformation = (Element)((Element)xsdAnnotation.getApplicationInformation().get(xsdAnnotation.getApplicationInformation().size() - 1)).getLastChild();
            }
            Document document = xsdSchema.getDocument();
            for (ETypeParameter eTypeParameter : eTypeParameters) {
                Element typeParameter = document.createElementNS(null, "typeParameter");
                typeParameter.setAttributeNS(null, "name", eTypeParameter.getName());
                applicationInformation.appendChild(typeParameter);
                this.buildAnnotation((EModelElement)eTypeParameter, typeParameter);
                EList eBounds = eTypeParameter.getEBounds();
                if (eBounds.isEmpty()) continue;
                StringBuilder stringBuilder = new StringBuilder();
                Iterator i = eBounds.iterator();
                while (i.hasNext()) {
                    String bound = this.getGenericType(xsdSchema, (EGenericType)i.next());
                    stringBuilder.append(bound);
                    if (!i.hasNext()) continue;
                    stringBuilder.append(' ');
                }
                typeParameter.setAttributeNS(null, "bounds", stringBuilder.toString());
            }
        }
    }

    protected XSDComponent buildContentFeature(XSDComplexTypeDefinition xsdComplexTypeDefinition, EStructuralFeature eStructuralFeature) {
        switch (this.extendedMetaData.getFeatureKind(eStructuralFeature)) {
            case 4: {
                XSDParticle xsdParticle = this.buildElementParticle(xsdComplexTypeDefinition, eStructuralFeature);
                return xsdParticle;
            }
            case 2: {
                XSDAttributeUse xsdAttributeUse = this.buildAttributeUse(xsdComplexTypeDefinition, eStructuralFeature);
                return xsdAttributeUse;
            }
            case 6: {
                XSDParticle xsdParticle = this.buildModelGroupParticle(xsdComplexTypeDefinition, eStructuralFeature);
                return xsdParticle;
            }
            case 5: {
                XSDWildcard xsdWildcard = this.buildElementWildcard(xsdComplexTypeDefinition, eStructuralFeature);
                return xsdWildcard;
            }
            case 3: {
                XSDWildcard xsdWildcard = this.buildAttributeWildcard(xsdComplexTypeDefinition, eStructuralFeature);
                return xsdWildcard;
            }
            case 1: {
                XSDSimpleTypeDefinition xsdSimpleTypeDefinition = this.buildSimpleContent(xsdComplexTypeDefinition, eStructuralFeature);
                return xsdSimpleTypeDefinition;
            }
        }
        if (eStructuralFeature instanceof EAttribute) {
            EAttribute eAttribute = (EAttribute)eStructuralFeature;
            if (eAttribute.isMany()) {
                return this.buildElementParticle(xsdComplexTypeDefinition, (EStructuralFeature)eAttribute);
            }
            return this.buildAttributeUse(xsdComplexTypeDefinition, (EStructuralFeature)eAttribute);
        }
        EReference eReference = (EReference)eStructuralFeature;
        if (eReference.isContainment()) {
            return this.buildElementParticle(xsdComplexTypeDefinition, (EStructuralFeature)eReference);
        }
        if (eReference.isContainer() && eReference.isTransient()) {
            return null;
        }
        return this.buildAttributeUse(xsdComplexTypeDefinition, (EStructuralFeature)eReference);
    }

    protected XSDParticle buildModelGroupParticle(XSDComplexTypeDefinition xsdComplexTypeDefinition, EStructuralFeature eStructuralFeature) {
        XSDModelGroup xsdModelGroup = this.findOrCreateModelGroup(xsdComplexTypeDefinition);
        XSDModelGroup modelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
        modelGroup.setCompositor(XSDCompositor.CHOICE_LITERAL);
        XSDParticle xsdParticle = XSDFactory.eINSTANCE.createXSDParticle();
        xsdParticle.setContent(modelGroup);
        if (eStructuralFeature.getUpperBound() != 1) {
            xsdParticle.setMaxOccurs(eStructuralFeature.getUpperBound());
        }
        xsdModelGroup.getContents().add((Object)xsdParticle);
        this.map(xsdParticle, (EModelElement)eStructuralFeature);
        this.createEcoreAnnotation(xsdParticle, "featureMap", eStructuralFeature.getName());
        this.buildAnnotations(xsdModelGroup, (EModelElement)eStructuralFeature);
        return xsdParticle;
    }

    protected XSDWildcard buildElementWildcard(XSDComplexTypeDefinition xsdComplexTypeDefinition, EStructuralFeature eStructuralFeature) {
        String name = this.extendedMetaData.getName(eStructuralFeature);
        if (":mixed".equals(name)) {
            xsdComplexTypeDefinition.setMixed(true);
            return null;
        }
        XSDWildcard xsdWildcard = XSDFactory.eINSTANCE.createXSDWildcard();
        xsdWildcard.setStringLexicalNamespaceConstraint(BasicExtendedMetaData.getEncodedWildcards((String)this.extendedMetaData.getNamespace((EClassifier)eStructuralFeature.getEContainingClass()), (List)this.extendedMetaData.getWildcards(eStructuralFeature)));
        XSDModelGroup xsdModelGroup = this.findOrCreateModelGroup(xsdComplexTypeDefinition);
        XSDParticle xsdParticle = XSDFactory.eINSTANCE.createXSDParticle();
        xsdParticle.setContent(xsdWildcard);
        xsdModelGroup.getContents().add((Object)xsdParticle);
        this.map(xsdParticle, (EModelElement)eStructuralFeature);
        if (eStructuralFeature.getLowerBound() != 1) {
            xsdParticle.setMinOccurs(eStructuralFeature.getLowerBound());
        }
        if (eStructuralFeature.getUpperBound() != 1) {
            xsdParticle.setMaxOccurs(eStructuralFeature.getUpperBound());
        }
        this.createEcoreAnnotation(xsdWildcard, "name", eStructuralFeature.getName());
        this.buildAnnotations(xsdWildcard, (EModelElement)eStructuralFeature);
        return xsdWildcard;
    }

    protected XSDWildcard buildAttributeWildcard(XSDComplexTypeDefinition xsdComplexTypeDefinition, EStructuralFeature eStructuralFeature) {
        XSDWildcard xsdWildcard = XSDFactory.eINSTANCE.createXSDWildcard();
        xsdWildcard.setStringLexicalNamespaceConstraint(BasicExtendedMetaData.getEncodedWildcards((String)this.extendedMetaData.getNamespace((EClassifier)eStructuralFeature.getEContainingClass()), (List)this.extendedMetaData.getWildcards(eStructuralFeature)));
        xsdComplexTypeDefinition.setAttributeWildcardContent(xsdWildcard);
        this.map(xsdWildcard, (EModelElement)eStructuralFeature);
        this.createEcoreAnnotation(xsdWildcard, "name", eStructuralFeature.getName());
        this.buildAnnotations(xsdWildcard, (EModelElement)eStructuralFeature);
        return xsdWildcard;
    }

    protected XSDSimpleTypeDefinition buildSimpleContent(XSDComplexTypeDefinition xsdComplexTypeDefinition, EStructuralFeature eStructuralFeature) {
        XSDSchema xsdSchema = xsdComplexTypeDefinition.getSchema();
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
        EClassifier eType = eStructuralFeature.getEType();
        EClassifier referenceType = null;
        if (eStructuralFeature instanceof EReference) {
            referenceType = eType;
            XSDSimpleTypeDefinition baseType = xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition(((EReference)eStructuralFeature).isResolveProxies() ? "anyURI" : "IDREF");
            this.handleMultiplicity(xsdSchema, eStructuralFeature, xsdSimpleTypeDefinition, baseType);
        } else {
            XSDSimpleTypeDefinition baseType = xsdComplexTypeDefinition.resolveSimpleTypeDefinitionURI(this.getURI(eType));
            this.handleImport(xsdSchema, baseType);
            this.handleMultiplicity(xsdSchema, eStructuralFeature, xsdSimpleTypeDefinition, baseType);
        }
        xsdComplexTypeDefinition.setBaseTypeDefinition(xsdSimpleTypeDefinition.getBaseType());
        xsdComplexTypeDefinition.setDerivationMethod(xsdSimpleTypeDefinition.getContents().isEmpty() ? XSDDerivationMethod.EXTENSION_LITERAL : XSDDerivationMethod.RESTRICTION_LITERAL);
        xsdComplexTypeDefinition.setContent(xsdSimpleTypeDefinition);
        this.map(xsdSimpleTypeDefinition, (EModelElement)eStructuralFeature);
        this.buildAttributeInformation(xsdComplexTypeDefinition, "value", false, referenceType, xsdSimpleTypeDefinition, eStructuralFeature);
        if (eStructuralFeature instanceof EAttribute && ((EAttribute)eStructuralFeature).isID() && !XSDConstants.isOrIsDerivedFromID(xsdSimpleTypeDefinition)) {
            this.createEcoreAnnotation(xsdSimpleTypeDefinition, "id", "true");
        }
        if (eStructuralFeature.eIsSet((EStructuralFeature)EcorePackage.Literals.ETYPED_ELEMENT__EGENERIC_TYPE)) {
            this.createEcoreAnnotation(xsdSimpleTypeDefinition, referenceType == null ? "type" : "reference", this.getGenericType(xsdSchema, eStructuralFeature.getEGenericType()));
        }
        return xsdSimpleTypeDefinition;
    }

    protected XSDAttributeUse buildAttributeUse(XSDComplexTypeDefinition xsdComplexTypeDefinition, EStructuralFeature eStructuralFeature) {
        boolean isRef;
        XSDSchema xsdSchema = xsdComplexTypeDefinition.getSchema();
        String namespace = this.extendedMetaData.getNamespace(eStructuralFeature);
        String name = this.extendedMetaData.getName(eStructuralFeature);
        String typeNamespace = this.extendedMetaData.getNamespace((EClassifier)eStructuralFeature.getEContainingClass());
        boolean bl = isRef = namespace != null && !namespace.equals(typeNamespace);
        if (namespace == null ? typeNamespace == null : namespace.equals(typeNamespace)) {
            EStructuralFeature globalFeature = this.extendedMetaData.getAttribute(namespace, name);
            isRef = globalFeature != null && EcoreUtil.equals((EObject)globalFeature.getEGenericType(), (EObject)eStructuralFeature.getEGenericType());
        }
        XSDAttributeUse xsdAttributeUse = XSDFactory.eINSTANCE.createXSDAttributeUse();
        XSDAttributeDeclaration xsdAttributeDeclaration = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
        EClassifier referenceType = null;
        if (isRef) {
            XSDAttributeDeclaration referencedXSDAttributeDeclaration = xsdComplexTypeDefinition.resolveAttributeDeclaration(namespace, name);
            this.handleImport(xsdSchema, referencedXSDAttributeDeclaration);
            xsdAttributeDeclaration.setResolvedAttributeDeclaration(referencedXSDAttributeDeclaration);
        } else {
            xsdAttributeDeclaration.setName(name);
            if (namespace != null) {
                xsdAttributeDeclaration.setForm(XSDForm.QUALIFIED_LITERAL);
            }
            EClassifier eType = eStructuralFeature.getEType();
            if (eStructuralFeature instanceof EReference) {
                referenceType = eType;
                XSDSimpleTypeDefinition xsdSimpleTypeDefinition = xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition(((EReference)eStructuralFeature).isResolveProxies() ? "anyURI" : "IDREF");
                this.handleMultiplicity(xsdSchema, eStructuralFeature, xsdAttributeDeclaration, xsdSimpleTypeDefinition);
            } else {
                XSDSimpleTypeDefinition xsdSimpleTypeDefinition = xsdComplexTypeDefinition.resolveSimpleTypeDefinitionURI(this.getURI(eType));
                this.handleImport(xsdSchema, xsdSimpleTypeDefinition);
                this.handleMultiplicity(xsdSchema, eStructuralFeature, xsdAttributeDeclaration, xsdSimpleTypeDefinition);
            }
        }
        xsdAttributeUse.setContent(xsdAttributeDeclaration);
        xsdComplexTypeDefinition.getAttributeContents().add((Object)xsdAttributeUse);
        this.map(xsdAttributeUse, (EModelElement)eStructuralFeature);
        this.buildAttributeInformation(xsdComplexTypeDefinition, name, isRef, referenceType, xsdAttributeUse, eStructuralFeature);
        if (eStructuralFeature instanceof EAttribute && ((EAttribute)eStructuralFeature).isID() && !XSDConstants.isOrIsDerivedFromID(xsdAttributeDeclaration.getTypeDefinition())) {
            this.createEcoreAnnotation(xsdAttributeUse, "id", "true");
        }
        if (eStructuralFeature.eIsSet((EStructuralFeature)EcorePackage.Literals.ETYPED_ELEMENT__EGENERIC_TYPE)) {
            this.createEcoreAnnotation(xsdAttributeUse, referenceType == null ? "type" : "reference", this.getGenericType(xsdSchema, eStructuralFeature.getEGenericType()));
        }
        return xsdAttributeUse;
    }

    protected void buildAttributeInformation(XSDComplexTypeDefinition xsdComplexTypeDefinition, String name, boolean isRef, EClassifier referenceType, XSDComponent xsdComponent, EStructuralFeature eStructuralFeature) {
        String ecoreName;
        String defaultValue;
        boolean canHaveDefault;
        List eKeys = null;
        if (referenceType == null && eStructuralFeature.isMany()) {
            this.createEcoreAnnotation(xsdComponent, "many", "true");
        }
        if (eStructuralFeature instanceof EReference) {
            EReference eReference = (EReference)eStructuralFeature;
            EReference eOpposite = eReference.getEOpposite();
            if (eOpposite != null) {
                this.createEcoreAnnotation(xsdComponent, "opposite", eOpposite.getName());
            }
            eKeys = eReference.getEKeys();
        }
        if (eKeys != null && !eKeys.isEmpty()) {
            StringBuilder keys = new StringBuilder();
            for (EAttribute eKey : eKeys) {
                keys.append(eKey.getName());
                keys.append(' ');
            }
            this.createEcoreAnnotation(xsdComponent, "keys", keys.toString().trim());
        }
        XSDAttributeUse xsdAttriuteUse = xsdComponent instanceof XSDAttributeUse ? (XSDAttributeUse)xsdComponent : null;
        boolean bl = canHaveDefault = xsdAttriuteUse != null;
        if (eStructuralFeature.isRequired()) {
            if (eStructuralFeature.isTransient() || xsdAttriuteUse == null) {
                this.createEcoreAnnotation(xsdComponent, "lowerBound", Integer.toString(eStructuralFeature.getLowerBound()));
            } else {
                xsdAttriuteUse.setUse(XSDAttributeUseCategory.REQUIRED_LITERAL);
                canHaveDefault = false;
            }
        }
        if ((defaultValue = eStructuralFeature.getDefaultValueLiteral()) != null) {
            if (canHaveDefault && xsdAttriuteUse != null) {
                if (isRef) {
                    xsdAttriuteUse.setConstraint(XSDConstraint.DEFAULT_LITERAL);
                    xsdAttriuteUse.setLexicalValue(this.transformDefaultValue(xsdAttriuteUse.getAttributeDeclaration().getTypeDefinition(), defaultValue));
                } else {
                    XSDAttributeDeclaration xsdAttributeDeclaration = xsdAttriuteUse.getAttributeDeclaration();
                    xsdAttributeDeclaration.setConstraint(XSDConstraint.DEFAULT_LITERAL);
                    xsdAttributeDeclaration.setLexicalValue(this.transformDefaultValue(xsdAttributeDeclaration.getTypeDefinition(), defaultValue));
                }
            } else {
                this.createEcoreAnnotation(xsdComponent, "default", defaultValue);
            }
        }
        if (eStructuralFeature.isMany()) {
            if (eStructuralFeature.isUnsettable()) {
                this.createEcoreAnnotation(xsdComponent, "unsettable", "true");
            }
        } else if ((eStructuralFeature.getEType().getDefaultValue() != null || eStructuralFeature.getDefaultValueLiteral() != null) != eStructuralFeature.isUnsettable()) {
            this.createEcoreAnnotation(xsdComponent, "unsettable", Boolean.toString(eStructuralFeature.isUnsettable()));
        }
        if (!name.equals(ecoreName = eStructuralFeature.getName()) || Character.isUpperCase(ecoreName.charAt(0)) || ecoreName.indexOf(95) != -1) {
            this.createEcoreAnnotation(xsdComponent, "name", ecoreName);
        }
        if (eStructuralFeature.isMany() && !eStructuralFeature.isOrdered()) {
            this.createEcoreAnnotation(xsdComponent, "ordered", "false");
        }
        if (eStructuralFeature.isMany() && eStructuralFeature.isUnique() && eStructuralFeature instanceof EAttribute) {
            this.createEcoreAnnotation(xsdComponent, "unique", "true");
        }
        if (!eStructuralFeature.isChangeable()) {
            this.createEcoreAnnotation(xsdComponent, "changeable", "false");
        }
        if (this.extendedMetaData.getGroup(eStructuralFeature) == null) {
            if (eStructuralFeature.isDerived()) {
                this.createEcoreAnnotation(xsdComponent, "derived", "true");
            }
            if (eStructuralFeature.isTransient()) {
                this.createEcoreAnnotation(xsdComponent, "transient", "true");
            }
            if (eStructuralFeature.isVolatile()) {
                this.createEcoreAnnotation(xsdComponent, "volatile", "true");
            }
        }
        if (referenceType != null) {
            XSDTypeDefinition xsdTypeDefinition = xsdComplexTypeDefinition.resolveTypeDefinitionURI(this.getURI(referenceType));
            this.handleImport(xsdComplexTypeDefinition.getSchema(), xsdTypeDefinition);
            String prefix = this.handlePrefix(xsdComplexTypeDefinition.getSchema().getQNamePrefixToNamespaceMap(), referenceType.getEPackage().getNsPrefix(), xsdTypeDefinition.getTargetNamespace());
            this.createEcoreAnnotation(xsdComponent, "reference", String.valueOf(prefix) + ":" + xsdTypeDefinition.getName());
        }
        if (EcoreUtil.isSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)0)) {
            this.createEcoreAnnotation(xsdComponent, "suppressedGetVisibility", "true");
        }
        if (EcoreUtil.isSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)1)) {
            this.createEcoreAnnotation(xsdComponent, "suppressedSetVisibility", "true");
        }
        if (EcoreUtil.isSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)2)) {
            this.createEcoreAnnotation(xsdComponent, "suppressedIsSetVisibility", "true");
        }
        if (EcoreUtil.isSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)3)) {
            this.createEcoreAnnotation(xsdComponent, "suppressedUnsetVisibility", "true");
        }
        this.buildAnnotations(xsdComponent, (EModelElement)eStructuralFeature);
    }

    protected void handleMultiplicity(XSDSchema xsdSchema, EStructuralFeature eStructuralFeature, XSDAttributeDeclaration xsdAttributeDeclaration, XSDSimpleTypeDefinition xsdSimpleTypeDefinition) {
        this.handleMultiplicity(xsdSchema, eStructuralFeature, (XSDComponent)xsdAttributeDeclaration, xsdSimpleTypeDefinition);
    }

    protected void handleMultiplicity(XSDSchema xsdSchema, EStructuralFeature eStructuralFeature, XSDComponent xsdComponent, XSDSimpleTypeDefinition xsdSimpleTypeDefinition) {
        if (eStructuralFeature.isMany()) {
            XSDSimpleTypeDefinition xsdListTypeDefinition;
            if (xsdSimpleTypeDefinition.hasNameAndTargetNamespace("IDREF", this.defaultXMLSchemaNamespace)) {
                xsdListTypeDefinition = xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("IDREFS");
            } else {
                xsdListTypeDefinition = XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
                xsdListTypeDefinition.setItemTypeDefinition(xsdSimpleTypeDefinition);
            }
            if (eStructuralFeature.getLowerBound() > 1 || eStructuralFeature.getUpperBound() > 1) {
                XSDSimpleTypeDefinition xsdRestrictedTypeDefinition = XSDFactory.eINSTANCE.createXSDSimpleTypeDefinition();
                if (xsdListTypeDefinition.getContainer() == null) {
                    xsdRestrictedTypeDefinition.getContents().add((Object)xsdListTypeDefinition);
                } else {
                    xsdRestrictedTypeDefinition.setBaseTypeDefinition(xsdListTypeDefinition);
                }
                if (eStructuralFeature.getLowerBound() == eStructuralFeature.getUpperBound()) {
                    XSDLengthFacet xsdLengthFacet = XSDFactory.eINSTANCE.createXSDLengthFacet();
                    xsdLengthFacet.setLexicalValue(Integer.toString(eStructuralFeature.getLowerBound()));
                    xsdRestrictedTypeDefinition.getFacetContents().add((Object)xsdLengthFacet);
                } else {
                    if (eStructuralFeature.getLowerBound() > 1) {
                        XSDMinLengthFacet xsdMinLengthFacet = XSDFactory.eINSTANCE.createXSDMinLengthFacet();
                        xsdMinLengthFacet.setLexicalValue(Integer.toString(eStructuralFeature.getLowerBound()));
                        xsdRestrictedTypeDefinition.getFacetContents().add((Object)xsdMinLengthFacet);
                    }
                    if (eStructuralFeature.getUpperBound() > 1) {
                        XSDMaxLengthFacet xsdMaxLengthFacet = XSDFactory.eINSTANCE.createXSDMaxLengthFacet();
                        xsdMaxLengthFacet.setLexicalValue(Integer.toString(eStructuralFeature.getUpperBound()));
                        xsdRestrictedTypeDefinition.getFacetContents().add((Object)xsdMaxLengthFacet);
                    }
                }
                if (xsdComponent instanceof XSDAttributeDeclaration) {
                    ((XSDAttributeDeclaration)xsdComponent).setAnonymousTypeDefinition(xsdRestrictedTypeDefinition);
                } else {
                    ((XSDSimpleTypeDefinition)xsdComponent).getContents().add((Object)xsdRestrictedTypeDefinition);
                }
            } else if (xsdListTypeDefinition.getContainer() == null) {
                if (xsdComponent instanceof XSDAttributeDeclaration) {
                    ((XSDAttributeDeclaration)xsdComponent).setAnonymousTypeDefinition(xsdListTypeDefinition);
                } else {
                    ((XSDSimpleTypeDefinition)xsdComponent).getContents().add((Object)xsdListTypeDefinition);
                }
            } else if (xsdComponent instanceof XSDAttributeDeclaration) {
                ((XSDAttributeDeclaration)xsdComponent).setTypeDefinition(xsdListTypeDefinition);
            } else {
                ((XSDSimpleTypeDefinition)xsdComponent).setBaseTypeDefinition(xsdListTypeDefinition);
            }
        } else if (xsdComponent instanceof XSDAttributeDeclaration) {
            ((XSDAttributeDeclaration)xsdComponent).setTypeDefinition(xsdSimpleTypeDefinition);
        } else {
            ((XSDSimpleTypeDefinition)xsdComponent).setBaseTypeDefinition(xsdSimpleTypeDefinition);
        }
    }

    protected XSDParticle buildElementParticle(XSDComplexTypeDefinition xsdComplexTypeDefinition, EStructuralFeature eStructuralFeature) {
        String ecoreName;
        XSDParticle xsdParticle;
        boolean isRef;
        String namespace = this.extendedMetaData.getNamespace(eStructuralFeature);
        String name = this.extendedMetaData.getName(eStructuralFeature);
        String typeNamespace = this.extendedMetaData.getNamespace((EClassifier)eStructuralFeature.getEContainingClass());
        boolean bl = isRef = namespace != null && !namespace.equals(typeNamespace);
        if (namespace == null ? typeNamespace == null : namespace.equals(typeNamespace)) {
            EStructuralFeature globalFeature = this.extendedMetaData.getElement(namespace, name);
            isRef = globalFeature != null && EcoreUtil.equals((EObject)globalFeature.getEGenericType(), (EObject)eStructuralFeature.getEGenericType());
        }
        XSDModelGroup xsdModelGroup = this.findOrCreateModelGroup(xsdComplexTypeDefinition);
        EStructuralFeature group = this.extendedMetaData.getGroup(eStructuralFeature);
        if (group != null && (xsdParticle = (XSDParticle)this.eModelElementToXSDComponentMap.get(group)) != null) {
            xsdModelGroup = (XSDModelGroup)xsdParticle.getContent();
        }
        XSDElementDeclaration xsdElementDeclaration = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        EClassifier referenceType = null;
        EReference eOpposite = null;
        EList eKeys = null;
        EClassifier eType = eStructuralFeature.getEType();
        if (isRef) {
            XSDElementDeclaration referencedXSDElementDeclaration = xsdComplexTypeDefinition.resolveElementDeclaration(namespace, name);
            this.handleImport(xsdComplexTypeDefinition.getSchema(), referencedXSDElementDeclaration);
            xsdElementDeclaration.setResolvedElementDeclaration(referencedXSDElementDeclaration);
            if (eStructuralFeature instanceof EReference) {
                EReference eReference = (EReference)eStructuralFeature;
                eOpposite = eReference.getEOpposite();
                eKeys = eReference.getEKeys();
            }
        } else {
            xsdElementDeclaration.setName(name);
            if (namespace != null) {
                xsdElementDeclaration.setForm(XSDForm.QUALIFIED_LITERAL);
            }
            XSDTypeDefinition xsdTypeDefinition = xsdComplexTypeDefinition.resolveTypeDefinitionURI(this.getURI(eType));
            String defaultValue = eStructuralFeature.getDefaultValueLiteral();
            if (defaultValue != null) {
                xsdElementDeclaration.setConstraint(XSDConstraint.DEFAULT_LITERAL);
                xsdElementDeclaration.setLexicalValue(this.transformDefaultValue((XSDSimpleTypeDefinition)xsdTypeDefinition, defaultValue));
            }
            if (eStructuralFeature instanceof EReference) {
                EReference eReference = (EReference)eStructuralFeature;
                eOpposite = eReference.getEOpposite();
                eKeys = eReference.getEKeys();
                if (!eReference.isContainment() && !eReference.isContainer()) {
                    referenceType = eType;
                    xsdTypeDefinition = xsdComplexTypeDefinition.getSchema().getSchemaForSchema().resolveTypeDefinition(eReference.isResolveProxies() ? "anyURI" : "IDREF");
                }
            }
            this.handleImport(xsdComplexTypeDefinition.getSchema(), xsdTypeDefinition);
            xsdElementDeclaration.setTypeDefinition(xsdTypeDefinition);
            if (this.isWrapperType(eType) || eStructuralFeature instanceof EAttribute && eType.getDefaultValue() == null && (eStructuralFeature.isMany() || !eStructuralFeature.isRequired() && (eStructuralFeature.getDefaultValueLiteral() != null || eStructuralFeature.isUnsettable()))) {
                xsdElementDeclaration.setNillable(true);
            }
        }
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        xsdParticle2.setContent(xsdElementDeclaration);
        xsdModelGroup.getContents().add((Object)xsdParticle2);
        this.map(xsdParticle2, (EModelElement)eStructuralFeature);
        if (eStructuralFeature.isMany()) {
            if (eStructuralFeature.isUnsettable()) {
                this.createEcoreAnnotation(xsdParticle2, "unsettable", "true");
            }
        } else if (xsdElementDeclaration.isNillable() ? !eStructuralFeature.isUnsettable() : (eType.getDefaultValue() != null || eStructuralFeature.getDefaultValueLiteral() != null) != eStructuralFeature.isUnsettable()) {
            this.createEcoreAnnotation(xsdParticle2, "unsettable", Boolean.toString(eStructuralFeature.isUnsettable()));
        }
        if (eOpposite != null) {
            this.createEcoreAnnotation(xsdParticle2, "opposite", eOpposite.getName());
        }
        if (eKeys != null && !eKeys.isEmpty()) {
            StringBuilder keys = new StringBuilder();
            for (EAttribute eKey : eKeys) {
                keys.append(eKey.getName());
                keys.append(' ');
            }
            this.createEcoreAnnotation(xsdParticle2, "keys", keys.toString().trim());
        }
        if (group == null) {
            if (eStructuralFeature.isTransient() && !xsdComplexTypeDefinition.isMixed()) {
                xsdParticle2.setMinOccurs(0);
                if (eStructuralFeature.getLowerBound() != 0) {
                    this.createEcoreAnnotation(xsdParticle2, "lowerBound", Integer.toString(eStructuralFeature.getLowerBound()));
                }
            } else if (eStructuralFeature.getLowerBound() != 1) {
                xsdParticle2.setMinOccurs(eStructuralFeature.getLowerBound());
            }
            if (eStructuralFeature.getUpperBound() != 1) {
                xsdParticle2.setMaxOccurs(eStructuralFeature.getUpperBound());
            }
        } else {
            if (eStructuralFeature.isTransient() && !xsdComplexTypeDefinition.isMixed()) {
                xsdParticle2.setMinOccurs(0);
                if (eStructuralFeature.getLowerBound() != 0) {
                    this.createEcoreAnnotation(xsdParticle2, "lowerBound", Integer.toString(eStructuralFeature.getLowerBound()));
                }
            } else if (eStructuralFeature.getLowerBound() != 1) {
                this.createEcoreAnnotation(xsdParticle2, "lowerBound", Integer.toString(eStructuralFeature.getLowerBound()));
            }
            if (eStructuralFeature.getUpperBound() != 1) {
                this.createEcoreAnnotation(xsdParticle2, "upperBound", Integer.toString(eStructuralFeature.getUpperBound()));
            }
        }
        if (!name.equals(ecoreName = eStructuralFeature.getName()) || Character.isUpperCase(ecoreName.charAt(0)) || ecoreName.indexOf(95) != -1) {
            this.createEcoreAnnotation(xsdParticle2, "name", ecoreName);
        }
        if (eStructuralFeature.isMany() && !eStructuralFeature.isOrdered()) {
            this.createEcoreAnnotation(xsdParticle2, "ordered", "false");
        }
        if (eStructuralFeature.isMany() && eStructuralFeature.isUnique() && eStructuralFeature instanceof EAttribute) {
            this.createEcoreAnnotation(xsdParticle2, "unique", "true");
        }
        if (!eStructuralFeature.isChangeable()) {
            this.createEcoreAnnotation(xsdParticle2, "changeable", "false");
        }
        if (this.extendedMetaData.getContentKind(eStructuralFeature.getEContainingClass()) != 3 && this.extendedMetaData.getGroup(eStructuralFeature) == null) {
            if (eStructuralFeature.isDerived()) {
                this.createEcoreAnnotation(xsdParticle2, "derived", "true");
            }
            if (eStructuralFeature.isTransient()) {
                this.createEcoreAnnotation(xsdParticle2, "transient", "true");
            }
            if (eStructuralFeature.isVolatile()) {
                this.createEcoreAnnotation(xsdParticle2, "volatile", "true");
            }
        }
        if (eStructuralFeature instanceof EReference && ((EReference)eStructuralFeature).isResolveProxies() && ((EReference)eStructuralFeature).isContainment()) {
            this.createEcoreAnnotation(xsdParticle2, "resolveProxies", "true");
        }
        if (eStructuralFeature.eIsSet((EStructuralFeature)EcorePackage.Literals.ETYPED_ELEMENT__EGENERIC_TYPE)) {
            this.createEcoreAnnotation(xsdParticle2, referenceType == null ? "type" : "reference", this.getGenericType(xsdComplexTypeDefinition.getSchema(), eStructuralFeature.getEGenericType()));
        } else if (referenceType != null) {
            XSDTypeDefinition xsdTypeDefinition = xsdComplexTypeDefinition.resolveTypeDefinitionURI(this.getURI(referenceType));
            this.handleImport(xsdComplexTypeDefinition.getSchema(), xsdTypeDefinition);
            String prefix = this.handlePrefix(xsdComplexTypeDefinition.getSchema().getQNamePrefixToNamespaceMap(), referenceType.getEPackage().getNsPrefix(), xsdTypeDefinition.getTargetNamespace());
            this.createEcoreAnnotation(xsdElementDeclaration, "reference", String.valueOf(prefix) + ":" + xsdTypeDefinition.getName());
        }
        if (EcoreUtil.isSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)0)) {
            this.createEcoreAnnotation(xsdElementDeclaration, "suppressedGetVisibility", "true");
        }
        if (EcoreUtil.isSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)1)) {
            this.createEcoreAnnotation(xsdElementDeclaration, "suppressedSetVisibility", "true");
        }
        if (EcoreUtil.isSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)2)) {
            this.createEcoreAnnotation(xsdElementDeclaration, "suppressedIsSetVisibility", "true");
        }
        if (EcoreUtil.isSuppressedVisibility((EStructuralFeature)eStructuralFeature, (int)3)) {
            this.createEcoreAnnotation(xsdElementDeclaration, "suppressedUnsetVisibility", "true");
        }
        if (eStructuralFeature instanceof EAttribute && ((EAttribute)eStructuralFeature).isID() && xsdElementDeclaration.getTypeDefinition() instanceof XSDSimpleTypeDefinition && !XSDConstants.isOrIsDerivedFromID((XSDSimpleTypeDefinition)xsdElementDeclaration.getTypeDefinition())) {
            this.createEcoreAnnotation(xsdParticle2, "id", "true");
        }
        this.buildAnnotations(xsdParticle2, (EModelElement)eStructuralFeature);
        return xsdParticle2;
    }

    protected XSDModelGroup findOrCreateModelGroup(XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        if (xsdComplexTypeDefinition.getContent() == null) {
            return this.buildModelGroup(xsdComplexTypeDefinition);
        }
        XSDParticle xsdParticle = (XSDParticle)xsdComplexTypeDefinition.getContent();
        return (XSDModelGroup)xsdParticle.getContent();
    }

    protected XSDModelGroup buildModelGroup(XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        XSDModelGroup xsdModelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        XSDParticle xsdParticle = XSDFactory.eINSTANCE.createXSDParticle();
        xsdParticle.setContent(xsdModelGroup);
        xsdComplexTypeDefinition.setContent(xsdParticle);
        return xsdModelGroup;
    }

    protected boolean isWrapperType(EClassifier eClassifier) {
        String name = this.extendedMetaData.getName(eClassifier);
        return name.endsWith(":Object") && !"http://www.eclipse.org/emf/2002/Ecore".equals(this.extendedMetaData.getNamespace(eClassifier));
    }

    protected String getURI(EClassifier eClassifier) {
        String namespace = this.extendedMetaData.getNamespace(eClassifier);
        String name = this.extendedMetaData.getName(eClassifier);
        if ("http://www.eclipse.org/emf/2003/XMLType".equals(namespace)) {
            namespace = this.defaultXMLSchemaNamespace;
            if (name.endsWith(":Object")) {
                name = name.substring(0, name.length() - 7);
            }
        } else if ("http://www.eclipse.org/emf/2002/Ecore".equals(namespace)) {
            if ("EObject".equals(name)) {
                namespace = this.defaultXMLSchemaNamespace;
                name = "anyType";
            } else if (name.endsWith(":Object")) {
                name = eClassifier.getName();
            }
        } else if (name.endsWith(":Object")) {
            name = name.substring(0, name.length() - 7);
        }
        String result = namespace == null ? name : String.valueOf(namespace) + "#" + name;
        return result;
    }

    protected String getURI(EStructuralFeature eStructuralFeature) {
        String namespace = this.extendedMetaData.getNamespace(eStructuralFeature);
        String name = this.extendedMetaData.getName(eStructuralFeature);
        if ("http://www.eclipse.org/emf/2003/XMLType".equals(namespace)) {
            namespace = this.defaultXMLSchemaNamespace;
        }
        String result = namespace == null ? name : String.valueOf(namespace) + "#" + name;
        return result;
    }

    protected String getGenericType(XSDSchema xsdSchema, EGenericType eGenericType) {
        Map<String, String> qNamePrefixToNamespaceMap = xsdSchema.getQNamePrefixToNamespaceMap();
        StringBuilder result = new StringBuilder();
        EClassifier eClassifier = eGenericType.getEClassifier();
        if (eClassifier != null) {
            XSDTypeDefinition type = xsdSchema.resolveTypeDefinitionURI(this.getURI(eClassifier));
            this.handleImport(xsdSchema, type);
            String prefix = this.handlePrefix(qNamePrefixToNamespaceMap, eClassifier.getEPackage().getNsPrefix(), type.getTargetNamespace());
            result.append(prefix);
            result.append(':');
            result.append(type.getName());
            EList eTypeArguments = eGenericType.getETypeArguments();
            if (!eTypeArguments.isEmpty()) {
                result.append('{');
                Iterator i = eTypeArguments.iterator();
                while (i.hasNext()) {
                    result.append(this.getGenericType(xsdSchema, (EGenericType)i.next()));
                    if (!i.hasNext()) continue;
                    result.append(", ");
                }
                result.append('}');
            }
        } else {
            ETypeParameter eTypeParameter = eGenericType.getETypeParameter();
            if (eTypeParameter != null) {
                result.append(eTypeParameter.getName());
            } else {
                result.append('?');
                EGenericType eUpperBound = eGenericType.getEUpperBound();
                if (eUpperBound != null) {
                    result.append(" extends ");
                    result.append(this.getGenericType(xsdSchema, eUpperBound));
                } else {
                    EGenericType eLowerBound = eGenericType.getELowerBound();
                    if (eLowerBound != null) {
                        result.append(" super ");
                        result.append(this.getGenericType(xsdSchema, eLowerBound));
                    }
                }
            }
        }
        return result.toString();
    }

    protected void createEcoreAnnotation(XSDComponent xsdComponent, String key, String value) {
        Element element = xsdComponent.getElement();
        if (element != null) {
            this.createEcoreAnnotation(xsdComponent.getSchema().getQNamePrefixToNamespaceMap(), element, key, value);
        }
    }

    protected void createEcoreAnnotation(Map<String, String> qNamePrefixToNamespaceMap, Element element, String key, String value) {
        String ecorePrefix = this.handlePrefix(qNamePrefixToNamespaceMap, "ecore", "http://www.eclipse.org/emf/2002/Ecore");
        element.setAttributeNS("http://www.eclipse.org/emf/2002/Ecore", String.valueOf(ecorePrefix) + ':' + key, value);
    }

    protected void createAnnotation(XSDComponent xsdComponent, String namespace, String key, String value) {
        Element element = xsdComponent.getElement();
        if (element != null) {
            this.createAnnotation(xsdComponent.getSchema().getQNamePrefixToNamespaceMap(), element, namespace, key, value);
        }
    }

    protected void createAnnotation(Map<String, String> qNamePrefixToNamespaceMap, Element element, String namespace, String key, String value) {
        String prefix = this.handlePrefix(qNamePrefixToNamespaceMap, this.qualifiedPackageName(namespace), namespace);
        element.setAttributeNS(namespace, String.valueOf(prefix) + ':' + key, value);
    }

    protected void handleImport(XSDSchema xsdSchema, XSDNamedComponent xsdNamedComponent) {
        String namespace = xsdNamedComponent.getTargetNamespace();
        if (!this.defaultXMLSchemaNamespace.equals(namespace) && (namespace == null ? xsdSchema.getTargetNamespace() != null : !namespace.equals(xsdSchema.getTargetNamespace()))) {
            for (Object content : xsdSchema.getContents()) {
                if (content instanceof XSDImport) {
                    XSDImport xsdImport = (XSDImport)content;
                    if (!(namespace == null ? xsdImport.getNamespace() == null : namespace.equals(xsdImport.getNamespace()))) continue;
                    return;
                }
                if (!(content instanceof XSDAnnotation)) break;
            }
            XSDImport xsdImport = XSDFactory.eINSTANCE.createXSDImport();
            xsdImport.setNamespace(namespace);
            EPackage ePackage = this.extendedMetaData.getPackage(namespace);
            if (ePackage != null) {
                this.handlePrefix(xsdSchema.getQNamePrefixToNamespaceMap(), ePackage.getNsPrefix(), namespace);
                xsdImport.setSchemaLocation(ePackage.getNsURI());
            }
            xsdSchema.getContents().add(0, (Object)xsdImport);
        }
    }

    protected String handlePrefix(Map<String, String> namespaces, String preferredPrefix, String namespace) {
        if ("http://www.w3.org/XML/1998/namespace".equals(namespace)) {
            return "xml";
        }
        String value = namespaces.get(preferredPrefix);
        if (namespace == null ? value == null : namespace.equals(value)) {
            return preferredPrefix;
        }
        if (value != null || this.defaultXMLSchemaNamespace.equals(namespace)) {
            for (Map.Entry<String, String> entry : namespaces.entrySet()) {
                if (!(namespace == null ? entry.getValue() == null : namespace.equals(entry.getValue()))) continue;
                return entry.getKey();
            }
        }
        String uniquePrefix = preferredPrefix;
        int i = 0;
        while (namespaces.containsKey(uniquePrefix)) {
            uniquePrefix = String.valueOf(preferredPrefix) + "_" + i;
            ++i;
        }
        namespaces.put("".equals(uniquePrefix) ? null : uniquePrefix, namespace);
        return uniquePrefix;
    }

    protected boolean isIgnoredAnnotationSource(String sourceURI) {
        return "http://www.eclipse.org/emf/2002/Ecore".equals(sourceURI) || "http:///org/eclipse/emf/ecore/util/ExtendedMetaData".equals(sourceURI) || GEN_MODEL_PACKAGE_NS_URI.equals(sourceURI);
    }

    protected void buildAnnotations(XSDComponent xsdComponent, EModelElement eModelElement) {
        XSDAnnotation xsdAnnotation;
        for (EAnnotation eAnnotation : eModelElement.getEAnnotations()) {
            String source = eAnnotation.getSource();
            if (this.isIgnoredAnnotationSource(source)) continue;
            XSDAnnotation xsdAnnotation2 = null;
            for (Map.Entry entry : eAnnotation.getDetails().entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (key != null && value.indexOf(10) == -1 && value.indexOf(13) == -1) {
                    this.createAnnotation(xsdComponent, source, key, value);
                    continue;
                }
                if (xsdAnnotation2 == null) {
                    xsdAnnotation2 = this.buildAnnotation(xsdComponent, eModelElement);
                }
                if (xsdAnnotation2 == null) continue;
                Element applicationInformation = xsdAnnotation2.createApplicationInformation(source);
                if (key != null) {
                    this.createEcoreAnnotation(xsdComponent.getSchema().getQNamePrefixToNamespaceMap(), applicationInformation, "key", key);
                }
                if (value != null) {
                    applicationInformation.appendChild(xsdAnnotation2.getSchema().getDocument().createTextNode(value));
                }
                xsdAnnotation2.getElement().appendChild(applicationInformation);
            }
        }
        String documentation = EcoreUtil.getDocumentation((EModelElement)eModelElement);
        if (documentation != null && (xsdAnnotation = this.buildAnnotation(xsdComponent, eModelElement)) != null) {
            this.createUserInfo(xsdAnnotation, documentation);
        }
    }

    protected XSDAnnotation buildAnnotation(XSDConcreteComponent xsdComponent, EModelElement eModelElement) {
        XSDAttributeDeclaration xsdAttributeDeclaration;
        XSDAnnotation xsdAnnotation = null;
        if (xsdComponent instanceof XSDAttributeUse) {
            xsdComponent = ((XSDAttributeUse)xsdComponent).getContent();
        } else if (xsdComponent instanceof XSDParticle) {
            xsdComponent = ((XSDParticle)xsdComponent).getContent();
        }
        if (xsdComponent instanceof XSDSchema) {
            xsdAnnotation = XSDFactory.eINSTANCE.createXSDAnnotation();
            ((XSDSchema)xsdComponent).getContents().add(0, (Object)xsdAnnotation);
        } else if (xsdComponent instanceof XSDTypeDefinition) {
            XSDTypeDefinition xsdTypeDefinition = (XSDTypeDefinition)xsdComponent;
            xsdAnnotation = xsdTypeDefinition.getAnnotation();
            if (xsdAnnotation == null) {
                xsdAnnotation = XSDFactory.eINSTANCE.createXSDAnnotation();
                xsdTypeDefinition.setAnnotation(xsdAnnotation);
            }
        } else if (xsdComponent instanceof XSDFacet) {
            XSDFacet xsdFacet = (XSDFacet)xsdComponent;
            xsdAnnotation = xsdFacet.getAnnotation();
            if (xsdAnnotation == null) {
                xsdAnnotation = XSDFactory.eINSTANCE.createXSDAnnotation();
                xsdFacet.setAnnotation(xsdAnnotation);
            }
        } else if (xsdComponent instanceof XSDElementDeclaration) {
            XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)xsdComponent;
            xsdAnnotation = xsdElementDeclaration.getAnnotation();
            if (xsdAnnotation == null) {
                xsdAnnotation = XSDFactory.eINSTANCE.createXSDAnnotation();
                xsdElementDeclaration.setAnnotation(xsdAnnotation);
            }
        } else if (xsdComponent instanceof XSDAttributeDeclaration && (xsdAnnotation = (xsdAttributeDeclaration = (XSDAttributeDeclaration)xsdComponent).getAnnotation()) == null) {
            xsdAnnotation = XSDFactory.eINSTANCE.createXSDAnnotation();
            xsdAttributeDeclaration.setAnnotation(xsdAnnotation);
        }
        return xsdAnnotation;
    }

    protected void createUserInfo(XSDAnnotation xsdAnnotation, String documentation) {
        Element userInformation = xsdAnnotation.createUserInformation(null);
        XSDParser xsdParser = new XSDParser(null);
        xsdParser.parseString("<documentation>" + documentation + "</documentation>");
        Document document = xsdParser.getDocument();
        if (xsdParser.getDiagnostics().isEmpty() && document.getDocumentElement().getFirstChild() != null) {
            Document xsdDocument = xsdAnnotation.getSchema().getDocument();
            Node node = document.getDocumentElement().getFirstChild();
            while (node != null) {
                userInformation.appendChild(xsdDocument.importNode(node, true));
                node = node.getNextSibling();
            }
        } else {
            userInformation.appendChild(xsdAnnotation.getSchema().getDocument().createTextNode(documentation));
        }
        xsdAnnotation.getElement().appendChild(userInformation);
    }

    protected void buildAnnotation(EModelElement eModelElement, Element parent) {
        Document document = parent.getOwnerDocument();
        for (EAnnotation eAnnotation : eModelElement.getEAnnotations()) {
            String documentation;
            String source = eAnnotation.getSource();
            if (!this.isIgnoredAnnotationSource(source)) {
                Element annotation = document.createElementNS(null, "annotation");
                if (source != null) {
                    annotation.setAttributeNS(null, "source", source);
                }
                for (Map.Entry entry : eAnnotation.getDetails()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    Element detail = document.createElementNS(null, "detail");
                    if (key != null) {
                        detail.setAttributeNS(null, "key", key);
                    }
                    if (value != null) {
                        detail.appendChild(document.createTextNode(value));
                    }
                    annotation.appendChild(detail);
                }
                parent.appendChild(annotation);
                continue;
            }
            if (!GEN_MODEL_PACKAGE_NS_URI.equals(source) || !eAnnotation.getDetails().containsKey((Object)"documentation") || (documentation = EcoreUtil.getDocumentation((EModelElement)eModelElement)) == null) continue;
            Element annotation = document.createElementNS(null, "annotation");
            annotation.setAttributeNS(null, "source", GEN_MODEL_PACKAGE_NS_URI);
            Element detail = document.createElementNS(null, "detail");
            detail.setAttributeNS(null, "key", "documentation");
            detail.appendChild(document.createTextNode(documentation));
            annotation.appendChild(detail);
            parent.appendChild(annotation);
        }
    }
}

