/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.handlers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsExecutionGraphProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsInterruptContext;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsSystemModel;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.handlers.BaseHandler;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class EventContextHandler
extends BaseHandler {
    private final Map<String, Consumer<ITmfEvent>> fHandlers = new HashMap<String, Consumer<ITmfEvent>>();
    private final Set<IKernelAnalysisEventLayout> fLayouts = new HashSet<IKernelAnalysisEventLayout>();
    private final Consumer<ITmfEvent> fDefault = event -> {};
    private final Consumer<ITmfEvent> fSoftIrqEntryHandler = event -> this.pushInterruptContext((ITmfEvent)event, OsExecutionGraphProvider.Context.SOFTIRQ);
    private final Consumer<ITmfEvent> fSoftIrqExitHandler = event -> this.popInterruptContext((ITmfEvent)event, OsExecutionGraphProvider.Context.SOFTIRQ);
    private final Consumer<ITmfEvent> fHRTimerExpireEntry = event -> this.pushInterruptContext((ITmfEvent)event, OsExecutionGraphProvider.Context.HRTIMER);
    private final Consumer<ITmfEvent> fHRTimerExpireExit = event -> this.popInterruptContext((ITmfEvent)event, OsExecutionGraphProvider.Context.HRTIMER);
    private final Consumer<ITmfEvent> fIrqHandlerEntry = event -> this.pushInterruptContext((ITmfEvent)event, OsExecutionGraphProvider.Context.IRQ);
    private final Consumer<ITmfEvent> fIrqHandlerExit = event -> this.popInterruptContext((ITmfEvent)event, OsExecutionGraphProvider.Context.IRQ);
    private final Consumer<ITmfEvent> fIpiEntry = event -> this.pushInterruptContext((ITmfEvent)event, OsExecutionGraphProvider.Context.IPI);
    private final Consumer<ITmfEvent> fIpiExit = event -> this.popInterruptContext((ITmfEvent)event, OsExecutionGraphProvider.Context.IPI);
    private final Consumer<ITmfEvent> fCompleteHandlerEntry = event -> this.pushInterruptContext((ITmfEvent)event, OsExecutionGraphProvider.Context.COMPLETE_IRQ);
    private final Consumer<ITmfEvent> fCompleteHandlerExit = event -> this.popInterruptContext((ITmfEvent)event, OsExecutionGraphProvider.Context.COMPLETE_IRQ);
    private final Consumer<ITmfEvent> fPacketReceptionEntry = event -> this.pushInterruptContext((ITmfEvent)event, OsExecutionGraphProvider.Context.PACKET_RECEPTION);
    private final Consumer<ITmfEvent> fPacketReceptionExit = event -> this.popInterruptContext((ITmfEvent)event, OsExecutionGraphProvider.Context.PACKET_RECEPTION);

    public EventContextHandler(OsExecutionGraphProvider provider, int priority) {
        super(provider, priority);
    }

    @Override
    public void handleEvent(ITmfEvent event) {
        IKernelAnalysisEventLayout eventLayout = this.getProvider().getEventLayout(event.getTrace());
        if (!this.fLayouts.contains(eventLayout)) {
            this.populateHandlerMap(eventLayout);
            this.fLayouts.add(eventLayout);
        }
        this.fHandlers.getOrDefault(event.getName(), this.fDefault).accept(event);
    }

    private void populateHandlerMap(IKernelAnalysisEventLayout eventLayout) {
        this.fHandlers.put(eventLayout.eventSoftIrqEntry(), this.fSoftIrqEntryHandler);
        this.fHandlers.put(eventLayout.eventSoftIrqExit(), this.fSoftIrqExitHandler);
        this.fHandlers.put(eventLayout.eventHRTimerExpireEntry(), this.fHRTimerExpireEntry);
        this.fHandlers.put(eventLayout.eventHRTimerExpireExit(), this.fHRTimerExpireExit);
        this.fHandlers.put(eventLayout.eventIrqHandlerEntry(), this.fIrqHandlerEntry);
        this.fHandlers.put(eventLayout.eventIrqHandlerExit(), this.fIrqHandlerExit);
        for (String ipiName : eventLayout.getIPIIrqVectorsEntries()) {
            this.fHandlers.put(ipiName, this.fIpiEntry);
        }
        for (String ipiName : eventLayout.getIPIIrqVectorsEntries()) {
            this.fHandlers.put(ipiName, this.fIpiExit);
        }
        this.fHandlers.put(eventLayout.eventIrqEntry(), this.fCompleteHandlerEntry);
        this.fHandlers.put(eventLayout.eventIrqExit(), this.fCompleteHandlerExit);
        for (String networkEvent : eventLayout.eventsNetworkReceiveEntry()) {
            this.fHandlers.put(networkEvent, this.fPacketReceptionEntry);
        }
        for (String networkEvent : eventLayout.eventsNetworkReceiveExit()) {
            this.fHandlers.put(networkEvent, this.fPacketReceptionExit);
        }
    }

    private void pushInterruptContext(ITmfEvent event, OsExecutionGraphProvider.Context ctx) {
        Integer cpu = (Integer)NonNullUtils.checkNotNull((Object)TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event));
        OsSystemModel system = this.getProvider().getSystem();
        OsInterruptContext interruptCtx = new OsInterruptContext(event, ctx);
        system.pushContextStack(event.getTrace().getHostId(), cpu, interruptCtx);
    }

    private void popInterruptContext(ITmfEvent event, OsExecutionGraphProvider.Context ctx) {
        Integer cpu = (Integer)NonNullUtils.checkNotNull((Object)TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event));
        OsSystemModel system = this.getProvider().getSystem();
        OsInterruptContext interruptCtx = system.peekContextStack(event.getTrace().getHostId(), cpu);
        if (interruptCtx.getContext() == ctx) {
            system.popContextStack(event.getTrace().getHostId(), cpu);
        }
    }
}

