/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.io.File;
import java.net.URI;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.util.ByteBufferTracker;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.io.ResourceUtil;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTrace;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTrace;
import org.eclipse.tracecompass.tmf.core.project.model.ITmfPropertiesProvider;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.core.synchronization.TimestampTransformFactory;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelIcons;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.properties.ReadOnlyTextPropertyDescriptor;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;

public class TmfTraceElement
extends TmfCommonProjectElement
implements IActionFilter,
IPropertySource2 {
    public static final String BUNDLE = "bundle";
    public static final String IS_LINKED = "isLinked";
    private static final String RESOURCE_PROPERTIES_CATEGORY = Messages.TmfTraceElement_ResourceProperties;
    private static final String NAME = Messages.TmfTraceElement_Name;
    private static final String PATH = Messages.TmfTraceElement_Path;
    private static final String LOCATION = Messages.TmfTraceElement_Location;
    private static final String TRACE_TYPE = Messages.TmfTraceElement_EventType;
    private static final String TRACE_TYPE_ID = Messages.TmfTraceElement_TraceTypeId;
    private static final String IS_LINKED_PROPERTY = Messages.TmfTraceElement_IsLinked;
    private static final String SOURCE_LOCATION = Messages.TmfTraceElement_SourceLocation;
    private static final String TIME_OFFSET = Messages.TmfTraceElement_TimeOffset;
    private static final String LAST_MODIFIED = Messages.TmfTraceElement_LastModified;
    private static final String SIZE = Messages.TmfTraceElement_Size;
    private static final String TRACE_PROPERTIES_CATEGORY = Messages.TmfTraceElement_TraceProperties;
    private static final ReadOnlyTextPropertyDescriptor NAME_DESCRIPTOR = new ReadOnlyTextPropertyDescriptor(NAME, NAME);
    private static final ReadOnlyTextPropertyDescriptor PATH_DESCRIPTOR = new ReadOnlyTextPropertyDescriptor(PATH, PATH);
    private static final ReadOnlyTextPropertyDescriptor LOCATION_DESCRIPTOR = new ReadOnlyTextPropertyDescriptor(LOCATION, LOCATION);
    private static final ReadOnlyTextPropertyDescriptor TYPE_DESCRIPTOR = new ReadOnlyTextPropertyDescriptor(TRACE_TYPE, TRACE_TYPE);
    private static final ReadOnlyTextPropertyDescriptor TYPE_ID_DESCRIPTOR = new ReadOnlyTextPropertyDescriptor(TRACE_TYPE_ID, TRACE_TYPE_ID);
    private static final ReadOnlyTextPropertyDescriptor IS_LINKED_DESCRIPTOR = new ReadOnlyTextPropertyDescriptor(IS_LINKED_PROPERTY, IS_LINKED_PROPERTY);
    private static final ReadOnlyTextPropertyDescriptor SOURCE_LOCATION_DESCRIPTOR = new ReadOnlyTextPropertyDescriptor(SOURCE_LOCATION, SOURCE_LOCATION);
    private static final ReadOnlyTextPropertyDescriptor TIME_OFFSET_DESCRIPTOR = new ReadOnlyTextPropertyDescriptor(TIME_OFFSET, TIME_OFFSET);
    private static final ReadOnlyTextPropertyDescriptor LAST_MODIFIED_DESCRIPTOR = new ReadOnlyTextPropertyDescriptor(LAST_MODIFIED, LAST_MODIFIED);
    private static final ReadOnlyTextPropertyDescriptor SIZE_DESCRIPTOR = new ReadOnlyTextPropertyDescriptor(SIZE, SIZE);
    private static final IPropertyDescriptor[] sfDescriptors = new IPropertyDescriptor[]{NAME_DESCRIPTOR, PATH_DESCRIPTOR, LOCATION_DESCRIPTOR, TYPE_DESCRIPTOR, TYPE_ID_DESCRIPTOR, IS_LINKED_DESCRIPTOR, SOURCE_LOCATION_DESCRIPTOR, TIME_OFFSET_DESCRIPTOR, LAST_MODIFIED_DESCRIPTOR, SIZE_DESCRIPTOR};
    private static final TmfTimestampFormat OFFSET_FORMAT;
    private static final int FOLDER_MAX_COUNT = 1024;
    private static final Map<String, IConfigurationElement> TRACE_TYPE_UI_ATTRIBUTES;
    private FileInfo fFileInfo;
    private ITmfTimestamp fStartTime = null;
    private ITmfTimestamp fEndTime = null;
    private boolean fPreDeleted = false;

    static {
        NAME_DESCRIPTOR.setCategory(RESOURCE_PROPERTIES_CATEGORY);
        PATH_DESCRIPTOR.setCategory(RESOURCE_PROPERTIES_CATEGORY);
        LOCATION_DESCRIPTOR.setCategory(RESOURCE_PROPERTIES_CATEGORY);
        TYPE_DESCRIPTOR.setCategory(RESOURCE_PROPERTIES_CATEGORY);
        TYPE_ID_DESCRIPTOR.setCategory(RESOURCE_PROPERTIES_CATEGORY);
        IS_LINKED_DESCRIPTOR.setCategory(RESOURCE_PROPERTIES_CATEGORY);
        SOURCE_LOCATION_DESCRIPTOR.setCategory(RESOURCE_PROPERTIES_CATEGORY);
        TIME_OFFSET_DESCRIPTOR.setCategory(RESOURCE_PROPERTIES_CATEGORY);
        LAST_MODIFIED_DESCRIPTOR.setCategory(RESOURCE_PROPERTIES_CATEGORY);
        SIZE_DESCRIPTOR.setCategory(RESOURCE_PROPERTIES_CATEGORY);
        OFFSET_FORMAT = new TmfTimestampFormat("T.SSS SSS SSS s");
        TRACE_TYPE_UI_ATTRIBUTES = new HashMap<String, IConfigurationElement>();
    }

    public static void init() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.linuxtools.tmf.ui.tracetypeui");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            String elemName = ce.getName();
            if ("type".equals(elemName)) {
                String traceType = ce.getAttribute("tracetype");
                TRACE_TYPE_UI_ATTRIBUTES.put(traceType, ce);
            }
            ++n2;
        }
    }

    public TmfTraceElement(String name, IResource trace, TmfTraceFolder parent) {
        super(name, trace, parent);
    }

    public TmfTraceElement(String name, IResource trace, TmfExperimentElement parent) {
        super(name, trace, parent);
    }

    @Override
    public @NonNull Image getIcon() {
        Image icon = super.getIcon();
        return icon == null ? TmfProjectModelIcons.DEFAULT_TRACE_ICON : icon;
    }

    @Override
    public String getLabelText() {
        if (this.getParent() instanceof TmfExperimentElement) {
            return this.getElementPath();
        }
        return this.getName();
    }

    @Override
    public ITmfTrace instantiateTrace() {
        try {
            this.refreshSupplementaryFolder();
            String traceTypeId = this.getTraceType();
            if (traceTypeId != null) {
                return TmfTraceType.instantiateTrace((String)traceTypeId);
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error instantiating ITmfTrace object for trace " + this.getName(), e);
        }
        return null;
    }

    public ITmfEvent instantiateEvent() {
        try {
            String traceTypeId = this.getTraceType();
            if (traceTypeId != null) {
                return TmfTraceType.instantiateEvent((String)traceTypeId);
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error instantiating ITmfEvent object for trace " + this.getName(), e);
        }
        return null;
    }

    @Override
    public String getEditorId() {
        String traceTypeId = this.getTraceType();
        if (traceTypeId != null) {
            if (CustomTxtTrace.isCustomTraceTypeId((String)traceTypeId) || CustomXmlTrace.isCustomTraceTypeId((String)traceTypeId)) {
                return "org.eclipse.linuxtools.tmf.ui.editors.events";
            }
            IConfigurationElement ce = TRACE_TYPE_UI_ATTRIBUTES.get(this.getTraceType());
            if (ce == null) {
                return null;
            }
            IConfigurationElement[] defaultEditorCE = ce.getChildren("defaultEditor");
            if (defaultEditorCE.length == 1) {
                return defaultEditorCE[0].getAttribute("id");
            }
        }
        return null;
    }

    @Override
    public IFile getBookmarksFile() {
        IFile file = null;
        IResource resource = this.getResource();
        if (resource instanceof IFile) {
            file = (IFile)resource;
        } else if (resource instanceof IFolder) {
            IFolder folder = (IFolder)resource;
            file = folder.getFile(String.valueOf(this.getName()) + '_');
        }
        return file;
    }

    public TmfTraceElement getElementUnderTraceFolder() {
        if (this.getParent() instanceof TmfExperimentElement) {
            ITmfProjectModelElement parent = this.getProject().getTracesFolder();
            ITmfProjectModelElement element = null;
            if (parent != null) {
                String[] stringArray = new Path(this.getElementPath()).segments();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String segment = stringArray[n2];
                    element = parent.getChild(segment);
                    if (element == null) {
                        return this;
                    }
                    parent = element;
                    ++n2;
                }
                if (element instanceof TmfTraceElement) {
                    return (TmfTraceElement)element;
                }
            }
        }
        return this;
    }

    @Override
    public String getTypeName() {
        return Messages.TmfTraceElement_TypeName;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (name.equals(IS_LINKED)) {
            return Boolean.toString(ResourceUtil.isSymbolicLink((IResource)this.getElementUnderTraceFolder().getResource())).equals(value);
        }
        return false;
    }

    public Object getEditableValue() {
        return null;
    }

    @Override
    public ITmfTrace getTrace() {
        ITmfProjectModelElement parent = this.getParent();
        if (parent instanceof TmfExperimentElement) {
            IResource resource = this.getElementUnderTraceFolder().getResource();
            ITmfTrace experiment = ((TmfExperimentElement)parent).getTrace();
            for (ITmfTrace trace : TmfTraceManager.getTraceSet((ITmfTrace)experiment)) {
                if (!resource.equals((Object)trace.getResource())) continue;
                return trace;
            }
            return null;
        }
        return super.getTrace();
    }

    private Map<String, String> getTraceProperties() {
        for (ITmfTrace openedTrace : TmfTraceManager.getInstance().getOpenedTraces()) {
            for (ITmfTrace singleTrace : TmfTraceManager.getTraceSet((ITmfTrace)openedTrace)) {
                if (!this.getElementUnderTraceFolder().getResource().equals((Object)singleTrace.getResource()) || !(singleTrace instanceof ITmfPropertiesProvider)) continue;
                ITmfPropertiesProvider traceProperties = (ITmfPropertiesProvider)singleTrace;
                return traceProperties.getProperties();
            }
        }
        return new HashMap<String, String>();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        Map<String, String> traceProperties = this.getTraceProperties();
        if (!traceProperties.isEmpty()) {
            IPropertyDescriptor[] propertyDescriptorArray = new IPropertyDescriptor[traceProperties.size() + sfDescriptors.length];
            int index = 0;
            for (Map.Entry<String, String> varName : traceProperties.entrySet()) {
                ReadOnlyTextPropertyDescriptor descriptor = new ReadOnlyTextPropertyDescriptor(String.valueOf(this.getName()) + "_" + varName.getKey(), varName.getKey());
                descriptor.setCategory(TRACE_PROPERTIES_CATEGORY);
                propertyDescriptorArray[index] = descriptor;
                ++index;
            }
            System.arraycopy(sfDescriptors, 0, propertyDescriptorArray, index, sfDescriptors.length);
            return propertyDescriptorArray;
        }
        return Arrays.copyOf(sfDescriptors, sfDescriptors.length);
    }

    public Object getPropertyValue(Object id) {
        if (NAME.equals(id)) {
            return this.getName();
        }
        if (PATH.equals(id)) {
            return this.getPath().toString();
        }
        if (LOCATION.equals(id)) {
            URI uri = ResourceUtil.getLocationURI((IResource)this.getElementUnderTraceFolder().getResource());
            if (uri == null) {
                uri = this.getElementUnderTraceFolder().getLocation();
            }
            return URIUtil.toUnencodedString((URI)new File(uri).toURI());
        }
        if (IS_LINKED_PROPERTY.equals(id)) {
            return Boolean.toString(ResourceUtil.isSymbolicLink((IResource)this.getElementUnderTraceFolder().getResource()));
        }
        if (SOURCE_LOCATION.equals(id)) {
            try {
                String sourceLocation = this.getElementUnderTraceFolder().getResource().getPersistentProperty(TmfCommonConstants.SOURCE_LOCATION);
                if (sourceLocation != null) {
                    return sourceLocation;
                }
            }
            catch (CoreException coreException) {}
            return "";
        }
        if (LAST_MODIFIED.equals(id)) {
            FileInfo fileInfo = this.getElementUnderTraceFolder().getFileInfo();
            if (fileInfo == null) {
                return "";
            }
            long date = fileInfo.lastModified;
            DateFormat format = DateFormat.getDateTimeInstance(1, 2);
            return format.format(new Date(date));
        }
        if (SIZE.equals(id)) {
            FileInfo fileInfo = this.getElementUnderTraceFolder().getFileInfo();
            if (fileInfo == null) {
                return "";
            }
            if (this.getElementUnderTraceFolder().getResource() instanceof IFolder) {
                if (fileInfo.count <= 1024) {
                    return NLS.bind((String)Messages.TmfTraceElement_FolderSizeString, (Object)NumberFormat.getInstance().format(fileInfo.size), (Object)fileInfo.count);
                }
                return NLS.bind((String)Messages.TmfTraceElement_FolderSizeOverflowString, (Object)NumberFormat.getInstance().format(fileInfo.size), (Object)1024);
            }
            return NLS.bind((String)Messages.TmfTraceElement_FileSizeString, (Object)NumberFormat.getInstance().format(fileInfo.size));
        }
        if (TRACE_TYPE.equals(id)) {
            TraceTypeHelper helper;
            if (this.getTraceType() != null && (helper = TmfTraceType.getTraceType((String)this.getTraceType())) != null) {
                return helper.getLabel();
            }
            return "";
        }
        if (TRACE_TYPE_ID.equals(id)) {
            if (this.getTraceType() != null) {
                return this.getTraceType();
            }
            return "";
        }
        if (TIME_OFFSET.equals(id)) {
            long offset = TimestampTransformFactory.getTimestampTransform((IResource)this.getElementUnderTraceFolder().getResource()).transform(0L);
            if (offset != 0L) {
                return OFFSET_FORMAT.format(offset);
            }
            return "";
        }
        Map<String, String> traceProperties = this.getTraceProperties();
        if (id != null && !traceProperties.isEmpty()) {
            String key = (String)id;
            key = key.substring(this.getName().length() + 1);
            String value = traceProperties.get(key);
            return value;
        }
        return null;
    }

    private FileInfo getFileInfo() {
        FileInfo fileInfo;
        if (this.fFileInfo == null) {
            try {
                fileInfo = this.computeFileInfo(new FileInfo(), this.getResource());
            }
            catch (CoreException coreException) {
                return null;
            }
            this.fFileInfo = fileInfo;
        } else {
            fileInfo = this.fFileInfo;
            this.fFileInfo = null;
        }
        return fileInfo;
    }

    private FileInfo computeFileInfo(FileInfo fileInfo, IResource resource) throws CoreException {
        if (fileInfo == null || fileInfo.count > 1024) {
            return fileInfo;
        }
        if (resource instanceof IFolder) {
            IFolder folder = (IFolder)resource;
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                this.computeFileInfo(fileInfo, member);
                ++n2;
            }
            return fileInfo;
        }
        IFileInfo info = EFS.getStore((URI)resource.getLocationURI()).fetchInfo();
        fileInfo.lastModified = Math.max(fileInfo.lastModified, info.getLastModified());
        fileInfo.size += info.getLength();
        ++fileInfo.count;
        return fileInfo;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public TmfTraceElement copy(String newName) {
        TmfTraceFolder folder = (TmfTraceFolder)this.getParent();
        IResource res = super.copy(newName, false);
        for (TmfTraceElement trace : folder.getTraces()) {
            if (!trace.getResource().equals((Object)res)) continue;
            return trace;
        }
        return null;
    }

    @Override
    public void closeEditors() {
        super.closeEditors();
        if (this.getParent() instanceof TmfTraceFolder) {
            TmfExperimentFolder experimentsFolder = this.getProject().getExperimentsFolder();
            if (experimentsFolder != null) {
                block0: for (TmfExperimentElement experiment : experimentsFolder.getExperiments()) {
                    for (TmfTraceElement trace : experiment.getTraces()) {
                        if (!trace.getElementPath().equals(this.getElementPath())) continue;
                        experiment.closeEditors();
                        continue block0;
                    }
                }
            }
        } else if (this.getParent() instanceof TmfExperimentElement) {
            TmfExperimentElement experiment = (TmfExperimentElement)this.getParent();
            experiment.closeEditors();
        }
        if (ByteBufferTracker.getAndReset()) {
            System.gc();
        }
    }

    public void delete(IProgressMonitor progressMonitor) throws CoreException {
        this.delete(progressMonitor, false);
    }

    public void delete(IProgressMonitor progressMonitor, boolean overwriting) throws CoreException {
        this.delete(progressMonitor, overwriting, true);
    }

    public void delete(IProgressMonitor progressMonitor, boolean overwriting, boolean closeEditors) throws CoreException {
        IResource resourceToDelete;
        if (closeEditors) {
            Display.getDefault().syncExec(this::closeEditors);
        }
        if ((resourceToDelete = this.getResource()) == null) {
            return;
        }
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)2);
        this.preDelete((IProgressMonitor)subMon.split(1), overwriting);
        ResourceUtil.deleteResource((IResource)resourceToDelete, (IProgressMonitor)subMon.split(1));
    }

    void preDelete(IProgressMonitor progressMonitor, boolean overwriting) throws CoreException {
        if (this.fPreDeleted) {
            return;
        }
        this.fPreDeleted = true;
        IResource resourceToDelete = this.getResource();
        if (resourceToDelete == null) {
            return;
        }
        IPath path = resourceToDelete.getLocation();
        if (path != null) {
            if (this.getParent() instanceof TmfTraceFolder) {
                TmfExperimentFolder experimentFolder = this.getProject().getExperimentsFolder();
                if (experimentFolder != null && !overwriting) {
                    for (TmfExperimentElement experiment : experimentFolder.getExperiments()) {
                        LinkedList<TmfTraceElement> toRemove = new LinkedList<TmfTraceElement>();
                        for (TmfTraceElement trace : experiment.getTraces()) {
                            if (!trace.getElementPath().equals(this.getElementPath())) continue;
                            toRemove.add(trace);
                        }
                        for (TmfTraceElement child : toRemove) {
                            experiment.removeTrace(child, false);
                        }
                        if (toRemove.isEmpty() || !experiment.getTraces().isEmpty()) continue;
                        experiment.deleteSupplementaryFolder();
                        experiment.getResource().delete(true, progressMonitor);
                    }
                }
                if (overwriting) {
                    this.deleteSupplementaryResources();
                } else {
                    this.deleteSupplementaryFolder();
                }
            } else if (this.getParent() instanceof TmfExperimentElement) {
                TmfExperimentElement experimentElement = (TmfExperimentElement)this.getParent();
                experimentElement.deleteSupplementaryResources();
            }
        }
        if (overwriting) {
            ((TmfProjectModelElement)this.getParent()).removeChild(this);
        }
    }

    public void setStartTime(ITmfTimestamp startTime) {
        this.fStartTime = startTime;
    }

    public ITmfTimestamp getStartTime() {
        ITmfTrace trace = this.getTrace();
        if (trace != null) {
            this.setStartTime(trace.getStartTime());
        }
        return this.fStartTime;
    }

    public void setEndTime(@NonNull ITmfTimestamp end) {
        if (this.fEndTime == null || end.compareTo(this.fEndTime) > 0) {
            this.fEndTime = end;
        }
    }

    public ITmfTimestamp getEndTime() {
        ITmfTrace trace = this.getTrace();
        if (trace != null) {
            this.setEndTime(trace.getEndTime());
        }
        return this.fEndTime;
    }

    @Override
    public void deleteSupplementaryResources(IResource[] resources) {
        this.fStartTime = null;
        this.fEndTime = null;
        super.deleteSupplementaryResources(resources);
    }

    @Override
    public void deleteSupplementaryResources() {
        super.deleteSupplementaryResources();
        TmfExperimentFolder experimentFolder = this.getProject().getExperimentsFolder();
        if (experimentFolder != null) {
            block0: for (TmfExperimentElement experiment : experimentFolder.getExperiments()) {
                for (TmfTraceElement trace : experiment.getTraces()) {
                    if (!trace.getElementPath().equals(this.getElementPath())) continue;
                    experiment.deleteSupplementaryResources();
                    continue block0;
                }
            }
        }
    }

    private class FileInfo {
        long lastModified;
        long size;
        int count;

        private FileInfo() {
        }
    }
}

