/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.chart.ui.swtbot.tests.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCheckBox;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotRootMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.chart.ChartType;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.DataChartDurationDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.DataChartNumericalDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.DataChartStringDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.DataChartTimestampDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.descriptor.IDataChartDescriptor;
import org.eclipse.tracecompass.tmf.chart.core.model.IDataChartProvider;
import org.eclipse.tracecompass.tmf.chart.core.tests.stubs.StubChartProviderFull;
import org.eclipse.tracecompass.tmf.chart.core.tests.stubs.StubObject;
import org.eclipse.tracecompass.tmf.chart.ui.swtbot.stubs.CustomChartStubView;
import org.eclipse.tracecompass.tmf.chart.ui.swtbot.tests.shared.SWTBotCustomChartUtils;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
@NonNullByDefault
public class ChartMakerDialogTest {
    private final SWTWorkbenchBot fBot = new SWTWorkbenchBot();
    private static final IDataChartProvider<StubObject> CHART_PROVIDER = new StubChartProviderFull();

    @BeforeClass
    public static void beforeClass() {
        SWTBotUtils.initialize();
        Thread.currentThread().setName("SWTBotTest");
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        WaitUtils.waitForJobs();
        SWTBotUtils.openView((String)"org.eclipse.tracecompass.tmf.chart.ui.swtbot.view.stub");
        CustomChartStubView.setChartProvider(CHART_PROVIDER);
    }

    private void openDialog() {
        SWTBotView viewBot = this.fBot.viewById("org.eclipse.tracecompass.tmf.chart.ui.swtbot.view.stub");
        SWTBotRootMenu viewMenu = viewBot.viewMenu();
        SWTBotMenu menu = viewMenu.menu(new String[]{"Create custom chart"});
        menu.click();
    }

    private List<IDataChartDescriptor<?, ?>> getDescriptors(int tblIndex) {
        SWTBotTable table = this.fBot.table(tblIndex);
        List items = (List)UIThreadRunnable.syncExec(() -> {
            ArrayList<IDataChartDescriptor> list = new ArrayList<IDataChartDescriptor>();
            TableItem[] tableItemArray = ((Table)sWTBotTable.widget).getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                Object data = item.getData();
                if (data instanceof IDataChartDescriptor) {
                    IDataChartDescriptor desc = (IDataChartDescriptor)data;
                    list.add(desc);
                }
                ++n2;
            }
            return list;
        });
        Assert.assertNotNull((Object)items);
        return items;
    }

    private void assertDescriptors(String msg, Collection<@NonNull IDataChartDescriptor<@NonNull StubObject, ?>> expected, int tblIndex) {
        List<IDataChartDescriptor<?, ?>> descriptors = this.getDescriptors(tblIndex);
        Assert.assertEquals((String)(String.valueOf(msg) + " descriptors count"), (long)expected.size(), (long)descriptors.size());
        for (IDataChartDescriptor<?, ?> desc : descriptors) {
            Assert.assertTrue((String)(String.valueOf(msg) + " contains"), (boolean)expected.contains(desc));
        }
    }

    @Test
    public void testBarChartSeries() {
        this.openDialog();
        SWTBotCustomChartUtils.selectChartType(this.fBot, ChartType.BAR_CHART);
        List<IDataChartDescriptor<StubObject, ?>> expectedXDescriptors = CHART_PROVIDER.getDataDescriptors().stream().filter(d -> d instanceof DataChartStringDescriptor).collect(Collectors.toList());
        this.assertDescriptors("Initial X", expectedXDescriptors, 2);
        List<IDataChartDescriptor<StubObject, ?>> expectedYDescriptors = CHART_PROVIDER.getDataDescriptors().stream().filter(d -> d instanceof DataChartNumericalDescriptor).collect(Collectors.toList());
        this.assertDescriptors("Initial Y", expectedYDescriptors, 3);
        SWTBotTable yTable = this.fBot.table(3);
        SWTBotCheckBox chkLogX = this.fBot.checkBox("Logarithmic Scale " + (Object)((Object)SWTBotCustomChartUtils.AxisType.X));
        SWTBotCheckBox chkLogY = this.fBot.checkBox("Logarithmic Scale " + (Object)((Object)SWTBotCustomChartUtils.AxisType.Y));
        String toCheck = expectedYDescriptors.stream().filter(d -> d.getClass() == DataChartNumericalDescriptor.class).map(d -> d.getLabel()).findFirst().get();
        yTable.getTableItem(toCheck).check();
        List<Object> subset = expectedYDescriptors.stream().filter(d -> d.getClass() == DataChartNumericalDescriptor.class).collect(Collectors.toList());
        this.assertDescriptors("Checked numerical Y descriptors", subset, 3);
        yTable.getTableItem(toCheck).uncheck();
        this.assertDescriptors("Unchecked numerical Y descriptors", expectedYDescriptors, 3);
        Assert.assertFalse((boolean)chkLogX.isEnabled());
        Assert.assertTrue((boolean)chkLogY.isEnabled());
        toCheck = expectedYDescriptors.stream().filter(d -> d.getClass() == DataChartDurationDescriptor.class).map(d -> d.getLabel()).findFirst().get();
        yTable.getTableItem(toCheck).check();
        subset = expectedYDescriptors.stream().filter(d -> d.getClass() == DataChartDurationDescriptor.class).collect(Collectors.toList());
        this.assertDescriptors("Checked duration Y descriptors", subset, 3);
        yTable.getTableItem(toCheck).uncheck();
        this.assertDescriptors("Unchecked duration Y descriptors", expectedYDescriptors, 3);
        Assert.assertFalse((boolean)chkLogX.isEnabled());
        Assert.assertTrue((boolean)chkLogY.isEnabled());
        toCheck = expectedYDescriptors.stream().filter(d -> d.getClass() == DataChartTimestampDescriptor.class).map(d -> d.getLabel()).findFirst().get();
        yTable.getTableItem(toCheck).check();
        subset = expectedYDescriptors.stream().filter(d -> d.getClass() == DataChartTimestampDescriptor.class).collect(Collectors.toList());
        this.assertDescriptors("Checked timestamp Y descriptors", subset, 3);
        yTable.getTableItem(toCheck).uncheck();
        this.assertDescriptors("Unchecked timestamp Y descriptors", expectedYDescriptors, 3);
        Assert.assertFalse((boolean)chkLogX.isEnabled());
        Assert.assertTrue((boolean)chkLogY.isEnabled());
        SWTBotCustomChartUtils.addSeries(this.fBot, expectedXDescriptors.get(0).getLabel(), Collections.singleton(toCheck));
        this.assertDescriptors("After add X", Collections.singleton(expectedXDescriptors.get(0)), 2);
        this.assertDescriptors("After add Y", subset, 3);
        Assert.assertFalse((boolean)chkLogX.isEnabled());
        Assert.assertFalse((boolean)chkLogY.isEnabled());
        for (IDataChartDescriptor iDataChartDescriptor : subset) {
            String label = iDataChartDescriptor.getLabel();
            if (label.equals(toCheck)) {
                Assert.assertTrue((boolean)yTable.getTableItem(label).isChecked());
                continue;
            }
            Assert.assertFalse((boolean)yTable.getTableItem(label).isChecked());
        }
        yTable.getTableItem(toCheck).check();
        SWTBotTable sWTBotTable = this.fBot.table(1);
        Assert.assertEquals((String)"Selected rows after one addition", (long)1L, (long)sWTBotTable.rowCount());
        SWTBotCustomChartUtils.addSeries(this.fBot, expectedXDescriptors.get(0).getLabel(), subset.stream().map(d -> d.getLabel()).collect(Collectors.toSet()));
        Assert.assertEquals((String)"Selected rows after all added", (long)subset.size(), (long)sWTBotTable.rowCount());
        Assert.assertFalse((boolean)chkLogX.isEnabled());
        Assert.assertFalse((boolean)chkLogY.isEnabled());
    }
}

