/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.trace.indexer;

import java.io.File;
import org.eclipse.tracecompass.internal.tmf.core.trace.indexer.FlatArray;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfPersistentlyIndexable;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.ITmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.ITmfCheckpointIndex;

public class TmfFlatArrayTraceIndex
implements ITmfCheckpointIndex {
    private final FlatArray fCheckpoints;

    public TmfFlatArrayTraceIndex(ITmfTrace trace) {
        this.fCheckpoints = new FlatArray(TmfFlatArrayTraceIndex.getIndexFile(trace, "checkpoint_flatarray.idx"), (ITmfPersistentlyIndexable)((Object)trace));
    }

    private static File getIndexFile(ITmfTrace trace, String fileName) {
        String directory = TmfTraceManager.getSupplementaryFileDir(trace);
        return new File(directory + fileName);
    }

    @Override
    public void dispose() {
        this.fCheckpoints.dispose();
    }

    @Override
    public void insert(ITmfCheckpoint checkpoint) {
        this.fCheckpoints.insert(checkpoint);
    }

    @Override
    public ITmfCheckpoint get(long checkpoint) {
        return this.fCheckpoints.get(checkpoint);
    }

    @Override
    public long binarySearch(ITmfCheckpoint checkpoint) {
        return this.fCheckpoints.binarySearch(checkpoint);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        return this.fCheckpoints.size();
    }

    @Override
    public boolean isCreatedFromScratch() {
        return this.fCheckpoints.isCreatedFromScratch();
    }

    @Override
    public void setTimeRange(TmfTimeRange timeRange) {
        this.fCheckpoints.setTimeRange(timeRange);
    }

    @Override
    public void setNbEvents(long nbEvents) {
        this.fCheckpoints.setNbEvents(nbEvents);
    }

    @Override
    public TmfTimeRange getTimeRange() {
        return this.fCheckpoints.getTimeRange();
    }

    @Override
    public long getNbEvents() {
        return this.fCheckpoints.getNbEvents();
    }
}

