/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.chart.axis;

import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.data.Range;
import org.jfree.data.RangeType;

public class BoundedNumberAxis
extends NumberAxis {
    private static final long serialVersionUID = 4541966206816909874L;
    private double lowerBound = Double.NEGATIVE_INFINITY;
    private boolean autoRangeIncludesLowerBound;
    private double upperBound = Double.POSITIVE_INFINITY;
    private boolean autoRangeIncludesUpperBound;

    public BoundedNumberAxis() {
    }

    public BoundedNumberAxis(String label) {
        super(label);
    }

    public void setLowerBound(double min) {
        if (min > this.upperBound) {
            this.upperBound = min + 1.0;
        }
        this.lowerBound = min;
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        } else {
            this.setRange(this.lowerBound, this.upperBound);
        }
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setAutoRangeIncludesLowerBound(boolean autoRangeIncludesLowerBound) {
        this.autoRangeIncludesLowerBound = autoRangeIncludesLowerBound;
        this.fireChangeEvent();
    }

    public boolean getAutoRangeIncludesLowerBound() {
        return this.autoRangeIncludesLowerBound;
    }

    public void setUpperBound(double max) {
        if (max < this.lowerBound) {
            this.lowerBound = max - 1.0;
        }
        this.upperBound = max;
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        } else {
            this.setRange(this.lowerBound, this.upperBound);
        }
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setAutoRangeIncludesUpperBound(boolean autoRangeIncludesUpperBound) {
        this.autoRangeIncludesUpperBound = autoRangeIncludesUpperBound;
        this.fireChangeEvent();
    }

    public boolean getAutoRangeIncludesUpperBound() {
        return this.autoRangeIncludesUpperBound;
    }

    public Range calculateAutoRange(boolean adhereToMax) {
        Plot plot = this.getPlot();
        if (plot == null) {
            return null;
        }
        if (plot instanceof ValueAxisPlot) {
            ValueAxisPlot vap = (ValueAxisPlot)plot;
            Range r = vap.getDataRange((ValueAxis)this);
            if (r == null) {
                r = this.getDefaultAutoRange();
            }
            double upper = r.getUpperBound();
            double lower = r.getLowerBound();
            if (this.getRangeType() == RangeType.POSITIVE) {
                lower = Math.max(0.0, lower);
                upper = Math.max(0.0, upper);
            } else if (this.getRangeType() == RangeType.NEGATIVE) {
                lower = Math.min(0.0, lower);
                upper = Math.min(0.0, upper);
            }
            if (this.getAutoRangeIncludesZero()) {
                lower = Math.min(lower, 0.0);
                upper = Math.max(upper, 0.0);
            }
            if (this.getAutoRangeIncludesLowerBound()) {
                lower = Math.min(lower, this.getLowerBound());
                upper = Math.max(upper, this.getLowerBound());
            }
            if (this.getAutoRangeIncludesUpperBound()) {
                lower = Math.min(lower, this.getUpperBound());
                upper = Math.max(upper, this.getUpperBound());
            }
            double range = upper - lower;
            double fixedAutoRange = this.getFixedAutoRange();
            if (adhereToMax && fixedAutoRange > 0.0) {
                Range aligned = this.getAutoRangeAlign().align(new Range(lower, upper), fixedAutoRange);
                lower = aligned.getLowerBound();
                upper = aligned.getUpperBound();
            } else {
                double minRange = this.getAutoRangeMinimumSize();
                if (range < minRange) {
                    double expand = (minRange - range) / 2.0;
                    if ((lower -= expand) == (upper += expand)) {
                        double adjust = Math.abs(lower) / 10.0;
                        lower -= adjust;
                        upper += adjust;
                    }
                    if (this.getRangeType() == RangeType.POSITIVE) {
                        if (lower < 0.0) {
                            upper -= lower;
                            lower = 0.0;
                        }
                    } else if (this.getRangeType() == RangeType.NEGATIVE && upper > 0.0) {
                        lower -= upper;
                        upper = 0.0;
                    }
                }
                if (this.getAutoRangeStickyZero()) {
                    upper = upper <= 0.0 ? Math.min(0.0, upper + this.getUpperMargin() * range) : (upper += this.getUpperMargin() * range);
                    lower = lower >= 0.0 ? Math.max(0.0, lower - this.getLowerMargin() * range) : (lower -= this.getLowerMargin() * range);
                } else {
                    upper += this.getUpperMargin() * range;
                    lower -= this.getLowerMargin() * range;
                }
            }
            return new Range(lower, upper);
        }
        return null;
    }
}

