/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.p2repo.p2.tests;

import java.io.File;
import java.util.Iterator;
import org.eclipse.cbi.p2repo.p2.P2Factory;
import org.eclipse.cbi.p2repo.p2.impl.InstallableUnitImpl;
import org.eclipse.cbi.p2repo.p2.impl.MetadataRepositoryImpl;
import org.eclipse.cbi.p2repo.p2.impl.RequiredCapabilityImpl;
import org.eclipse.cbi.p2repo.p2.util.P2Bridge;
import org.eclipse.cbi.p2repo.p2.util.P2Utils;
import org.eclipse.cbi.p2repo.util.LogUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.junit.Test;

public class MetadataRepositoryTests {
    private static final String SIMPLE_METADATA_TYPE = "org.eclipse.equinox.p2.metadata.repository.simpleRepository";

    @Test
    public void createAndLoadMDR() throws Exception {
        File tempRepositoryLocation = null;
        try {
            tempRepositoryLocation = File.createTempFile("p2mdr", null);
            String path = tempRepositoryLocation.getAbsolutePath();
            tempRepositoryLocation.delete();
            tempRepositoryLocation = new File(path);
            IMetadataRepositoryManager mdrMgr = (IMetadataRepositoryManager)P2Utils.getRepositoryManager(IMetadataRepositoryManager.class);
            IMetadataRepository created = this.createMetadataRepository(mdrMgr, tempRepositoryLocation);
            IMetadataRepository reloaded = this.loadMetadataRepository(mdrMgr, tempRepositoryLocation);
            IQueryResult iusCreated = created.query(P2Bridge.QUERY_ALL_IUS, (IProgressMonitor)new NullProgressMonitor());
            Iterator itorCreated = iusCreated.iterator();
            IQueryResult iusReloaded = reloaded.query(P2Bridge.QUERY_ALL_IUS, (IProgressMonitor)new NullProgressMonitor());
            Iterator itorReloaded = iusReloaded.iterator();
            while (itorCreated.hasNext()) {
                IInstallableUnit iuReloaded;
                if (!itorReloaded.hasNext()) {
                    throw new Exception("IU counts differ");
                }
                IInstallableUnit iuCreated = (IInstallableUnit)itorCreated.next();
                if (iuCreated.equals((Object)(iuReloaded = (IInstallableUnit)itorReloaded.next()))) continue;
                throw new Exception("IUs differ");
            }
            if (itorReloaded.hasNext()) {
                throw new Exception("IU counts differ");
            }
        }
        finally {
            File repoFile = new File(tempRepositoryLocation, "content.xml");
            repoFile.delete();
            tempRepositoryLocation.delete();
        }
    }

    private IMetadataRepository createMetadataRepository(IMetadataRepositoryManager mdrMgr, File location) throws CoreException {
        MetadataRepositoryImpl mdr = (MetadataRepositoryImpl)P2Factory.eINSTANCE.createMetadataRepository();
        mdr.setLocation(location.toURI());
        mdr.setName("Testing Repository");
        mdr.setProperty("test.property", "test value");
        mdr.setDescription("This is a testing repository");
        mdr.setType(SIMPLE_METADATA_TYPE);
        mdr.setModifiable(true);
        mdr.setProvider("Eclipse CBI");
        mdr.setVersion("1.0.0");
        InstallableUnitImpl iu1 = this.createTestingIU("org.eclipse.cbi.p2repo.testing.iu.01", "1.0.0");
        InstallableUnitImpl iu2 = this.createTestingIU("org.eclipse.cbi.p2repo.testing.iu.02", "1.0.0");
        RequiredCapabilityImpl dep = (RequiredCapabilityImpl)P2Factory.eINSTANCE.createRequiredCapability();
        dep.setName(iu2.getId());
        dep.setNamespace("org.eclipse.equinox.p2.iu");
        dep.setGreedy(true);
        dep.setRange(new VersionRange("1.0.0"));
        iu1.getRequirements().add((Object)dep);
        mdr.getInstallableUnits().add((Object)iu1);
        mdr.getInstallableUnits().add((Object)iu2);
        try {
            P2Bridge.exportFromModel((IMetadataRepositoryManager)mdrMgr, (IMetadataRepository)mdr, (boolean)true, null);
        }
        catch (OperationCanceledException operationCanceledException) {
            LogUtils.info((String)"Operation canceled.", (Object[])new Object[0]);
        }
        return mdr;
    }

    private InstallableUnitImpl createTestingIU(String name, String version) {
        InstallableUnitImpl iu = (InstallableUnitImpl)P2Factory.eINSTANCE.createInstallableUnit();
        iu.setId(name);
        iu.setVersion(Version.create((String)version));
        return iu;
    }

    private IMetadataRepository loadMetadataRepository(IMetadataRepositoryManager mdrMgr, File location) throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(URI.createGenericURI((String)"p2aggr", (String)("p2:" + location.toURI()), null), true);
        if (resource.getErrors().size() > 0) {
            throw new Exception(((Resource.Diagnostic)resource.getErrors().get(0)).getMessage());
        }
        for (EObject object : resource.getContents()) {
            Diagnostic diag = Diagnostician.INSTANCE.validate(object);
            Iterator iterator = diag.getChildren().iterator();
            if (!iterator.hasNext()) continue;
            Diagnostic childDiag = (Diagnostic)iterator.next();
            throw new Exception(childDiag.getMessage());
        }
        return (IMetadataRepository)resource.getContents().get(0);
    }
}

