/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.readers;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.text.ParseException;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titan.log.viewer.models.LogRecordIndex;
import org.eclipse.titan.log.viewer.parsers.RecordParser;
import org.eclipse.titan.log.viewer.parsers.data.LogRecord;

public class SequentialLogFileReader
implements Closeable {
    private File logFile;
    private DataInputStream inputStream;
    private LogRecordIndex[] logRecordIndexes;
    private RecordParser recordParser;
    private int currentRecord = -1;

    public SequentialLogFileReader(URI fileURI, LogRecordIndex[] logRecordIndexes) throws IOException {
        if (logRecordIndexes == null || logRecordIndexes.length == 0) {
            throw new IOException("Empty log record index!");
        }
        this.logRecordIndexes = logRecordIndexes;
        this.logFile = new File(fileURI);
        this.inputStream = new DataInputStream(new FileInputStream(this.logFile));
        this.recordParser = new RecordParser();
        this.currentRecord = -1;
    }

    public int size() {
        return this.logRecordIndexes.length;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.inputStream);
    }

    private String readRecord() throws IOException {
        int nextLen = this.logRecordIndexes[this.currentRecord].getRecordLength();
        byte[] buffer = new byte[nextLen];
        this.inputStream.read(buffer);
        String result = new String(buffer);
        return result.trim();
    }

    public boolean hasNext() {
        return this.currentRecord < this.logRecordIndexes.length - 1;
    }

    public LogRecord getNext() throws ParseException, IOException {
        if (!this.hasNext()) {
            return null;
        }
        ++this.currentRecord;
        LogRecord result = this.recordParser.parse(this.readRecord());
        result.setRecordOffset(this.logRecordIndexes[this.currentRecord].getFileOffset());
        result.setRecordLength(this.logRecordIndexes[this.currentRecord].getRecordLength());
        result.setRecordNumber(this.logRecordIndexes[this.currentRecord].getRecordNumber());
        return result;
    }
}

