/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core.cfgparser;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public final class IOUtils {
    private IOUtils() {
    }

    public static void writeStringToFile(File file, String data) throws IOException {
        BufferedWriter outStream = null;
        try {
            outStream = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            outStream.write(data);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outStream);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)outStream);
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Closeable ... closeableArr) {
        for (Closeable closeable : closeableArr) {
            IOUtils.closeQuietly(closeable);
        }
    }

    public static String inputStreamToString(InputStream input) throws IOException {
        int n;
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        StringBuilder content = new StringBuilder();
        char[] buffer = new char[1024];
        while ((n = reader.read(buffer)) != -1) {
            content.append(buffer, 0, n);
        }
        return content.toString();
    }
}

