/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.function;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Timer;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.refactoring.function.ArgumentPassingType;

class Param {
    private static final String FUNCTION_TEXT_PARAM_TYPE_SEPARATOR = " ";
    private static final String FUNCTION_TEXT_PARAM_TEMPLATE = "template";
    private static final String FUNCTION_TEXT_PARAM_TIMER = "timer";
    private static final String FUNCTION_TEXT_PARAM_COMMA = ", ";
    private Definition def;
    private StringBuilder name;
    private IType type;
    private ArgumentPassingType passingType;
    private boolean declaredInside;
    private List<ISubReference> refs = new ArrayList<ISubReference>();

    Param() {
    }

    public List<StringBuilder> createParamText(boolean addCommaBefore) {
        ArrayList<StringBuilder> ret = new ArrayList<StringBuilder>();
        if (this.passingType == ArgumentPassingType.NONE) {
            return ret;
        }
        if (addCommaBefore) {
            ret.add(new StringBuilder(FUNCTION_TEXT_PARAM_COMMA));
        }
        if (this.def instanceof Def_Timer) {
            ret.add(new StringBuilder(FUNCTION_TEXT_PARAM_TIMER));
            ret.add(new StringBuilder(FUNCTION_TEXT_PARAM_TYPE_SEPARATOR));
        } else {
            ret.add(new StringBuilder(this.passingType.toString()));
            ret.add(new StringBuilder(FUNCTION_TEXT_PARAM_TYPE_SEPARATOR));
            if (this.def instanceof Def_Var_Template) {
                ret.add(new StringBuilder(FUNCTION_TEXT_PARAM_TEMPLATE));
                ret.add(new StringBuilder(FUNCTION_TEXT_PARAM_TYPE_SEPARATOR));
            }
            ret.add(new StringBuilder(Param.getShortTypename(this.type)));
            ret.add(new StringBuilder(FUNCTION_TEXT_PARAM_TYPE_SEPARATOR));
        }
        ret.add(this.name);
        return ret;
    }

    public List<StringBuilder> createParamCallText(boolean addCommaBefore) {
        ArrayList<StringBuilder> ret = new ArrayList<StringBuilder>();
        if (this.passingType == ArgumentPassingType.NONE) {
            return ret;
        }
        if (addCommaBefore) {
            ret.add(new StringBuilder(FUNCTION_TEXT_PARAM_COMMA));
        }
        ret.add(new StringBuilder(this.def.getIdentifier().toString()));
        return ret;
    }

    public String createDebugInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("Param {");
        sb.append("\n    def: ").append((Object)(this.def == null ? "null" : this.def.getIdentifier()));
        sb.append("\n    name: ").append((CharSequence)this.name);
        sb.append("\n    type: ").append(this.type == null ? "null" : this.type.getTypename());
        sb.append("\n    passing: ").append((Object)this.passingType);
        sb.append("\n    declaredInside: ").append(this.declaredInside);
        sb.append("\n    ").append(this.refs.size()).append(" references inside");
        sb.append("\n}");
        return sb.toString();
    }

    public ArgumentPassingType getPassingType() {
        return this.passingType;
    }

    public StringBuilder getName() {
        return this.name;
    }

    public String getTypeName() {
        return Param.getShortTypename(this.type);
    }

    public boolean isDeclaredInside() {
        return this.declaredInside;
    }

    public Definition getDef() {
        return this.def;
    }

    public List<ISubReference> getRefs() {
        return this.refs;
    }

    public void setPassingType(ArgumentPassingType passingType) {
        this.passingType = passingType;
    }

    public void setName(String name) {
        if (this.name == null) {
            this.name = new StringBuilder(name);
        } else {
            this.name.setLength(0);
            this.name.append(name);
        }
    }

    public void setDeclaredInside(boolean declaredInside) {
        this.declaredInside = declaredInside;
    }

    public void setDef(Definition def) {
        this.def = def;
        this.type = this.def.getType(CompilationTimeStamp.getBaseTimestamp());
    }

    public void setRefs(List<ISubReference> refs) {
        this.refs = refs;
    }

    public static String getShortTypename(IType type) {
        if (type == null) {
            return "null";
        }
        String tname = type.getTypename();
        if (tname == null) {
            return "null";
        }
        int ind = tname.lastIndexOf(46);
        return ind == -1 || ind >= tname.length() ? tname : tname.substring(ind + 1);
    }

    public boolean equals(Object arg0) {
        if (arg0 == this) {
            return true;
        }
        if (!(arg0 instanceof Param)) {
            return false;
        }
        Param o = (Param)arg0;
        return this.def.equals(o.def);
    }

    public int hashCode() {
        return this.def.hashCode();
    }
}

