/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.parsers;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ModuleImportation;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titan.designer.parsers.ProjectStructureDataCollector;

public final class GlobalProjectStructureTracker {
    private static Map<IProject, ProjectStructureDataCollector> savedInformations = new HashMap<IProject, ProjectStructureDataCollector>();
    private static Map<IProject, ProjectStructureDataCollector> dynamicInformations = new HashMap<IProject, ProjectStructureDataCollector>();
    private static Map<IProject, Boolean> dependencyChanges = new HashMap<IProject, Boolean>();

    private GlobalProjectStructureTracker() {
    }

    public static void projectChanged(IProject project) {
        if (project == null) {
            return;
        }
        dependencyChanges.remove(project);
        if (!dynamicInformations.containsKey(project)) {
            return;
        }
        ProjectStructureDataCollector dynamicCollector = dynamicInformations.get(project);
        ProjectStructureDataCollector savedCollector = savedInformations.get(project);
        savedInformations.put(project, dynamicCollector);
        dynamicInformations.remove(project);
        if (dynamicCollector == null || savedCollector == null) {
            dependencyChanges.put(project, Boolean.TRUE);
            return;
        }
        if (savedCollector.importations.size() != dynamicCollector.importations.size()) {
            dependencyChanges.put(project, Boolean.TRUE);
            return;
        }
        for (String from : savedCollector.importations.keySet()) {
            if (!dynamicCollector.importations.containsKey(from)) {
                dependencyChanges.put(project, Boolean.TRUE);
                return;
            }
            List<String> savedImports = savedCollector.importations.get(from);
            List<String> dynamicimports = dynamicCollector.importations.get(from);
            if (savedImports.size() != dynamicimports.size()) {
                dependencyChanges.put(project, Boolean.TRUE);
                return;
            }
            for (int i = 0; i < savedImports.size(); ++i) {
                if (savedImports.get(i).equals(dynamicimports.get(i))) continue;
                dependencyChanges.put(project, Boolean.TRUE);
                return;
            }
        }
        dependencyChanges.put(project, Boolean.FALSE);
    }

    public static void saveFile(IFile file) {
        if (file == null) {
            return;
        }
        IProject project = file.getProject();
        GlobalProjectStructureTracker.projectChanged(project);
    }

    private static ProjectStructureDataCollector getDataCollector(IProject project) {
        if (dynamicInformations.containsKey(project)) {
            return dynamicInformations.get(project);
        }
        ProjectStructureDataCollector collector = new ProjectStructureDataCollector();
        dynamicInformations.put(project, collector);
        return collector;
    }

    static void updateData(IProject project) {
        final ProjectStructureDataCollector collector = GlobalProjectStructureTracker.getDataCollector(project);
        ProjectSourceParser parser = GlobalParser.getProjectSourceParser(project);
        Collection<Module> modules = parser.getModules();
        for (Module module : modules) {
            final Identifier moduleID = module.getIdentifier();
            collector.addKnownModule(moduleID);
            module.accept(new ASTVisitor(){

                @Override
                public int visit(IVisitableNode node) {
                    if (node instanceof ModuleImportation) {
                        ModuleImportation mod = (ModuleImportation)node;
                        collector.addImportation(moduleID, mod.getIdentifier());
                        return 1;
                    }
                    if (node instanceof Assignment) {
                        return 1;
                    }
                    return 3;
                }
            });
        }
    }

    public static ProjectStructureDataCollector getSavedDataCollector(IProject project) {
        if (savedInformations.containsKey(project)) {
            return savedInformations.get(project);
        }
        return null;
    }

    public static boolean dependencyChanged(IProject project) {
        if (dependencyChanges.containsKey(project)) {
            Boolean temp = dependencyChanges.get(project);
            return temp;
        }
        return true;
    }
}

