/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.parsers;

public final class CompilationTimeStamp {
    private static long compilationCounter = 0L;
    private static final CompilationTimeStamp BASE_TIMESTAMP = new CompilationTimeStamp(0L);
    private final long internalCompilationTimestamp;

    private CompilationTimeStamp(long compilationTimestamp) {
        this.internalCompilationTimestamp = compilationTimestamp;
    }

    public static CompilationTimeStamp getNewCompilationCounter() {
        if (++compilationCounter == Long.MAX_VALUE) {
            compilationCounter = 0L;
        }
        return new CompilationTimeStamp(compilationCounter);
    }

    public static CompilationTimeStamp getBaseTimestamp() {
        return BASE_TIMESTAMP;
    }

    public boolean isLess(CompilationTimeStamp other) {
        if (other == null) {
            return false;
        }
        return this.internalCompilationTimestamp < other.internalCompilationTimestamp;
    }

    public String toString() {
        return "timestamp " + this.internalCompilationTimestamp;
    }
}

