/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.core.ProjectBasedBuilder;

public final class OutputAnalyzer {
    private Map<String, IFile> files;
    private final HashMap<IResource, IDocument> documentMap;
    private final List<IPath> filesOpened;
    private IProject project;
    private boolean processedErrorMessages;
    private int externalErrorCode = 0;
    static final Pattern BASE_TITAN_ERROR_PATTERN = Pattern.compile("[ ]*(.+):(.+):[ ]+(error|warning|note):[ ]+(.+)");
    private final Matcher baseTITANErrorMatcher = BASE_TITAN_ERROR_PATTERN.matcher("");
    static final Pattern LOCATION_FORMAT_PATTERN_1 = Pattern.compile("(\\d+)");
    private final Matcher locationFormatMatcher1 = LOCATION_FORMAT_PATTERN_1.matcher("");
    static final Pattern LOCATION_FORMAT_PATTERN_2 = Pattern.compile("(\\d+)\\.(\\d+)\\-(\\d+)\\.(\\d+)");
    private final Matcher locationFormatMatcher2 = LOCATION_FORMAT_PATTERN_2.matcher("");
    static final Pattern LOCATION_FORMAT_PATTERN_3 = Pattern.compile("(\\d+)\\-(\\d+)");
    private final Matcher locationFormatMatcher3 = LOCATION_FORMAT_PATTERN_3.matcher("");
    static final Pattern LOCATION_FORMAT_PATTERN_4 = Pattern.compile("(\\d+)\\.(\\d+)\\-(\\d+)");
    private final Matcher locationFormatMatcher4 = LOCATION_FORMAT_PATTERN_4.matcher("");
    static final Pattern LOCATION_FORMAT_PATTERN_5 = Pattern.compile("(\\d+)\\.(\\d+)");
    private final Matcher locationFormatMatcher5 = LOCATION_FORMAT_PATTERN_5.matcher("");
    static final Pattern LOCATION_FORMAT_PATTERN_6 = Pattern.compile("<unknown>");
    private final Matcher locationFormatMatcher6 = LOCATION_FORMAT_PATTERN_6.matcher("");
    static final Pattern BASE_GCC_ERROR_PATTERN_1 = Pattern.compile("[ ]*(.+):(\\d+):(\\d+):[ ]+(error|warning):[ ]+(.+)");
    private final Matcher baseGCCErrorMatcher1 = BASE_GCC_ERROR_PATTERN_1.matcher("");
    static final Pattern BASE_GCC_ERROR_PATTERN_2 = Pattern.compile("[ ]*(.+):(\\d+):(\\d+):[ ]+(.+)");
    private final Matcher baseGCCErrorMatcher2 = BASE_GCC_ERROR_PATTERN_2.matcher("");
    static final Pattern BASE_LINKER_ERROR_PATTERN_1 = Pattern.compile("^collect2:[ ]+error:[ ]+ld[ ]+returned[ ]+([1-9])[ ]+exit.*");
    private final Matcher baseLinkerErrorMatcher1 = BASE_LINKER_ERROR_PATTERN_1.matcher("");
    private static final String ERROR = "error";
    private static final String WARNING = "warning";

    public OutputAnalyzer(Map<String, IFile> files, IProject project) {
        this.files = files;
        this.project = project;
        this.documentMap = new HashMap();
        this.filesOpened = new ArrayList<IPath>();
        this.processedErrorMessages = false;
    }

    public boolean hasProcessedErrorMessages() {
        return this.processedErrorMessages;
    }

    public int getExternalErrorCode() {
        return this.externalErrorCode;
    }

    public void dispose() {
        this.documentMap.clear();
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        for (IPath path : this.filesOpened) {
            try {
                manager.disconnect(path, LocationKind.IFILE, null);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
        this.filesOpened.clear();
        this.files = null;
        this.project = null;
    }

    public boolean parseTitanErrors(String line) {
        if (this.baseTITANErrorMatcher.reset(line).matches()) {
            String filename = this.baseTITANErrorMatcher.group(1);
            String location = this.baseTITANErrorMatcher.group(2);
            String type = this.baseTITANErrorMatcher.group(3);
            String message = this.baseTITANErrorMatcher.group(4);
            if (this.locationFormatMatcher1.reset(location).matches()) {
                return this.addTITANMarker(filename, Integer.parseInt(this.locationFormatMatcher1.group(1)), -1, Integer.parseInt(this.locationFormatMatcher1.group(1)), -1, type, message);
            }
            if (this.locationFormatMatcher2.reset(location).matches()) {
                return this.addTITANMarker(filename, Integer.parseInt(this.locationFormatMatcher2.group(1)), Integer.parseInt(this.locationFormatMatcher2.group(2)), Integer.parseInt(this.locationFormatMatcher2.group(3)), Integer.parseInt(this.locationFormatMatcher2.group(4)), type, message);
            }
            if (this.locationFormatMatcher3.reset(location).matches()) {
                return this.addTITANMarker(filename, Integer.parseInt(this.locationFormatMatcher3.group(1)), 0, Integer.parseInt(this.locationFormatMatcher3.group(2)) + 1, 0, type, message);
            }
            if (this.locationFormatMatcher4.reset(location).matches()) {
                return this.addTITANMarker(filename, Integer.parseInt(this.locationFormatMatcher4.group(1)), Integer.parseInt(this.locationFormatMatcher4.group(2)), Integer.parseInt(this.locationFormatMatcher4.group(1)), Integer.parseInt(this.locationFormatMatcher4.group(3)), type, message);
            }
            if (this.locationFormatMatcher5.reset(location).matches()) {
                return this.addTITANMarker(filename, Integer.parseInt(this.locationFormatMatcher5.group(1)), Integer.parseInt(this.locationFormatMatcher5.group(2)), Integer.parseInt(this.locationFormatMatcher5.group(1)), Integer.parseInt(this.locationFormatMatcher5.group(2)) + 1, type, message);
            }
            if (this.locationFormatMatcher6.reset(location).matches()) {
                return this.addTITANMarker(filename, 0, -1, 0, -1, type, message);
            }
        } else {
            if (this.baseGCCErrorMatcher1.reset(line).matches()) {
                return this.addTITANMarker(this.baseGCCErrorMatcher1.group(1), Integer.parseInt(this.baseGCCErrorMatcher1.group(2)), Integer.parseInt(this.baseGCCErrorMatcher1.group(3)), Integer.parseInt(this.baseGCCErrorMatcher1.group(2)), Integer.parseInt(this.baseGCCErrorMatcher1.group(3)) + 1, this.baseGCCErrorMatcher1.group(4), this.baseGCCErrorMatcher1.group(5));
            }
            if (this.baseGCCErrorMatcher2.reset(line).matches()) {
                return this.addTITANMarker(this.baseGCCErrorMatcher2.group(1), Integer.parseInt(this.baseGCCErrorMatcher2.group(2)), Integer.parseInt(this.baseGCCErrorMatcher2.group(3)), Integer.parseInt(this.baseGCCErrorMatcher2.group(2)), Integer.parseInt(this.baseGCCErrorMatcher2.group(3)) + 1, WARNING, this.baseGCCErrorMatcher2.group(4));
            }
            if (this.baseLinkerErrorMatcher1.reset(line).matches()) {
                this.processedErrorMessages = true;
                this.externalErrorCode = Integer.parseInt(this.baseLinkerErrorMatcher1.group(1));
                return true;
            }
        }
        return false;
    }

    private boolean addTITANMarker(String fileName, int startLineNumber, int startOffset, int endLineNumber, int endOffset, String type, String message) {
        IResource resource = null;
        if (this.files.containsKey(fileName)) {
            resource = (IResource)this.files.get(fileName);
        } else {
            URI workingDirUri;
            boolean found = false;
            Path filePath = new Path(fileName);
            String lastSegment = filePath.lastSegment();
            if (this.files.containsKey(lastSegment)) {
                resource = (IResource)this.files.get(lastSegment);
                found = true;
            }
            if (!found) {
                for (IFile file2 : this.files.values()) {
                    IPath path2 = file2.getProject().getLocation().append(fileName);
                    String temp = path2.toOSString();
                    if (!this.files.containsKey(temp)) continue;
                    resource = (IResource)this.files.get(temp);
                    found = true;
                    break;
                }
            }
            if (!found) {
                for (IFile file2 : this.files.values()) {
                    IPath path2;
                    String temp;
                    IPath workingDir = ProjectBasedBuilder.getProjectBasedBuilder(file2.getProject()).getWorkingDirectoryPath(true);
                    if (workingDir == null || !this.files.containsKey(temp = (path2 = workingDir.append(fileName)).toOSString())) continue;
                    resource = (IResource)this.files.get(temp);
                    found = true;
                    break;
                }
            }
            if (!found && (workingDirUri = ProjectBasedBuilder.getProjectBasedBuilder(this.project).getWorkingDirectoryURI(true)) != null) {
                URI uri2 = URIUtil.append((URI)workingDirUri, (String)fileName);
                IWorkspaceRoot wroot = ResourcesPlugin.getWorkspace().getRoot();
                IFile[] results = wroot.findFilesForLocationURI(uri2);
                if (results != null && results.length > 0) {
                    resource = results[0];
                    found = true;
                }
            }
        }
        Location location = null;
        if (resource == null || !resource.isAccessible()) {
            if (this.project != null && this.project.isAccessible()) {
                location = new Location((IResource)this.project);
                if (ERROR.equals(type)) {
                    location.reportExternalProblem(message.trim(), 2, "org.eclipse.titan.designer.compilerErrorMarker");
                } else {
                    location.reportExternalProblem(message.trim(), 1, "org.eclipse.titan.designer.compilerWarningMarker");
                }
                this.processedErrorMessages = true;
                return true;
            }
            return false;
        }
        try {
            if (startLineNumber > 0 && startOffset != -1 && endOffset != -1) {
                IDocument document = null;
                if (this.documentMap.containsKey(resource)) {
                    document = this.documentMap.get(resource);
                } else {
                    ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                    IPath fullPath = resource.getFullPath();
                    if (manager != null) {
                        manager.connect(fullPath, LocationKind.IFILE, null);
                        ITextFileBuffer buffer = manager.getTextFileBuffer(fullPath, LocationKind.IFILE);
                        document = buffer.getDocument();
                        this.documentMap.put(resource, document);
                        this.filesOpened.add(fullPath);
                    }
                }
                try {
                    if (document != null && endLineNumber < document.getNumberOfLines() && document.getLineLength(startLineNumber - 1) > startOffset && document.getLineLength(endLineNumber - 1) >= endOffset) {
                        location = new Location(resource, startLineNumber, document.getLineOffset(startLineNumber - 1) + startOffset - 1, document.getLineOffset(endLineNumber - 1) + endOffset);
                    }
                }
                catch (BadLocationException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                }
            }
            if (location == null) {
                location = new Location(resource, startLineNumber);
            }
            if (ERROR.equals(type)) {
                location.reportExternalProblem(message, 2, "org.eclipse.titan.designer.compilerErrorMarker");
            } else {
                location.reportExternalProblem(message, 1, "org.eclipse.titan.designer.compilerWarningMarker");
            }
            this.processedErrorMessages = true;
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        return true;
    }
}

