/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.executors.java_mctr;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.core.groups.GroupLaunchConfigurationDelegate;
import org.eclipse.debug.internal.core.groups.GroupLaunchElement;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.executor.executors.LaunchConfigurationUtil;

public final class LinkedLaunchConfigurationChangeListener
implements ILaunchConfigurationListener {
    public LinkedLaunchConfigurationChangeListener() {
        LaunchConfigurationUtil.getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)this);
    }

    public void deregister() {
        LaunchConfigurationUtil.getLaunchManager().removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        ILaunchConfiguration original = LaunchConfigurationUtil.getLaunchManager().getMovedFrom(configuration);
        ILaunchConfigurationType type = null;
        try {
            type = configuration.getType();
            if (!this.checkType(type)) {
                return;
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return;
        }
        ILaunchConfigurationType javaMtcrType = LaunchConfigurationUtil.getJavaMctrLaunchConfigurationType();
        if (javaMtcrType == null) {
            ErrorReporter.logError((String)"Cannot find Titan Native Java launch configuration type");
            return;
        }
        if (original == null) {
            if (type != LaunchConfigurationUtil.getJavaAppLaunchConfigurationType()) {
                return;
            }
            try {
                for (ILaunchConfiguration config : LaunchConfigurationUtil.getLaunchManager().getLaunchConfigurations(javaMtcrType)) {
                    if (!this.equalsProject(config, configuration)) continue;
                    String linkedJavaAppConfigName = LaunchConfigurationUtil.getLinkedJavaAppLaunchConfigurationName(config);
                    String linkedGroupConfigName = LaunchConfigurationUtil.getLinkedGroupLaunchConfigurationName(config);
                    if (linkedJavaAppConfigName.isEmpty() || linkedGroupConfigName.isEmpty()) {
                        return;
                    }
                    ILaunchConfiguration groupConfig = LaunchConfigurationUtil.findGroupLaunchConfigurationByName(linkedGroupConfigName);
                    if (groupConfig == null) {
                        return;
                    }
                    List configList = GroupLaunchConfigurationDelegate.createLaunchElements((ILaunchConfiguration)groupConfig);
                    if (configList.size() < 2 && !((GroupLaunchElement)configList.get((int)0)).name.equals(config.getName())) {
                        ErrorReporter.logError((String)("Erroneous linking from: " + config.getName() + " to " + groupConfig.getName()));
                        return;
                    }
                    if (((GroupLaunchElement)configList.get((int)1)).name.equals(linkedJavaAppConfigName)) continue;
                    List<String> linkedList = LaunchConfigurationUtil.getLinkedLaunchConfigurations(config);
                    linkedList.set(0, configuration.getName());
                    ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                    LaunchConfigurationUtil.setLinkedLaunchConfigurations(wc, linkedList);
                    wc.doSave();
                }
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        } else {
            try {
                for (ILaunchConfiguration config : LaunchConfigurationUtil.getLaunchManager().getLaunchConfigurations(javaMtcrType)) {
                    boolean updated = false;
                    List<String> linkedList = LaunchConfigurationUtil.getLinkedLaunchConfigurations(config);
                    for (int i = 0; i < linkedList.size(); ++i) {
                        if (!linkedList.get(i).equals(original.getName())) continue;
                        updated = true;
                        linkedList.set(i, configuration.getName());
                    }
                    if (!updated) continue;
                    ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                    LaunchConfigurationUtil.setLinkedLaunchConfigurations(wc, linkedList);
                    wc.doSave();
                }
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        ILaunchConfigurationType javaMtcrType = LaunchConfigurationUtil.getJavaMctrLaunchConfigurationType();
        if (javaMtcrType == null) {
            ErrorReporter.logError((String)"Cannot find Titan Native Java launch configuration type");
            return;
        }
        try {
            for (ILaunchConfiguration config : LaunchConfigurationUtil.getLaunchManager().getLaunchConfigurations(javaMtcrType)) {
                boolean removed = false;
                List<String> linkedList = LaunchConfigurationUtil.getLinkedLaunchConfigurations(config);
                for (int i = 0; i < linkedList.size(); ++i) {
                    if (!linkedList.get(i).equals(configuration.getName())) continue;
                    linkedList.set(i, "");
                    removed = true;
                    break;
                }
                if (!removed) continue;
                ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                LaunchConfigurationUtil.setLinkedLaunchConfigurations(wc, linkedList);
                wc.doSave();
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    private boolean checkType(ILaunchConfigurationType type) {
        return type != null && (type == LaunchConfigurationUtil.getJavaAppLaunchConfigurationType() || type == LaunchConfigurationUtil.getGroupLaunchConfigurationType());
    }

    private boolean equalsProject(ILaunchConfiguration config1, ILaunchConfiguration config2) throws CoreException {
        if (config1 == null || config2 == null) {
            return false;
        }
        IResource[] resources1 = config1.getMappedResources();
        if (resources1 == null || resources1.length == 0) {
            return false;
        }
        IResource[] resources2 = config2.getMappedResources();
        if (resources2 == null || resources2.length == 0) {
            return false;
        }
        String projectName1 = config1.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        String projectName2 = config2.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        for (IResource resource1 : resources1) {
            for (IResource resource2 : resources2) {
                if (resource1.getType() == 4 && resource2.getType() == 4) {
                    return resource1.equals((Object)resource2);
                }
                if (resource1.getType() == 4 && !projectName2.isEmpty()) {
                    return resource1.getName().equals(projectName2);
                }
                if (resource2.getType() == 4 && !projectName1.isEmpty()) {
                    return resource2.getName().equals(projectName1);
                }
                if (projectName1.isEmpty() || projectName2.isEmpty()) continue;
                return projectName1.equals(projectName2);
            }
        }
        return false;
    }
}

