/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;
import org.eclipse.titanium.preferences.PreferenceConstants;

public class TooManyStatements
extends BaseModuleCodeSmellSpotter {
    private final int reportTooManyStatementsSize = Platform.getPreferencesService().getInt("org.eclipse.titanium", PreferenceConstants.TOO_MANY_STATEMENTS_SIZE, 150, null);
    private static final String TOOMANYSTATEMENTS = "More than {0} statements in a single statementblock: {1}";

    public TooManyStatements() {
        super(CodeSmellType.TOO_MANY_STATEMENTS);
    }

    @Override
    public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        StatementBlock s;
        if (node instanceof StatementBlock && (s = (StatementBlock)node).getSize() > this.reportTooManyStatementsSize) {
            String msg = MessageFormat.format(TOOMANYSTATEMENTS, this.reportTooManyStatementsSize, s.getSize());
            problems.report(s.getLocation(), msg);
        }
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
        ret.add(StatementBlock.class);
        return ret;
    }
}

