/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.titan.designer.AST.Module;

class CycleCheck {
    private final Map<Module, Node> map = new HashMap<Module, Node>();
    List<List<Module>> cycles;

    public CycleCheck(List<Module> modules) {
        for (Module module : modules) {
            this.map.put(module, new Node(module));
        }
        this.cycles = new ArrayList<List<Module>>();
        for (Module module : modules) {
            Node node = this.map.get(module);
            if (node.state != State.WHITE) continue;
            this.dfs(node);
        }
    }

    private void dfs(Node node) {
        node.state = State.GRAY;
        for (Module module : node.module.getImportedModules()) {
            Node child = this.map.get(module);
            if (child == null) continue;
            switch (child.state) {
                case WHITE: {
                    child.parent = node;
                    this.dfs(child);
                    break;
                }
                case GRAY: {
                    this.newCycle(child, node);
                    break;
                }
            }
        }
        node.state = State.BLACK;
    }

    private void newCycle(Node knot, Node node) {
        ArrayList<Module> cycle = new ArrayList<Module>();
        if (knot.module != node.module) {
            Node p = node;
            do {
                cycle.add(0, p.module);
            } while ((p = p.parent) != knot);
        }
        cycle.add(0, knot.module);
        this.cycles.add(cycle);
    }

    static enum State {
        WHITE,
        GRAY,
        BLACK;

    }

    static class Node {
        Module module;
        Node parent;
        State state;

        public Node(Module module) {
            this.module = module;
            this.parent = null;
            this.state = State.WHITE;
        }
    }
}

