/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.nebula.gallery.finder.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.nebula.gallery.finder.SWTNebulaBot;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.results.IntResult;
import org.eclipse.swtbot.swt.finder.results.ListResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.StringResult;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.results.WidgetResult;
import org.eclipse.swtbot.swt.finder.utils.internal.Assert;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWTBotGalleryItem
extends AbstractSWTBot<GalleryItem> {
    private Gallery gallery;

    public SWTBotGalleryItem(final GalleryItem w) throws WidgetNotFoundException {
        super((Widget)w);
        this.gallery = (Gallery)this.syncExec((Result)new WidgetResult<Gallery>(){

            public Gallery run() {
                return w.getParent();
            }
        });
    }

    public String getText() {
        return this.syncExec(new StringResult(){

            public String run() {
                return ((GalleryItem)SWTBotGalleryItem.this.widget).getText();
            }
        });
    }

    public String getText(final int index) {
        return this.syncExec(new StringResult(){

            public String run() {
                return ((GalleryItem)SWTBotGalleryItem.this.widget).getText(index);
            }
        });
    }

    public int getItemCount() {
        return this.syncExec(new IntResult(){

            public Integer run() {
                return ((GalleryItem)SWTBotGalleryItem.this.widget).getItemCount();
            }
        });
    }

    public SWTBotGalleryItem getGalleryItem(final int index) {
        try {
            new SWTNebulaBot().waitUntil((ICondition)new DefaultCondition(){

                public String getFailureMessage() {
                    return "Could not find gallery item for index " + index;
                }

                public boolean test() throws Exception {
                    return SWTBotGalleryItem.this.getItem(index) != null;
                }
            });
        }
        catch (TimeoutException e) {
            throw new WidgetNotFoundException("Timed out waiting for gallery item in index " + index, (Throwable)e);
        }
        return new SWTBotGalleryItem(this.getItem(index));
    }

    protected GalleryItem getItem(final int index) {
        return (GalleryItem)this.syncExec((WidgetResult)new WidgetResult<GalleryItem>(){

            public GalleryItem run() {
                return ((GalleryItem)SWTBotGalleryItem.this.widget).getItem(index);
            }
        });
    }

    public SWTBotGalleryItem getGalleryItem(final String itemText) throws WidgetNotFoundException {
        try {
            new SWTNebulaBot().waitUntil((ICondition)new DefaultCondition(){

                public String getFailureMessage() {
                    return "Could not find node with text " + itemText;
                }

                public boolean test() throws Exception {
                    return SWTBotGalleryItem.this.getItem(itemText) != null;
                }
            });
        }
        catch (TimeoutException e) {
            throw new WidgetNotFoundException("Timed out waiting for gallery item " + itemText, (Throwable)e);
        }
        return new SWTBotGalleryItem(this.getItem(itemText));
    }

    private GalleryItem getItem(final String itemText) {
        return (GalleryItem)this.syncExec((WidgetResult)new WidgetResult<GalleryItem>(){

            public GalleryItem run() {
                GalleryItem[] items = ((GalleryItem)SWTBotGalleryItem.this.widget).getItems();
                int i = 0;
                while (i < items.length) {
                    GalleryItem item = items[i];
                    if (item.getText().equals(itemText)) {
                        return item;
                    }
                    ++i;
                }
                return null;
            }
        });
    }

    public SWTBotGalleryItem getGalleryItem(final String itemText, final int textIndex) throws WidgetNotFoundException {
        try {
            new SWTNebulaBot().waitUntil((ICondition)new DefaultCondition(){

                public String getFailureMessage() {
                    return "Could not find node with text " + itemText;
                }

                public boolean test() throws Exception {
                    return SWTBotGalleryItem.this.getItem(itemText, textIndex) != null;
                }
            });
        }
        catch (TimeoutException e) {
            throw new WidgetNotFoundException("Timed out waiting for gallery item " + itemText, (Throwable)e);
        }
        return new SWTBotGalleryItem(this.getItem(itemText, textIndex));
    }

    private GalleryItem getItem(final String itemText, final int textIndex) {
        return (GalleryItem)this.syncExec((WidgetResult)new WidgetResult<GalleryItem>(){

            public GalleryItem run() {
                GalleryItem[] items = ((GalleryItem)SWTBotGalleryItem.this.widget).getItems();
                int i = 0;
                while (i < items.length) {
                    GalleryItem item = items[i];
                    if (item.getText(textIndex).equals(itemText)) {
                        return item;
                    }
                    ++i;
                }
                return null;
            }
        });
    }

    public SWTBotGalleryItem select() {
        this.assertEnabled();
        this.syncExec(new VoidResult(){

            public void run() {
                SWTBotGalleryItem.this.gallery.setFocus();
                SWTBotGalleryItem.this.gallery.setSelection(new GalleryItem[]{(GalleryItem)SWTBotGalleryItem.this.widget});
            }
        });
        this.notifySelect();
        return this;
    }

    public SWTBotGalleryItem select(final String ... items) {
        List<String> nodes = Arrays.asList(items);
        Assert.isTrue((boolean)this.getNodes().containsAll(nodes));
        this.syncExec(new VoidResult(){

            public void run() {
                ArrayList<GalleryItem> selection = new ArrayList<GalleryItem>();
                String[] stringArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    SWTBotGalleryItem si = SWTBotGalleryItem.this.getGalleryItem(item);
                    selection.add((GalleryItem)si.widget);
                    ++n2;
                }
                SWTBotGalleryItem.this.gallery.setFocus();
                SWTBotGalleryItem.this.gallery.setSelection(selection.toArray(new GalleryItem[selection.size()]));
            }
        });
        this.notifySelect();
        return this;
    }

    public SWTBotGalleryItem select(String item) {
        return this.select(new String[]{item});
    }

    private void notifySelect() {
        this.notifyGallery(6);
        this.notifyGallery(5);
        this.notifyGallery(26);
        this.notifyGallery(15);
        this.notifyGallery(3);
        this.notifyGallery(13);
        this.notifyGallery(4);
        this.notifyGallery(32);
        this.notifyGallery(5);
        this.notifyGallery(7);
        this.notifyGallery(27);
        this.notifyGallery(16);
    }

    private void notifyGallery(int eventType) {
        this.notify(eventType, this.createEvent(), (Widget)this.gallery);
    }

    private List<String> getNodes() {
        return this.syncExec((ListResult)new ListResult<String>(){

            public List<String> run() {
                GalleryItem[] items = ((GalleryItem)SWTBotGalleryItem.this.widget).getItems();
                ArrayList<String> result = new ArrayList<String>(items.length);
                GalleryItem[] galleryItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    GalleryItem item = galleryItemArray[n2];
                    result.add(item.getText());
                    ++n2;
                }
                return result;
            }
        });
    }
}

