/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.inlayhint;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.codemining.AbstractCodeMiningProvider;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.internal.CancellationUtil;
import org.eclipse.lsp4e.operations.inlayhint.LSPLineContentCodeMining;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.InlayHintParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;

public class InlayHintProvider
extends AbstractCodeMiningProvider {
    private @Nullable CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(IDocument document) {
        URI docURI = LSPEclipseUtils.toUri(document);
        if (docURI != null) {
            Position end = new Position(0, 0);
            try {
                end = LSPEclipseUtils.toPosition(document.getLength(), document);
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logWarning("Unable to compute end of document", e);
            }
            Range viewPortRange = new Range(new Position(0, 0), end);
            InlayHintParams param = new InlayHintParams(LSPEclipseUtils.toTextDocumentIdentifier(docURI), viewPortRange);
            List inlayHintResults = Collections.synchronizedList(new ArrayList());
            return ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(ServerCapabilities::getInlayHintProvider)).collectAll((w, ls) -> ((CompletableFuture)ls.getTextDocumentService().inlayHint(param).exceptionally(ex -> {
                if (!(ex instanceof CancellationException) && !CancellationUtil.isRequestCancelledException(ex)) {
                    LanguageServerPlugin.logError(ex);
                }
                return Collections.emptyList();
            })).thenAcceptAsync(inlayHints -> {
                if (inlayHints != null) {
                    inlayHints.stream().filter(Objects::nonNull).map(inlayHint -> this.toCodeMining(document, (LanguageServerWrapper)w, (InlayHint)inlayHint)).filter(Objects::nonNull).forEach(inlayHintResults::add);
                }
            })).thenApplyAsync(theVoid -> inlayHintResults);
        }
        return null;
    }

    private @Nullable LSPLineContentCodeMining toCodeMining(IDocument document, LanguageServerWrapper languageServerWrapper, InlayHint inlayHint) {
        try {
            return new LSPLineContentCodeMining(inlayHint, document, languageServerWrapper, this);
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
            return null;
        }
    }

    public @Nullable CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
        IDocument document = viewer.getDocument();
        return document != null ? this.provideCodeMinings(document) : null;
    }
}

