/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.build;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.build.BuildContext;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.Scanner;
import org.codehaus.plexus.util.io.CachingOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="default")
@Singleton
public class DefaultBuildContext
implements BuildContext {
    private final Logger logger = LoggerFactory.getLogger(DefaultBuildContext.class);
    private static final AbstractLogEnabled DUMMY = null;
    private final Map<String, Object> contextMap = new ConcurrentHashMap<String, Object>();
    private org.sonatype.plexus.build.incremental.BuildContext legacy;

    @Inject
    public DefaultBuildContext(org.sonatype.plexus.build.incremental.BuildContext legacy) {
        this.legacy = legacy;
    }

    @Override
    public boolean hasDelta(String relpath) {
        return this.legacy.hasDelta(relpath);
    }

    @Override
    public boolean hasDelta(File file) {
        return this.legacy.hasDelta(file);
    }

    @Override
    public boolean hasDelta(List<String> relpaths) {
        return this.legacy.hasDelta(relpaths);
    }

    @Override
    public OutputStream newFileOutputStream(File file) throws IOException {
        if (this.isDefaultImplementation()) {
            return new CachingOutputStream(file.toPath());
        }
        return this.legacy.newFileOutputStream(file);
    }

    private boolean isDefaultImplementation() {
        return this.legacy.getClass().equals(org.sonatype.plexus.build.incremental.DefaultBuildContext.class);
    }

    @Override
    public Scanner newScanner(File basedir) {
        return this.legacy.newScanner(basedir);
    }

    @Override
    public void refresh(File file) {
        this.legacy.refresh(file);
    }

    @Override
    public Scanner newDeleteScanner(File basedir) {
        return this.legacy.newDeleteScanner(basedir);
    }

    @Override
    public Scanner newScanner(File basedir, boolean ignoreDelta) {
        return this.legacy.newScanner(basedir, ignoreDelta);
    }

    @Override
    public boolean isIncremental() {
        return this.legacy.isIncremental();
    }

    @Override
    public Object getValue(String key) {
        return this.contextMap.get(key);
    }

    @Override
    public void setValue(String key, Object value) {
        this.contextMap.put(key, value);
    }

    @Override
    public void addError(File file, int line, int column, String message, Throwable cause) {
        this.addMessage(file, line, column, message, 2, cause);
    }

    @Override
    public void addWarning(File file, int line, int column, String message, Throwable cause) {
        this.addMessage(file, line, column, message, 1, cause);
    }

    private String getMessage(File file, int line, int column, String message) {
        return file.getAbsolutePath() + " [" + line + ':' + column + "]: " + message;
    }

    @Override
    public void addMessage(File file, int line, int column, String message, int severity, Throwable cause) {
        if (this.isDefaultImplementation()) {
            switch (severity) {
                case 2: {
                    this.logger.error(this.getMessage(file, line, column, message), cause);
                    return;
                }
                case 1: {
                    this.logger.warn(this.getMessage(file, line, column, message), cause);
                    return;
                }
            }
            this.logger.debug(this.getMessage(file, line, column, message), cause);
            return;
        }
        this.legacy.addMessage(file, line, column, message, severity, cause);
    }

    @Override
    public void removeMessages(File file) {
        if (this.isDefaultImplementation()) {
            return;
        }
        this.legacy.removeMessages(file);
    }

    @Override
    public boolean isUptodate(File target, File source) {
        return this.legacy.isUptodate(target, source);
    }
}

