/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.internal.core.evaluation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.evaluation.types.ModelModuleType;
import org.eclipse.dltk.evaluation.types.UnknownType;
import org.eclipse.dltk.python.internal.core.evaluation.PythonASTFindVisitor;
import org.eclipse.dltk.python.internal.core.evaluation.PythonASTTypeEvaluator;
import org.eclipse.dltk.python.internal.core.evaluation.PythonTypeEvaluatorUtils;
import org.eclipse.dltk.python.parser.ast.expressions.Assignment;
import org.eclipse.dltk.ti.types.IEvaluatedType;

public class PythonTypeEvaluator {
    public static IEvaluatedType evaluateLast(IModelElement modelElement) {
        return PythonTypeEvaluator.evaluate(modelElement);
    }

    public static IEvaluatedType evaluate(IModelElement modelElement) {
        block8: {
            if (PythonTypeEvaluator.isAppropriateElement(modelElement)) {
                try {
                    Iterator i;
                    IModule module = PythonTypeEvaluatorUtils.getElementModule(modelElement);
                    ModuleDeclaration moduleForElement = PythonTypeEvaluatorUtils.parseModuleForElement(modelElement);
                    PythonASTFindVisitor findVisitor = PythonTypeEvaluatorUtils.findElementsByModelElement(moduleForElement, modelElement);
                    Map parents = findVisitor.getParents();
                    List neededDeclarations = PythonTypeEvaluator.filterASTNodes(parents, modelElement, findVisitor);
                    int elementKind = modelElement.getElementType();
                    PythonASTTypeEvaluator astEvaluator = new PythonASTTypeEvaluator(module, moduleForElement, parents);
                    if (elementKind == 9) {
                        int count = 0;
                        IEvaluatedType type = null;
                        for (ASTNode node : neededDeclarations) {
                            if (count > 0) break;
                            type = astEvaluator.evaluateASTNode(node, null);
                            ++count;
                        }
                        if (type != null) {
                            return type;
                        }
                        return UnknownType.INSTANCE;
                    }
                    if (elementKind == 8 && (i = neededDeclarations.iterator()).hasNext()) {
                        ASTNode node = (ASTNode)i.next();
                        return astEvaluator.evaluateASTNode(node, null);
                    }
                    break block8;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return UnknownType.INSTANCE;
                }
            }
            if (modelElement.getElementType() == 5) {
                return new ModelModuleType((IModule)modelElement);
            }
        }
        return UnknownType.INSTANCE;
    }

    public static boolean isAppropriateElement(IModelElement modelElement) {
        return modelElement.getElementType() == 8 || modelElement.getElementType() == 9;
    }

    public static void clearStats() {
    }

    private static List filterASTNodes(Map parents, IModelElement modelElement, PythonASTFindVisitor visitor) throws Exception {
        List elementDeclarations = visitor.getNodes();
        ArrayList<ASTNode> neededDeclarations = new ArrayList<ASTNode>();
        int elementKind = modelElement.getElementType();
        IModelElement parentElement = modelElement;
        if (elementKind == 8) {
            parentElement = modelElement.getParent();
        }
        for (ASTNode node : elementDeclarations) {
            try {
                if (elementKind == 9) {
                    if (!(node instanceof MethodDeclaration) || !PythonTypeEvaluator.filterByModel(parents, parentElement, PythonTypeEvaluatorUtils.getModelLikeNode(parents, node))) continue;
                    neededDeclarations.add(node);
                    continue;
                }
                if (elementKind != 8 || !(node instanceof Assignment) || !PythonTypeEvaluator.filterByModel(parents, parentElement, PythonTypeEvaluatorUtils.getModelLikeNode(parents, node))) continue;
                neededDeclarations.add(node);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return neededDeclarations;
    }

    public static boolean filterByModel(Map parents, IModelElement modelElement, ASTNode node) throws Exception {
        if (node == null || modelElement == null) {
            return false;
        }
        if (modelElement.getElementType() == 9) {
            IMethod iMethod = (IMethod)modelElement;
            if (node instanceof MethodDeclaration) {
                MethodDeclaration method = (MethodDeclaration)node;
                if (!method.getName().equals(iMethod.getElementName())) {
                    return false;
                }
                if (method.getArguments().size() != iMethod.getParameters().length) {
                    return false;
                }
                if (parents.containsKey(node)) {
                    return PythonTypeEvaluator.filterByModel(parents, modelElement.getParent(), PythonTypeEvaluatorUtils.getModelLikeNode(parents, (ASTNode)parents.get(node)));
                }
            }
        } else if (modelElement.getElementType() == 7) {
            IType iClass = (IType)modelElement;
            if (node instanceof TypeDeclaration) {
                TypeDeclaration method = (TypeDeclaration)node;
                if (!method.getName().equals(iClass.getElementName())) {
                    return false;
                }
                if (parents.containsKey(node)) {
                    return PythonTypeEvaluator.filterByModel(parents, modelElement.getParent(), PythonTypeEvaluatorUtils.getModelLikeNode(parents, (ASTNode)parents.get(node)));
                }
            }
        } else if (modelElement.getElementType() == 5) {
            IModule iModule = (IModule)modelElement;
            if (node instanceof ModuleDeclaration) {
                return true;
            }
        }
        return false;
    }

    public static IEvaluatedType evaluateCall(IModelElement modelElement, List callHolder) {
        return PythonTypeEvaluator.evaluate(modelElement);
    }
}

