/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.activestatedebugger;

import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.launching.ExternalDebuggingEngineRunner;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.launching.debug.DbgpConnectionConfig;

public class PythonActiveStateDebuggerRunner
extends ExternalDebuggingEngineRunner {
    public static final String ENGINE_ID = "org.eclipse.dltk.python.activestatedebugger";

    public PythonActiveStateDebuggerRunner(IInterpreterInstall install) {
        super(install);
    }

    protected InterpreterConfig alterConfig(InterpreterConfig config, PreferencesLookupDelegate delegate) {
        IFileHandle debugEnginePath = this.getDebuggingEnginePath(delegate);
        DbgpConnectionConfig dbgpConfig = DbgpConnectionConfig.load((InterpreterConfig)config);
        config.addInterpreterArg("-S");
        config.addInterpreterArg(debugEnginePath.toString());
        config.addInterpreterArg("-d");
        config.addInterpreterArg(String.valueOf(dbgpConfig.getHost()) + ":" + dbgpConfig.getPort());
        config.addInterpreterArg("-k");
        config.addInterpreterArg(dbgpConfig.getSessionId());
        return config;
    }

    protected String getDebuggingEngineId() {
        return ENGINE_ID;
    }

    protected String getDebuggingEnginePreferenceKey() {
        return "activeStateEnginePath";
    }

    protected String getDebuggingEnginePreferenceQualifier() {
        return ENGINE_ID;
    }

    protected String getDebugPreferenceQualifier() {
        return "org.eclipse.dltk.python.debug";
    }

    protected String getLoggingEnabledPreferenceKey() {
        return "enable_logging";
    }

    protected String getLogFileNamePreferenceKey() {
        return "log_file_name";
    }

    protected String getLogFilePathPreferenceKey() {
        return "log_file_path";
    }
}

