/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.corext.refactoring.Checks;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.dltk.internal.ui.editor.ModelTextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public final class RefactoringAvailabilityTester {
    public static IType getDeclaringType(IModelElement element) {
        if (element == null) {
            return null;
        }
        if (!(element instanceof IType)) {
            element = element.getAncestor(7);
        }
        return (IType)element;
    }

    public static IModelElement[] getScriptElements(Object[] elements) {
        ArrayList<IModelElement> result = new ArrayList<IModelElement>();
        int index = 0;
        while (index < elements.length) {
            if (elements[index] instanceof IModelElement) {
                result.add((IModelElement)elements[index]);
            }
            ++index;
        }
        return result.toArray(new IModelElement[result.size()]);
    }

    public static IResource[] getResources(Object[] elements) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        int index = 0;
        while (index < elements.length) {
            if (elements[index] instanceof IResource) {
                result.add((IResource)elements[index]);
            }
            ++index;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public static boolean isRenameElementAvailable(IModelElement element) throws CoreException {
        switch (element.getElementType()) {
            case 2: {
                return RefactoringAvailabilityTester.isRenameAvailable((IScriptProject)element);
            }
            case 3: {
                return RefactoringAvailabilityTester.isRenameAvailable((IProjectFragment)element);
            }
            case 5: {
                return RefactoringAvailabilityTester.isRenameAvailable((ISourceModule)element);
            }
            case 7: {
                return RefactoringAvailabilityTester.isRenameAvailable((IType)element);
            }
            case 9: {
                IMethod method = (IMethod)element;
                if (method.isConstructor()) {
                    return RefactoringAvailabilityTester.isRenameAvailable(method.getDeclaringType());
                }
                return RefactoringAvailabilityTester.isRenameAvailable(method);
            }
            case 8: {
                IField field = (IField)element;
                return RefactoringAvailabilityTester.isRenameFieldAvailable(field);
            }
        }
        return false;
    }

    public static boolean isRenameAvailable(ISourceModule unit) {
        if (unit == null) {
            return false;
        }
        if (!unit.exists()) {
            return false;
        }
        if (!ScriptModelUtil.isPrimary((ISourceModule)unit)) {
            return false;
        }
        return !unit.isReadOnly();
    }

    public static boolean isRenameAvailable(IScriptProject project) throws ModelException {
        if (project == null) {
            return false;
        }
        if (!Checks.isAvailable((IModelElement)project)) {
            return false;
        }
        return project.isConsistent();
    }

    public static boolean isRenameAvailable(IMethod method) throws CoreException {
        if (method == null) {
            return false;
        }
        if (!Checks.isAvailable((IModelElement)method)) {
            return false;
        }
        return !method.isConstructor();
    }

    public static boolean isRenameAvailable(IScriptFolder fragment) throws ModelException {
        if (fragment == null) {
            return false;
        }
        if (!Checks.isAvailable((IModelElement)fragment)) {
            return false;
        }
        return !fragment.isRootFolder();
    }

    public static boolean isRenameAvailable(IProjectFragment root) throws ModelException {
        if (root == null) {
            return false;
        }
        if (!Checks.isAvailable((IModelElement)root)) {
            return false;
        }
        if (root.isArchive()) {
            return false;
        }
        if (root.isExternal()) {
            return false;
        }
        if (!root.isConsistent()) {
            return false;
        }
        return !(root.getResource() instanceof IProject);
    }

    public static boolean isRenameAvailable(IResource resource) {
        if (resource == null) {
            return false;
        }
        if (!resource.exists()) {
            return false;
        }
        return resource.isAccessible();
    }

    public static boolean isRenameAvailable(IType type) throws ModelException {
        if (type == null) {
            return false;
        }
        return Checks.isAvailable((IModelElement)type);
    }

    public static boolean isRenameFieldAvailable(IField field) throws ModelException {
        return Checks.isAvailable((IModelElement)field);
    }

    public static boolean isReplaceInvocationsAvailable(IMethod method) throws ModelException {
        if (method == null) {
            return false;
        }
        if (!method.exists()) {
            return false;
        }
        return !method.isConstructor();
    }

    public static boolean isDeleteAvailable(IModelElement element) throws ModelException {
        IProjectFragment root;
        if (!element.exists()) {
            return false;
        }
        if (element instanceof IScriptModel || element instanceof IScriptProject) {
            return false;
        }
        if (element.getParent() != null && element.getParent().isReadOnly()) {
            return false;
        }
        if (element instanceof IProjectFragment && ((root = (IProjectFragment)element).isExternal() || Checks.isBuildpathDelete(root))) {
            return false;
        }
        if (element.getResource() == null && !RefactoringAvailabilityTester.isWorkingCopyElement(element)) {
            return false;
        }
        return !ReorgUtils.isDeletedFromEditor(element);
    }

    public static boolean isDeleteAvailable(IResource resource) {
        if (!resource.exists() || resource.isPhantom()) {
            return false;
        }
        return resource.getType() != 8 && resource.getType() != 4;
    }

    public static boolean isDeleteAvailable(IStructuredSelection selection) throws ModelException {
        if (!selection.isEmpty()) {
            return RefactoringAvailabilityTester.isDeleteAvailable(selection.toArray());
        }
        return false;
    }

    public static boolean isDeleteAvailable(Object[] objects) throws ModelException {
        if (objects.length != 0) {
            IModelElement[] elements;
            IResource[] resources = RefactoringAvailabilityTester.getResources(objects);
            if (objects.length != resources.length + (elements = RefactoringAvailabilityTester.getScriptElements(objects)).length) {
                return false;
            }
            int index = 0;
            while (index < resources.length) {
                if (!RefactoringAvailabilityTester.isDeleteAvailable(resources[index])) {
                    return false;
                }
                ++index;
            }
            index = 0;
            while (index < elements.length) {
                if (!RefactoringAvailabilityTester.isDeleteAvailable(elements[index])) {
                    return false;
                }
                ++index;
            }
            return true;
        }
        return false;
    }

    public static boolean isWorkingCopyElement(IModelElement element) {
        if (element instanceof ISourceModule) {
            return ((ISourceModule)element).isWorkingCopy();
        }
        if (ReorgUtils.isInsideSourceModule(element)) {
            return ReorgUtils.getSourceModule(element).isWorkingCopy();
        }
        return false;
    }

    private RefactoringAvailabilityTester() {
    }

    public static boolean isMoveAvailable(IResource[] resources, IModelElement[] elements) throws ModelException {
        if (elements != null) {
            int index = 0;
            while (index < elements.length) {
                IModelElement element = elements[index];
                if (element instanceof IType) {
                    return false;
                }
                if (element instanceof IField) {
                    return false;
                }
                ++index;
            }
        }
        return ReorgPolicyFactory.createMovePolicy(resources, elements).canEnable();
    }

    public static boolean isMoveAvailable(ModelTextSelection selection) throws ModelException {
        IModelElement element = selection.resolveEnclosingElement();
        if (element == null) {
            return false;
        }
        return RefactoringAvailabilityTester.isMoveAvailable(new IResource[0], new IModelElement[]{element});
    }
}

