/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.preferences;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.compiler.task.TaskTagUtils;
import org.eclipse.dltk.compiler.task.TodoTask;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.dltk.ui.preferences.AbstractOptionsBlock;
import org.eclipse.dltk.ui.preferences.IPreferenceChangeRebuildPrompt;
import org.eclipse.dltk.ui.preferences.PreferenceChangeRebuildPrompt;
import org.eclipse.dltk.ui.preferences.PreferenceKey;
import org.eclipse.dltk.ui.preferences.PreferencesMessages;
import org.eclipse.dltk.ui.preferences.TodoTaskInputDialog;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public abstract class AbstractTodoTaskOptionsBlock
extends AbstractOptionsBlock {
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;
    private ListDialogField fTodoTasksList;
    private Button fCaseSensitiveCheckbox;

    public AbstractTodoTaskOptionsBlock(IStatusChangeListener context, IProject project, PreferenceKey[] allKeys, IWorkbenchPreferenceContainer container) {
        super(context, project, allKeys, container);
    }

    @Override
    public void performDefaults() {
        super.performDefaults();
        this.initialize();
    }

    public static PreferenceKey createCaseSensitiveKey(String pluginId) {
        return new PreferenceKey(pluginId, "org.eclipse.dltk.coretasks.case_sensitive");
    }

    public static PreferenceKey createEnabledKey(String pluginId) {
        return new PreferenceKey(pluginId, "org.eclipse.dltk.coretasks.enabled");
    }

    public static PreferenceKey createTagKey(String pluginId) {
        return new PreferenceKey(pluginId, "org.eclipse.dltk.coretasks.tags");
    }

    @Override
    protected Control createOptionsBlock(Composite parent) {
        TaskTagAdapter adapter = new TaskTagAdapter();
        String[] buttons = new String[]{PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_add_button, PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_edit_button, PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_remove_button};
        this.fTodoTasksList = new ListDialogField(adapter, buttons, (ILabelProvider)new TodoTaskLabelProvider());
        this.fTodoTasksList.setDialogFieldListener(adapter);
        this.fTodoTasksList.setRemoveButtonIndex(2);
        String[] columnsHeaders = new String[]{PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_name_column, PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_priority_column};
        this.fTodoTasksList.setTableColumns(new ListDialogField.ColumnsDescription(columnsHeaders, true));
        this.fTodoTasksList.setViewerSorter(new TodoTaskSorter());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        PixelConverter conv = new PixelConverter((Control)parent);
        Composite markersComposite = new Composite(parent, 0);
        markersComposite.setLayout((Layout)layout);
        markersComposite.setFont(parent.getFont());
        Button enableCheckbox = SWTFactory.createCheckButton(markersComposite, PreferencesMessages.TodoTaskConfigurationBlock_enableTaskTags, null, false, 2);
        this.bindControl(enableCheckbox, this.getEnabledKey(), null);
        this.fCaseSensitiveCheckbox = SWTFactory.createCheckButton(markersComposite, PreferencesMessages.TodoTaskConfigurationBlock_casesensitive_label, null, false, 2);
        this.bindControl(this.fCaseSensitiveCheckbox, this.getCaseSensitiveKey(), null);
        GridData data = new GridData(1808);
        data.widthHint = conv.convertWidthInCharsToPixels(50);
        this.fTodoTasksList.getListControl(markersComposite).setLayoutData((Object)data);
        this.fTodoTasksList.getButtonBox(markersComposite).setLayoutData((Object)new GridData(258));
        enableCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = ((Button)e.widget).getSelection();
                AbstractTodoTaskOptionsBlock.this.updateEnableState(enabled);
            }
        });
        return markersComposite;
    }

    protected abstract PreferenceKey getCaseSensitiveKey();

    protected abstract PreferenceKey getEnabledKey();

    protected abstract PreferenceKey getTags();

    @Override
    protected void initialize() {
        super.initialize();
        String tags = this.getValue(this.getTags());
        this.fTodoTasksList.setElements(TaskTagUtils.decodeTaskTags((String)tags));
        if (this.fTodoTasksList.getSize() > 0) {
            this.fTodoTasksList.selectFirstElement();
        } else {
            this.fTodoTasksList.enableButton(1, false);
        }
    }

    protected void updateEnableState(boolean enabled) {
        this.fTodoTasksList.setEnabled(enabled);
        this.fCaseSensitiveCheckbox.setEnabled(enabled);
    }

    protected final void updateModel(DialogField field) {
        this.setValue(this.getTags(), TaskTagUtils.encodeTaskTags(this.fTodoTasksList.getElements()));
    }

    @Override
    protected IPreferenceChangeRebuildPrompt getPreferenceChangeRebuildPrompt(boolean workspaceSettings, Collection<PreferenceKey> changedOptions) {
        return PreferenceChangeRebuildPrompt.create(workspaceSettings, PreferencesMessages.TodoTaskConfigurationBlock_needsbuild_title, PreferencesMessages.TodoTaskConfigurationBlock_needsbuild_message);
    }

    private void doTodoButtonPressed(int index) {
        TodoTaskInputDialog dialog;
        TodoTask edited = null;
        if (index != 0) {
            edited = (TodoTask)this.fTodoTasksList.getSelectedElements().get(0);
        }
        if ((index == 0 || index == 1) && (dialog = new TodoTaskInputDialog(this.getShell(), edited, this.fTodoTasksList.getElements())).open() == 0) {
            if (edited != null) {
                this.fTodoTasksList.replaceElement(edited, dialog.getResult());
            } else {
                this.fTodoTasksList.addElement(dialog.getResult());
            }
        }
    }

    public class TaskTagAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private boolean canEdit(List<?> selectedElements) {
            return selectedElements.size() == 1;
        }

        @Override
        public void customButtonPressed(ListDialogField field, int index) {
            AbstractTodoTaskOptionsBlock.this.doTodoButtonPressed(index);
        }

        @Override
        public void selectionChanged(ListDialogField field) {
            List selectedElements = field.getSelectedElements();
            field.enableButton(1, this.canEdit(selectedElements));
        }

        @Override
        public void doubleClicked(ListDialogField field) {
            if (this.canEdit(field.getSelectedElements())) {
                AbstractTodoTaskOptionsBlock.this.doTodoButtonPressed(1);
            }
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            AbstractTodoTaskOptionsBlock.this.updateModel(field);
        }
    }

    private static class TodoTaskLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TodoTaskLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TodoTask task = (TodoTask)element;
            if (columnIndex == 0) {
                return task.name;
            }
            if ("HIGH".equals(task.priority)) {
                return PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_high_priority;
            }
            if ("NORMAL".equals(task.priority)) {
                return PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_normal_priority;
            }
            if ("LOW".equals(task.priority)) {
                return PreferencesMessages.TodoTaskConfigurationBlock_markers_tasks_low_priority;
            }
            return "";
        }
    }

    private static class TodoTaskSorter
    extends ViewerSorter {
        private TodoTaskSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.getComparator().compare(((TodoTask)e1).name, ((TodoTask)e2).name);
        }
    }
}

