/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 
 *******************************************************************************/
package org.eclipse.dltk.python.internal.core.evaluation;


public class PythonBuiltIns
{

	static String[] builtinNames = {
		"ArithmeticError",
		"AssertionError",
		"AttributeError",
		"DeprecationWarning",
		"EOFError",
		"Ellipsis",
		"EnvironmentError",
		"Exception",
		"False",
		"FloatingPointError",
		"FutureWarning",
		"IOError",
		"ImportError",
		"IndentationError",
		"IndexError",
		"KeyError",
		"KeyboardInterrupt",
		"LookupError",
		"MemoryError",
		"NameError",
		"None",
		"NotImplemented",
		"NotImplementedError",
		"OSError",
		"OverflowError",
		"OverflowWarning",
		"PendingDeprecationWarning",
		"ReferenceError",
		"RuntimeError",
		"RuntimeWarning",
		"StandardError",
		"StopIteration",
		"SyntaxError",
		"SyntaxWarning",
		"SystemError",
		"SystemExit",
		"TabError",
		"True",
		"TypeError",
		"UnboundLocalError",
		"UnicodeDecodeError",
		"UnicodeEncodeError",
		"UnicodeError",
		"UnicodeTranslateError",
		"UserWarning",
		"ValueError",
		"Warning",
		"WindowsError",
		"ZeroDivisionError",
		"__debug__",
		"__doc__",
		"__import__",
		"__name__",
		"abs",
		"apply",
		"basestring",
		"bool",
		"buffer",
		"callable",
		"chr",
		"classmethod",
		"cmp",
		"coerce",
		"compile",
		"complex",
		"copyright",
		"credits",
		"delattr",
		"dict",
		"dir",
		"diInterpreterod",
		"enumerate",
		"eval",
		"execfile",
		"exit",
		"file",
		"filter",
		"float",
		"frozenset",
		"getattr",
		"globals",
		"hasattr",
		"hash",
		"help",
		"hex",
		"id",
		"input",
		"int",
		"intern",
		"isinstance",
		"issubclass",
		"iter",
		"len",
		"license",
		"list",
		"locals",
		"long",
		"map",
		"max",
		"min",
		"object",
		"oct",
		"open",
		"ord",
		"pow",
		"property",
		"quit",
		"range",
		"raw_input",
		"reduce",
		"reload",
		"repr",
		"reversed",
		"round",
		"set",
		"setattr",
		"slice",
		"sorted",
		"staticmethod",
		"str",
		"sum",
		"super",
		"tuple",
		"type",
		"unichr",
		"unicode",
		"vars",
		"xrange",
		"zip",
		// builtin module names
		"math" ,
		"thread",
		"signal",		
		"posix",
		"errno",
		"zipimport",
		"marshal",
		"sys",
		"exceptions"
	};
	public static boolean isBuiltin(String reference)
	{
		for (int i = 0; i < builtinNames.length; i++) {		
			if( builtinNames[i].equals(reference) ) {
				return true;
			}
		}
		return false;
	}

}
