/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.text;

import java.text.CharacterIterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class DocumentCharacterIterator
implements CharacterIterator,
CharSequence {
    private int fIndex = -1;
    private final IDocument fDocument;
    private final int fFirst;
    private final int fLast;

    private void invariant() {
        Assert.isTrue((this.fIndex >= this.fFirst ? 1 : 0) != 0);
        Assert.isTrue((this.fIndex <= this.fLast ? 1 : 0) != 0);
    }

    public DocumentCharacterIterator(IDocument document) {
        this(document, 0);
    }

    public DocumentCharacterIterator(IDocument document, int first) throws IllegalArgumentException {
        this(document, first, document.getLength());
    }

    public DocumentCharacterIterator(IDocument document, int first, int last) throws IllegalArgumentException {
        if (document == null) {
            throw new NullPointerException();
        }
        if (first < 0 || first > last) {
            throw new IllegalArgumentException();
        }
        if (last > document.getLength()) {
            throw new IllegalArgumentException();
        }
        this.fDocument = document;
        this.fFirst = first;
        this.fLast = last;
        this.fIndex = first;
        this.invariant();
    }

    @Override
    public char first() {
        return this.setIndex(this.getBeginIndex());
    }

    @Override
    public char last() {
        if (this.fFirst == this.fLast) {
            return this.setIndex(this.getEndIndex());
        }
        return this.setIndex(this.getEndIndex() - 1);
    }

    @Override
    public char current() {
        if (this.fIndex >= this.fFirst && this.fIndex < this.fLast) {
            try {
                return this.fDocument.getChar(this.fIndex);
            }
            catch (BadLocationException badLocationException) {}
        }
        return '\uffff';
    }

    @Override
    public char next() {
        return this.setIndex(Math.min(this.fIndex + 1, this.getEndIndex()));
    }

    @Override
    public char previous() {
        if (this.fIndex > this.getBeginIndex()) {
            return this.setIndex(this.fIndex - 1);
        }
        return '\uffff';
    }

    @Override
    public char setIndex(int position) {
        if (position < this.getBeginIndex() || position > this.getEndIndex()) {
            throw new IllegalArgumentException();
        }
        this.fIndex = position;
        this.invariant();
        return this.current();
    }

    @Override
    public int getBeginIndex() {
        return this.fFirst;
    }

    @Override
    public int getEndIndex() {
        return this.fLast;
    }

    @Override
    public int getIndex() {
        return this.fIndex;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public int length() {
        return this.getEndIndex() - this.getBeginIndex();
    }

    @Override
    public char charAt(int index) {
        if (index >= 0 && index < this.length()) {
            try {
                return this.fDocument.getChar(this.getBeginIndex() + index);
            }
            catch (BadLocationException badLocationException) {
                return '\uffff';
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (end < start) {
            throw new IndexOutOfBoundsException();
        }
        if (end > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        return new DocumentCharacterIterator(this.fDocument, this.getBeginIndex() + start, this.getBeginIndex() + end);
    }

    @Override
    public String toString() {
        if (this.fFirst == 0 && this.fLast == this.fDocument.getLength()) {
            return this.fDocument.get();
        }
        try {
            return this.fDocument.get(this.fFirst, this.length());
        }
        catch (BadLocationException badLocationException) {
            throw new IndexOutOfBoundsException();
        }
    }
}

