# Commands covered:  lreplace
#
# This file contains a collection of tests for one or more of the Tcl
# built-in commands.  Sourcing this file into Tcl runs the tests and
# generates output for errors.  No output means no errors were found.
#
# Copyright (c) 1991-1993 The Regents of the University of California.
# Copyright (c) 1994 Sun Microsystems, Inc.
# Copyright (c) 1998-1999 by Scriptics Corporation.
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#
# RCS: @(#) $Id: lreplace.tcl,v 1.1 2006/12/29 09:02:53 fourdman Exp $

if {[lsearch [namespace children] ::tcltest] == -1} {
    package require tcltest
    namespace import -force ::tcltest::*
}

test lreplace-1.1 {lreplace command} {
    lreplace {1 2 3 4 5} 0 0 a
} {a 2 3 4 5}
test lreplace-1.2 {lreplace command} {
    lreplace {1 2 3 4 5} 1 1 a
} {1 a 3 4 5}
test lreplace-1.3 {lreplace command} {
    lreplace {1 2 3 4 5} 2 2 a
} {1 2 a 4 5}
test lreplace-1.4 {lreplace command} {
    lreplace {1 2 3 4 5} 3 3 a
} {1 2 3 a 5}
test lreplace-1.5 {lreplace command} {
    lreplace {1 2 3 4 5} 4 4 a
} {1 2 3 4 a}
test lreplace-1.6 {lreplace command} {
    lreplace {1 2 3 4 5} 4 5 a
} {1 2 3 4 a}
test lreplace-1.7 {lreplace command} {
    lreplace {1 2 3 4 5} -1 -1 a
} {a 1 2 3 4 5}
test lreplace-1.8 {lreplace command} {
    lreplace {1 2 3 4 5} 2 end a b c d
} {1 2 a b c d}
test lreplace-1.9 {lreplace command} {
    lreplace {1 2 3 4 5} 0 3
} {5}
test lreplace-1.10 {lreplace command} {
    lreplace {1 2 3 4 5} 0 4
} {}
test lreplace-1.11 {lreplace command} {
    lreplace {1 2 3 4 5} 0 1
} {3 4 5}
test lreplace-1.12 {lreplace command} {
    lreplace {1 2 3 4 5} 2 3
} {1 2 5}
test lreplace-1.13 {lreplace command} {
    lreplace {1 2 3 4 5} 3 end
} {1 2 3}
test lreplace-1.14 {lreplace command} {
    lreplace {1 2 3 4 5} -1 4 a b c
} {a b c}
test lreplace-1.15 {lreplace command} {
    lreplace {a b "c c" d e f} 3 3
} {a b {c c} e f}
test lreplace-1.16 {lreplace command} {
    lreplace { 1 2 3 4 5} 0 0 a
} {a 2 3 4 5}
test lreplace-1.17 {lreplace command} {
    lreplace {1 2 3 4 "5 6"} 4 4 a
} {1 2 3 4 a}
test lreplace-1.18 {lreplace command} {
    lreplace {1 2 3 4 {5 6}} 4 4 a
} {1 2 3 4 a}
test lreplace-1.19 {lreplace command} {
    lreplace {1 2 3 4} 2 end x y z
} {1 2 x y z}
test lreplace-1.20 {lreplace command} {
    lreplace {1 2 3 4} end end a
} {1 2 3 a}
test lreplace-1.21 {lreplace command} {
    lreplace {1 2 3 4} end 3 a
} {1 2 3 a}
test lreplace-1.22 {lreplace command} {
    lreplace {1 2 3 4} end end
} {1 2 3}
test lreplace-1.23 {lreplace command} {
    lreplace {1 2 3 4} 2 -1 xy
} {1 2 xy 3 4}
test lreplace-1.24 {lreplace command} {
    lreplace {1 2 3 4} end -1 z
} {1 2 3 z 4}
test lreplace-1.25 {lreplace command} {
    concat \"[lreplace {\}\     hello} end end]\"
} {"\}\ "}
test lreplace-1.26 {lreplace command} {
    catch {unset foo}
    set foo {a b}
    list [set foo [lreplace $foo end end]] \
        [set foo [lreplace $foo end end]] \
        [set foo [lreplace $foo end end]]
} {a {} {}}


test lreplace-2.1 {lreplace errors} {
    list [catch lreplace msg] $msg
} {1 {wrong # args: should be "lreplace list first last ?element element ...?"}}
test lreplace-2.2 {lreplace errors} {
    list [catch {lreplace a b} msg] $msg
} {1 {wrong # args: should be "lreplace list first last ?element element ...?"}}
test lreplace-2.3 {lreplace errors} {
    list [catch {lreplace x a 10} msg] $msg
} {1 {bad index "a": must be integer or end?-integer?}}
test lreplace-2.4 {lreplace errors} {
    list [catch {lreplace x 10 x} msg] $msg
} {1 {bad index "x": must be integer or end?-integer?}}
test lreplace-2.5 {lreplace errors} {
    list [catch {lreplace x 10 1x} msg] $msg
} {1 {bad index "1x": must be integer or end?-integer?}}
test lreplace-2.6 {lreplace errors} {
    list [catch {lreplace x 3 2} msg] $msg
} {1 {list doesn't contain element 3}}
test lreplace-2.7 {lreplace errors} {
    list [catch {lreplace x 1 1} msg] $msg
} {1 {list doesn't contain element 1}}

test lreplace-3.1 {lreplace won't modify shared argument objects} {
    proc p {} {
        lreplace "a b c" 1 1 "x y"
        return "a b c"
    }
    p
} "a b c"

# cleanup
catch {unset foo}
::tcltest::cleanupTests
return
