/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;

public class ProjectMetadataBackup {
    private final List entries = new ArrayList();

    public void backup(URI projectLocation, String[] filenames) throws CoreException {
        IFileStore folder = EFS.getStore((URI)projectLocation);
        if (folder.fetchInfo().exists()) {
            int i = 0;
            while (i < filenames.length) {
                IFileStore file = folder.getChild(filenames[i]);
                if (file.fetchInfo().exists()) {
                    File backup = this.createBackup(file, String.valueOf(filenames[i].substring(1)) + "-desc");
                    this.entries.add(new BackupEntry(filenames[i], backup));
                }
                ++i;
            }
        }
    }

    public void restore(URI projectLocation, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", this.entries.size() * 2);
        try {
            int i = 0;
            while (i < this.entries.size()) {
                BackupEntry entry = (BackupEntry)this.entries.get(i);
                try {
                    IFileStore projectFile = EFS.getStore((URI)projectLocation).getChild(entry.filename);
                    projectFile.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    this.copyFile(entry.backup, projectFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (IOException e) {
                    Status status = new Status(4, "org.eclipse.dltk.ui", 4, NewWizardMessages.ScriptProjectWizardSecondPage_problem_restore_project, (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
                ++i;
            }
        }
        finally {
            this.entries.clear();
        }
    }

    private File createBackup(IFileStore source, String name) throws CoreException {
        try {
            File bak = File.createTempFile("eclipse-" + name, ".bak");
            this.copyFile(source, bak);
            return bak;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.dltk.ui", 4, Messages.format(NewWizardMessages.ScriptProjectWizardSecondPage_problem_backup, name), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void copyFile(IFileStore source, File target) throws IOException, CoreException {
        InputStream is = source.openInputStream(0, null);
        FileOutputStream os = new FileOutputStream(target);
        this.copyFile(is, os);
    }

    private void copyFile(File source, IFileStore target, IProgressMonitor monitor) throws IOException, CoreException {
        FileInputStream is = new FileInputStream(source);
        OutputStream os = target.openOutputStream(0, monitor);
        this.copyFile(is, os);
    }

    private void copyFile(InputStream is, OutputStream os) throws IOException {
        try {
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
        }
        finally {
            try {
                is.close();
            }
            finally {
                os.close();
            }
        }
    }

    private static class BackupEntry {
        final String filename;
        final File backup;

        public BackupEntry(String filename, File backup) {
            this.filename = filename;
            this.backup = backup;
        }
    }
}

