/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.ast.expressions;

import java.util.List;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.tcl.ast.TclArgument;
import org.eclipse.dltk.tcl.core.ITclSourceParser;
import org.eclipse.dltk.utils.CorePrinter;

public class TclBlockExpression
extends Expression {
    private String fBlockContent;
    private char[] fileName = null;
    private TclArgument processedArgument;

    public TclBlockExpression(int start, int end, String content) {
        this.setStart(start);
        this.setEnd(end);
        this.fBlockContent = content;
    }

    public void setProcessedArgument(TclArgument processedArgument) {
        this.processedArgument = processedArgument;
    }

    public TclArgument getProcessedArgument() {
        return this.processedArgument;
    }

    public int getKind() {
        return 10003;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Expression)this)) {
            visitor.endvisit((Expression)this);
        }
    }

    public void printNode(CorePrinter output) {
        output.formatPrintLn("tcl block:" + this.fBlockContent);
    }

    public String toString() {
        return "tcl block:" + this.fBlockContent;
    }

    public String getBlock() {
        return this.fBlockContent;
    }

    public void setFilename(char[] fileName) {
        this.fileName = fileName;
    }

    public List parseBlockSimple() {
        return this.parseBlockSimple(true);
    }

    public List parseBlockSimple(boolean useProcessors) {
        if (this.fBlockContent == null) {
            return null;
        }
        String content = this.fBlockContent.substring(1, this.fBlockContent.length() - 1);
        ITclSourceParser parser = null;
        parser = (ITclSourceParser)DLTKLanguageManager.getSourceParser((String)"org.eclipse.dltk.tcl.core.nature");
        parser.setProcessorsState(useProcessors);
        parser.setOffset(this.sourceStart() + 1);
        ModuleDeclaration module = parser.parse(this.fileName, content.toCharArray(), null);
        return module.getStatements();
    }
}

